'
'(C)1990, 1991 Marquis Computing - All Rights Reserved. Proudly written in
'pure BASIC by Hank Marquis.
'
'Writes a database record (DBF) to disk.
'

 DEFINT A-Z

 '--- DBF type & declarations
 '$INCLUDE: 'DBFUNC.BI'

 DECLARE SUB StampRecord (File, Records&)
 DECLARE SUB GetHeadSize (File, HeadSize)
 DECLARE SUB GetRecSize (File, RecSize)
 DECLARE SUB GetNumrecs (File, HeadRecs&)
 DECLARE SUB StampDate (File)
 DECLARE SUB SeekWrite (FileHandle, OffSet&, data$)
 DECLARE SUB SetMAXError (ErrNum)
 DECLARE SUB CheckFields (File)

 DECLARE FUNCTION MAXError (Msg$)

SUB PutRec (File, Record&, Record$)
 
   '
   'Writes the contents of Record$ to file at position Record&. Also
   'updates the date field of the DBF.
   '
   'Where:
   '
   '    Record& =  0 means append to end of file (returns record# in Record&)
   '    Record& >  0 means replace record number record&
   '

   '--- get DBF definition
   CheckFields File
  
   '--- get end of file, if needed
   IF Record& = 0 THEN
     '--- append to end of file
     GetNumrecs File, Rec&
     Rec& = Rec& + 1
   ELSE
     '--- append/replace as Record&
     Rec& = Record&
   END IF
  
   '--- setup for read
   RecSize = Fld(0).RecSize
   HeadSize = Fld(0).HeadSize
  
   '--- if bogus rec len boogy
   IF LEN(Record$) <> RecSize THEN
      SetMAXError 3003                  'invalid record size
      EXIT SUB                          'exit
   END IF
  
   '--- determine offset into dbf - recsize to move to start of record.
   OffSet& = (HeadSize + (RecSize * Rec&)) - RecSize
  
   '--- put the record into the dbf            
   SeekWrite File, OffSet&, Record$
  
   '--- update header record no.
   IF Record& = 0 THEN StampRecord File, Rec&
 
   '--- stamp date to header
   StampDate File

   '--- return record number if adding
   IF Record& = 0 THEN Record& = Rec&

END SUB

