'
'(C)1990, 1991 Marquis Computing - All Rights Reserved. Proudly written in
'pure BASIC by Hank Marquis.
'
'Removes deleted records from a database (DBF).
'

 DEFINT A-Z

 '--- DBF type & declarations
 '$INCLUDE: 'DBFUNC.BI'

 DECLARE SUB GetRec (File, Record&, Record$)
 DECLARE SUB PutRec (File, Record&, Record$)
 DECLARE SUB StampRecord (File, Records&)
 DECLARE SUB GetNumrecs (File, HeadRecs&)
 DECLARE SUB GetHeadSize (File, HeadSize)
 DECLARE SUB OpenDBF (File$, FileNum)
 DECLARE SUB CloseDBF (FileNum)

 DECLARE SUB SeekWrite (FileHandle, OffSet&, data$)
 DECLARE SUB SeekRead (FileHandle, OffSet&, data$)

 DECLARE SUB CloseFile (FileHandle)
 DECLARE SUB CreateFile (Filename$, FileHandle)
 DECLARE SUB KillFile (Filename$)
 DECLARE SUB NameFile (OldName$, NewName$)

SUB PackDBF (Filename$)
 
  '
  'Removes deleted records from the DBF. Operates by copying records from
  'filename$ to a temp file, then erasing filename and renaming the tempfile.
  'A record is deleted, by convention, if it's first character is a *.
  '
  'NOTE : The DBF to pack, and the packed DBF MUST be in the same drive.
  '
  'NOTE : This sub WILL ERASE the DBF to be packed when it is done copying
  '       the un-deleted records!
  '
  'NOTE : Use this ONLY with a database that is presently CLOSED!
  '
 
  '--- open old file
  OpenDBF Filename$, File
  GetNumrecs File, MaxRecs&
 
  '-- open new file
  tmpfile$ = "DBFTMP.TMP"
  CreateFile tmpfile$, Newfile

  '--- copy header to a new DBF
  GetHeadSize File, HeadSize
  Header$ = SPACE$(HeadSize)
  SeekRead File, 0, Header$     'get old header
  SeekWrite Newfile, 0, Header$ 'write new header

  '--- copy each non-deleted record
  FOR Count& = 1 TO MaxRecs&
 
    '--- get the next record (Record&=0)
    Record& = 0
    GetRec File, Count&, Record$

    '--- check it
    IF LEFT$(Record$, 1) <> "*" THEN
      '--- write the change to the DBF
      RecNum& = RecNum& + 1
      PutRec Newfile, (RecNum&), Record$
    END IF
 
  NEXT

  '--- stamp header with record numbers
  StampRecord Newfile, RecNum&
 
  '--- close up new file
  CloseFile Newfile
  CloseDBF File

  '--- delete file
  KillFile Filename$

  '--- change file name
  NameFile tmpfile$, Filename$
 
END SUB

