'
'(C)1990, 1991 Marquis Computing - All Rights Reserved. Proudly written in
'pure BASIC by Hank Marquis.
'
'Seeks to a file location and writes to a file using DOS calls: replaces
'QuickBASIC SEEK, WRITE, PUT and PRINT routines.
'
'NOTE: BASIC COMPILER 7.X users -- change VARSEG to SSEG.
'      QuickBASIC 4.X users     -- no modifications needed.
'

DEFINT A-Z

TYPE RegTypeX
  AX AS INTEGER
  BX AS INTEGER
  CX AS INTEGER
  DX AS INTEGER
  BP AS INTEGER
  SI AS INTEGER
  DI AS INTEGER
  Flags AS INTEGER
  DS AS INTEGER
  ES AS INTEGER
END TYPE

DECLARE SUB InterruptX (IntNum, InRegsX AS RegTypeX, OutRegsX AS RegTypeX)
DECLARE SUB SetMAXError (ErrNum)

SUB SeekWrite (FileHandle, OffSet&, Data$)

   '
   'Seeks to position OffSet& in file filehandle and then writes.
   'Writes data$ from a file opened using MAXBASIC. As often you use
   'Seek and then a write, I wrote this call to do them both. This is
   'faster then using SeekFile and then WriteFile.
   '
   'Sets MAXError to error if error occurs.
   '
   'NOTE : Maximum write is limited to amount of free BASIC memory
   '       you have PLUS it must be less than 32767 bytes.
   '
   'NOTE : The length of data$ determines how much data to write to
   '       filehandle. YOU MUST set data$ to the correct length BEFORE
   '       calling this routine. To write 25 bytes starting from byte 10:
   '
   '      data$ = SPACE$(25)         'sets data to a length of 25
   '      OffSet& = 10               'offset from top (0)
   '      SeekWrite filehandle, OffSet&, data$
   '
   '
  
   '--- assume invalid handle
   Status = 100                                         'invalid handle
  
   '--- if valid handle
   IF FileHandle > 0 THEN
  
        '---DOS type
        DIM Regs  AS RegTypeX
        Status = 0                                      'assume success

        '--- chop OffSet into High and Low integers
        HighByte& = OffSet& \ 32767
        LowByte& = OffSet& - (HighByte& * 32767)

        '--- do it
        Regs.AX = &H4200                        'DOS seek to
        Regs.BX = FileHandle                    'file
        Regs.CX = HighByte&                     'large portion
        Regs.DX = LowByte&                      'small portion
        InterruptX &H21, Regs, Regs             'seek to OffSet&
  
        '--- check for errors
        IF Regs.Flags AND 1 THEN
          SetMAXError Regs.AX                   'assign error from call
          EXIT SUB                              'exit
        END IF
   
        Regs.AX = &H4000                        'DOS write memory -> disk
        Regs.BX = FileHandle                    'file
        Regs.CX = LEN(Data$)                    'no. bytes to write
        Regs.DX = SADD(Data$)                   'offset of data
        Regs.DS = VARSEG(Data$)                 'segment of data
        InterruptX &H21, Regs, Regs             'write data$ to disk
   
        '--- check for errors
        IF Regs.Flags AND 1 THEN Status = Regs.AX

   END IF

   '--- error handler
   SetMAXError Status
  
END SUB

