'
'(C)1990, 1991 Marquis Computing - All Rights Reserved. Proudly written in
'pure BASIC by Hank Marquis.
'
'Removes all records from a database (DBF) file.
'

DEFINT A-Z

DECLARE SUB GetHeadSize (file, HeadSize)
DECLARE SUB GetNumrecs (file, HeadRecs&)
DECLARE SUB OpenDBF (file$, FileNum)
DECLARE SUB StampRecord (file, Records&)
DECLARE SUB CloseDBF (FileNum)
DECLARE SUB OpenFile (FileName$, filehandle)
DECLARE SUB CloseFile (filehandle)
DECLARE SUB KillFile (FileName$)
DECLARE SUB SeekWrite (filehandle, OffSet&, Data$)
DECLARE SUB SeekRead (filehandle, OffSet&, Data$)

DECLARE FUNCTION Exist (FileName$)

SUB ZAP (FileName$)
 
  '
  'PERMANENTLY Removes ALL records from the DBF.
  '
  'NOTE : Use this with a database that is presently CLOSED!
  '       ALL RECORDS IN FILENAME WILL BE DESTROYED!
  '
  'NOTE : Uses BASIC NAME routine, which means that an error MIGHT
  '       occur . . . so be aware. Still, chances of an error here
  '       are slim as if the file does not exist, the routine
  '       is exited immediately.

  '---exit if filename not found
  IF NOT Exist(FileName$) THEN EXIT SUB
 
  '---open old file
  OpenDBF FileName$, file
  GetNumrecs file, MaxRecs&

  '--open new file
  tmpfile$ = "~\/DBTMP.TMP"
  Newfile = FREEFILE
  OpenFile tmpfile$, Newfile

  '---copy header to a new DBF
  GetHeadSize file, HeadSize
  Header$ = SPACE$(HeadSize)
  SeekRead file, 0, Header$
  SeekWrite Newfile, 0, Header$

  '---stamp header with 0 records
  StampRecord Newfile, 0

  '---close up new file
  CloseFile Newfile
  CloseDBF file

  '---delete file & rename
  KillFile FileName$
  NAME tmpfile$ AS FileName$
 
END SUB

