'
'(C)1990, 1991 Marquis Computing - All Rights Reserved. Proudly written in
'pure BASIC by Hank Marquis.
'
'Returns the type (III, III+, IV) of a database (DBF)
'

 DEFINT A-Z

 DECLARE SUB GetHeadSize (File, HeadSize)
 DECLARE SUB SeekRead (FileHandle, OffSet&, Data$)

 DECLARE FUNCTION DBFVer$ (File)

FUNCTION DBFVer$ (File)

     'get dbase version number
    
     Type$ = SPACE$(1) '1 byte version
     SeekRead File, 0, Type$

     SELECT CASE Type$
      CASE CHR$(0)
       pdbfver$ = "II"
      CASE CHR$(3), CHR$(131)
       pdbfver$ = "III"
      CASE CHR$(0)
       pdbfver$ = "IV"
      CASE ELSE
       pdbfver$ = "UNK"
     END SELECT
   
     'first get end-of-header
     GetHeadSize File, HeadSize
    
     HeadSize& = HeadSize
   
     'figure out if this a III or III+ file
     IF INSTR("III", pdbfver$) THEN
      
       Type$ = SPACE$(1)                '1 byte to check if db iii+ or db iii
       SeekRead File, HeadSize&, Type$  'db III+ has CR @ end of header
     
       IF Type$ = CHR$(13) THEN
         pdbfver$ = "III+"
       ELSE
         SeekRead File, HeadSize& - 1, Type$  'db3
         IF Type$ = CHR$(13) THEN pdbfver$ = "III"
       END IF 'determine where hex 0D is
   
     END IF 'if a 3 or 3+ file
   
     'set ver
     DBFVer$ = pdbfver$

END FUNCTION

