'
'(C)1990, 1991 Marquis Computing - All Rights Reserved. Proudly written in
'pure BASIC by Hank Marquis.
'
'Writes a field value into a record. Does NOT write info to disk.
'

 DEFINT A-Z

 '--- DBF type & declarations
 '$INCLUDE: 'DBFUNC.BI'

 DECLARE SUB CheckFields (File)
 
 DECLARE FUNCTION MAXError (Msg$)

SUB PutField (FileNum, Record$, Fld, FldData$)
  
   '
   'Puts the contents of FldData$ into field Fld of record Record$.
   'Uses MAXBASIC FldInfo Fld() type array. FldData$ will be truncated to
   'fit into it's DBF fields defined area.
   '
   'NOTE: You must have opened a database to do this. Also, this data is
   '      NOT written to disk until you use a PutRec call.
   '
  
   '--- get DBF definition
   CheckFields FileNum
  
   '--- make a string the field length long
   FldD$ = STRING$(Fld(Fld).FLen, 0)            'thats a NULL string . . .
   LSET FldD$ = FldData$                        'assign the number

   '---assign it to the record
   MID$(Record$, Fld(Fld).OffSet, Fld(Fld).FLen) = FldD$
  
END SUB

