'
'(C)1990, 1991 Marquis Computing - All Rights Reserved. Proudly written in
'pure BASIC by Hank Marquis.
'
'Opens a database (DBF) file.
'

 DEFINT A-Z

 '--- DBF type & declarations
 '$INCLUDE: 'DBFUNC.BI'

 DECLARE SUB GetRecSize (File, RecSize)
 DECLARE SUB GetHeadSize (File, HeadSize)
 DECLARE SUB CheckFields (File)
 DECLARE SUB SetMAXError (ErrNum)
 DECLARE SUB OpenFile (filename$, FileHandle)
 DECLARE SUB CloseFile (FileHandle)
 DECLARE SUB OpenLAN (filename$, FileHandle, ReadWrite, ShareMode)

 DECLARE FUNCTION Exist (filename$)
 DECLARE FUNCTION Trim$ (A$)

SUB OpenDBF (File$, FileNum)
   
     '
     'Opens a database file, loads Fld() with DBF definition. If File$
     'is not found then FileNum is set to a (-1), otherwise FileNum is
     'some positive number -- the file handle for all future actions.
     '
     'On exit:
     '
     '  FileNum = File handle for this database for all other operations.
     '  Fld()   = Type array containing all relavent information about this
     '            DBF.
     '
    
     '--- if not exist then exit
     File$ = Trim(File$)                'strip blanks
    
     IF NOT Exist(File$) THEN           'does this file exist?
       FileNum = -1                     'set filenum to (-1) error code
       SetMAXError &H2                  'file not found
       EXIT SUB                         'bye-bye
     END IF
    
     '--- open DBF
     OpenFile File$, FileNum            'open as standalone
    
     '--- check DBF
     CheckFields FileNum                'get DBF definition

     '--- check for error
     IF Fld(0).Decimal < 1 THEN         'invalid file handle?
       CloseFile FileNum                'close file
       FileNum = -1                     'set to (-1) error code
       SetMAXError 3002                 'invalid DBF
     END IF
  
END SUB

