'
'(C)1990, 1991 Marquis Computing - All Rights Reserved. Proudly written in
'pure BASIC by Hank Marquis.
'
'Marks a database (DBF) record for deletion.
'
'

 DEFINT A-Z

 '--- DBF type & declarations
 '$INCLUDE: 'DBFUNC.BI'

 DECLARE SUB PutRec (File, Record&, Record$)
 DECLARE SUB GetRec (File, Record&, Record$)

SUB DeleteREC (File, Record&)
 
  '
  'Deletes Record& by writing a * to the first byte position of the record,
  'which, by convention is how you do it!
  '
  'NOTE: The record is not actually deleted, it is just marked for deletion
  '      for the next PACK operation.
  '
 
  '--- get the record
  GetRec File, Record&, Record$         'read the record
 
  '--- write the * to it
  MID$(Record$, 1, 1) = "*"             'put * in deleted field

  '--- write the change to the DBF
  PutRec File, Record&, Record$         'save record to DBF
 
END SUB

