'
'(C)1990, 1991 Marquis Computing - All Rights Reserved. Proudly written in
'pure BASIC by Hank Marquis.
'
'Loads a database (DBF) definition from it's header. Also, verifies DBF
'is valid.
'

 DEFINT A-Z

 '--- DBF type & declarations
 '$INCLUDE: 'DBFUNC.BI'

 DECLARE SUB GetHeadSize (File, HeadSize)
 DECLARE SUB GetRecSize (File, RecSize)
 DECLARE SUB SetMAXError (ErrNum)
 DECLARE SUB SeekRead (FileHandle, OffSet&, Data$)

 DECLARE FUNCTION SizeOf& (FileHandle)
 DECLARE FUNCTION FLOC& (FileHandle)

SUB CheckFields (File)
 
   '
   'Returns the definition of a DBF which is stored in it's header.
   '
   'Checks DBF for damage while loading a type array with this DBF's
   'information. Checks each field info to see if it is valid - if
   'valid count 'em up. If invalid, indicate so by setting field
   'counter variable Fld(0).Decimal = -1.
   '
   'On exit the type array Fld() holds the field names and definitions
   'for this DBF file. Fld(0).Decimal contains the quantity of fields.
   '
   'NOTE: Any current contents of Fld() passed to this routine WILL be
   '      erased and replaced by this call!
   '
   'NOTE: Use this call after a DBF is opened to retrieve it's structure.
   '
   'NOTE: If some of these offsets look odd, i.e., StartB& = 32 not 33
   '      it is because MAXBASIC FILEFUNC routines are 0 based; that is
   '      0 is the first byte. So 32 is really 33 -- 0 to 32 is 33.
   '
  
   '--- get info about this file
   GetHeadSize File, HeadSize           'size of header
   MaxFlds = (HeadSize - 32) \ 32       'maximum number of field this DBF

   '--- Dim Flds() to proper size
   REDIM Fld(0 TO MaxFlds)  AS FldInfo  'make Fld() array
  
   '---make some variables
   Status = 0                           'assume sucess
   OffSet = 1                           'start at 1st byte
   Flds = 1                             'start off with 1
   StartB& = 32                         'start @ byte 33
   Stopb& = SizeOf&(File)               'end of file
  
   '--- read the header
   Head = MaxFlds * 32                  'size of field block in header
   Header$ = STRING$(Head, 0)           'string to receive header
   SeekRead File, StartB&, Header$      'read header
  
   '--- process field data
   FOR X = 1 TO Head STEP 32
     
       '--- get a field descriptor
       type$ = MID$(Header$, X, 32)       'get a field descriptor
     
       '--- parse out field name & type
       fldname$ = MID$(type$, 1, 11)      'name at byte 1 - 11 bytes
       fldtype$ = MID$(type$, 12, 1)      'type at byte 12 - 1 byte
       fldlen = ASC(MID$(type$, 17, 1))   'length at byte 17 - 1 byte
       Decimal = ASC(MID$(type$, 18, 1))  'no. decimals at byte 18 - 1 byte

       '--- each field type has characteristics, assign them
       SELECT CASE fldtype$
         CASE "C"
           '--- CHARACTER file field type
           maxlen = 255
           minlen = 1
         CASE "N"
           '--- NUMERIC file field type
           maxlen = 19
           minlen = 1
         CASE "L"
           '--- LOGICAL file field type
           maxlen = 1
           minlen = 1
         CASE "D"
           '--- DECIMAL file field type
           maxlen = 8
           minlen = 8
         CASE "M"
           '--- MEMO file field type
           maxlen = 10
           minlen = 10
         CASE ELSE
           '--- oops! something BAD happened
           Status = 3002                        'invalid DBF
           FieldCount = -1                      'set invalid DBF
           EXIT FOR                             'exit
       END SELECT
    
      '--- error checking against fldlen
      IF fldlen > maxlen OR fldlen < minlen THEN
        '--- header dosen't match descriptor    'error
        Status = 3002                           'invalid DBF
        FieldCount = -1                         'error indicator
        EXIT FOR                                'exit
      END IF
     
      '--- save field definitions
      Fld(Flds).OffSet = OffSet + 1             'where field is in record
      Fld(Flds).Decimal = Decimal               'decimal places (if any)
      Fld(Flds).FLen = fldlen                   'length of field
      Fld(Flds).FType = fldtype$                'field type C, N, L, M etc
      Fld(Flds).FName = fldname$                'field name

      '--- bump up counters
      OffSet = OffSet + fldlen                  'pop record offset
      Flds = Flds + 1                           'pop field counter
    
  NEXT  'field

  '--- count up number of fields & set it
  IF Flds = 0 THEN FieldCount = -1              'in case first field is bad
  IF FieldCount = 0 THEN FieldCount = Flds      'if no errors set fld count
  Fld(0).Decimal = FieldCount - 1               '-1 to offset for count
  Fld(0).HeadSize = HeadSize                    'set headsize
  Fld(0).RecSize = OffSet                       'set recsize

  '--- error handler
  SetMAXError Status                            'set error level
 
END SUB

