' ¿
'  Name     : BOXES                                                     
'  Type     : Toolbox                                                   
'  Module   : BOXES.BAS                                                 
'  Language : MicroSoft QuickBASIC Version 4.5                          
'  Source   : LAMCO Software                                            
' 
'  DESCRIPTION ¿
'  This Toolbox contains several SubPrograms that draw different kinds  
'  of boxes on screen                                                   
' 
'  REQUIREMENTS ¿
'  CGA                                                                  
' 
'  .MAK FILE ¿
'  (not required)                                                       
' 
'  COMMAND LINE PARAMETERS ¿
'  (none)                                                               
' 
'  VARIABLES ¿
'  (none)                                                               
' 


' Subprograms
  DECLARE SUB DoubleBorderBox (tr%, br%, lc%, rc%)
  DECLARE SUB DoubleBorderFullShadeBox (tr%, br%, lc%, rc%, sc%)
  DECLARE SUB HalfShadeBox (tr%, br%, lc%, rc%, bg%, bc%, sc%)
  DECLARE SUB NoBorderBox (tr%, br%, lc%, rc%)
  DECLARE SUB NoBorderFullShadeBox (tr%, br%, lc%, rc%, sc%)
  DECLARE SUB SingleBorderBox (tr%, br%, lc%, rc%)
  DECLARE SUB SingleBorderFullShadeBox (tr%, br%, lc%, rc%, sc%)

' Beginning of the module level

  ' Demonstrate the different boxes drawn by BOXES.BAS

  ' Clear screen to black on white with a grey border
    COLOR 8, 7, 8: CLS

  ' Draw a box with no border and no shade
    COLOR 15, 1: NoBorderBox 2, 12, 2, 25
    LOCATE 6, 10: PRINT "No border"
    LOCATE 8, 10: PRINT "No shade"

  ' Draw a box with a single border but no shade
    SingleBorderBox 2, 12, 28, 52
    LOCATE 6, 34: PRINT "Single border"
    LOCATE 8, 34: PRINT "No shade"

  ' Draw a box with a double border but no shade
    DoubleBorderBox 2, 12, 55, 79
    LOCATE 6, 61: PRINT "Double border"
    LOCATE 8, 61: PRINT "No shade"

  ' Draw a box with no border but with full shade
    NoBorderFullShadeBox 14, 24, 2, 25, 0
    COLOR 15, 1: LOCATE 18, 8: PRINT "No border"
    LOCATE 20, 8: PRINT "Full shade"

  ' Draw a box with a single border and full shade
    SingleBorderFullShadeBox 14, 24, 28, 52, 0
    COLOR 15, 1: LOCATE 18, 33: PRINT "Single border"
    LOCATE 20, 33: PRINT "Full shade"

  ' Draw a box with a double border and full shade
    DoubleBorderFullShadeBox 14, 24, 55, 79, 0
    COLOR 15, 1: LOCATE 18, 60: PRINT "Double border"
    LOCATE 20, 60: PRINT "Full shade"
    BEEP: DO: LOOP UNTIL INKEY$ <> ""

  ' Draw a box with no border and a half shade
    COLOR 8, 7, 8: CLS
    HalfShadeBox 7, 19, 26, 55, 7, 1, 0
    COLOR 15, 1: LOCATE 12, 35: PRINT "No border"
    LOCATE 14, 35: PRINT "Half shade"
    BEEP: DO: LOOP UNTIL INKEY$ <> ""

  ' Clear screen to white on blue with a grey border
    COLOR 15, 1, 8: CLS

  ' End of the module level
    END

'  SUBPROGRAM ¿
'  Name : DoubleBorderBox                                               
' 
'  DESCRIPTION ¿
'  Draws a box with a double-line border but no shade                   
' 
'  PARAMETERS ¿
'  br% - Bottom row of the box                                          
'  lc% - Left column of the box                                         
'  rc% - Right column of the box                                        
'  tr% - Top row of the box                                             
' 
'  VARIABLES ¿
'  i%  - Looping index                                                  
' 
'  MODULE LEVEL DECLARATIONS ¿
'  DECLARE SUB DoubleBorderBox (tr%, br%, lc%, rc%)                     
' 
SUB DoubleBorderBox (tr%, br%, lc%, rc%) STATIC
 
  LOCATE tr%, lc%: PRINT CHR$(201); STRING$(rc% - lc% - 1, 205); CHR$(187);
  FOR i% = tr% + 1 TO br% - 1
    LOCATE i%, lc%: PRINT CHR$(186); STRING$(rc% - lc% - 1, 32); CHR$(186);
  NEXT i%
  LOCATE br%, lc%: PRINT CHR$(200); STRING$(rc% - lc% - 1, 205); CHR$(188);

END SUB

'  SUBPROGRAM ¿
'  Name : DoubleBorderFullShadeBox                                      
' 
'  DESCRIPTION ¿
'  Draws a box with a double-line border and a shade that is two        
'  characters large and a full line high                                
' 
'  PARAMETERS ¿
'  br% - Bottom row of the box                                          
'  lc% - Left column of the box                                         
'  rc% - Right column of the box                                        
'  sc% - Color code of the shade                                        
'  tr% - Top row of the box                                             
' 
'  VARIABLES ¿
'  i%  - Looping index                                                  
' 
'  MODULE LEVEL DECLARATIONS ¿
'  DECLARE SUB DoubleBorderFullShadeBox (tr%, br%, lc%, rc%, sc%)       
' 
SUB DoubleBorderFullShadeBox (tr%, br%, lc%, rc%, sc%) STATIC
 
  LOCATE tr%, lc%: PRINT CHR$(201); STRING$(rc% - lc% - 3, 205); CHR$(187);
  FOR i% = tr% + 1 TO br% - 2
    LOCATE i%, lc%: PRINT CHR$(186); STRING$(rc% - lc% - 3, 32); CHR$(186);
  NEXT i%
  LOCATE br% - 1, lc%
  PRINT CHR$(200); STRING$(rc% - lc% - 3, 205); CHR$(188);
  COLOR , sc%
  FOR i% = tr% + 1 TO br%
    LOCATE i%, rc% - 1: PRINT STRING$(2, 32);
  NEXT i%
  LOCATE br%, lc% + 2: PRINT STRING$(rc% - lc% - 1, 32);

END SUB

'  SUBPROGRAM ¿
'  Name : HalfShadeBox                                                  
' 
'  DESCRIPTION ¿
'  Draws a box with no border and a shade that is one character large   
'  and one half-line high                                               
' 
'  PARAMETERS ¿
'  bc% - Background color of the box                                    
'  br% - Bottom row of the box                                          
'  bg% - Background color of the screen                                 
'  lc% - Left column of the box                                         
'  rc% - Right column of the box                                        
'  sc% - Color code of the shade                                        
'  tr% - Top row of the box                                             
' 
'  VARIABLES ¿
'  i%  - Looping index                                                  
' 
'  MODULE LEVEL DECLARATIONS ¿
'  DECLARE SUB HalfShadeBox (tr%, br%, lc%, rc%, bg%, bc%, sc%)         
' 
SUB HalfShadeBox (tr%, br%, lc%, rc%, bg%, bc%, sc%) STATIC
 
  COLOR bc%: LOCATE tr%, lc%: PRINT STRING$(rc% - lc%, 220);
  FOR i% = tr% + 1 TO br% - 1
    LOCATE i%, lc%: PRINT STRING$(rc% - lc%, 219);
  NEXT i%
  LOCATE br%, lc%: PRINT CHR$(223);
  COLOR , sc%: PRINT STRING$(rc% - lc% - 1, 223);
  FOR i% = tr% + 1 TO br%
    LOCATE i%, rc%: PRINT CHR$(32);
  NEXT i%

END SUB

'  SUBPROGRAM ¿
'  Name : NoBorderBox                                                   
' 
'  DESCRIPTION ¿
'  Draws a box with no border and no shade                              
' 
'  PARAMETERS ¿
'  br% - Bottom row of the box                                          
'  lc% - Left column of the box                                         
'  rc% - Right column of the box                                        
'  tr% - Top row of the box                                             
' 
'  VARIABLES ¿
'  i%  - Looping index                                                  
' 
'  MODULE LEVEL DECLARATIONS ¿
'  DECLARE SUB NoBorderBox (tr%, br%, lc%, rc%)                         
' 
SUB NoBorderBox (tr%, br%, lc%, rc%) STATIC
 
  FOR i% = tr% TO br%
    LOCATE i%, lc%: PRINT STRING$(rc% - lc% + 1, 32);
  NEXT i%

END SUB

'  SUBPROGRAM ¿
'  Name : NoBorderFullShadeBox                                          
' 
'  DESCRIPTION ¿
'  Draws a box with no border but a shade that is two characters large  
'  and one line high                                                    
' 
'  PARAMETERS ¿
'  br% - Bottom row of the box                                          
'  lc% - Left column of the box                                         
'  rc% - Right column of the box                                        
'  sc% - Color code of the shade                                        
'  tr% - Top row of the box                                             
' 
'  VARIABLES ¿
'  i%  - Looping index                                                  
' 
'  MODULE LEVEL DECLARATIONS ¿
'  DECLARE SUB NoBorderFullShadeBox (tr%, br%, lc%, rc%, sc%)           
' 
SUB NoBorderFullShadeBox (tr%, br%, lc%, rc%, sc%) STATIC
 
  FOR i% = tr% TO br% - 1
    LOCATE i%, lc%: PRINT STRING$(rc% - lc% - 1, 32);
  NEXT i%
  COLOR , sc%
  FOR i% = tr% + 1 TO br%
    LOCATE i%, rc% - 1: PRINT STRING$(2, 32);
  NEXT i%
  LOCATE br%, lc% + 2: PRINT STRING$(rc% - lc% - 1, 32);

END SUB

'  SUBPROGRAM ¿
'  Name : SingleBorderBox                                               
' 
'  DESCRIPTION ¿
'  Draws a box with a single border line but no shade                   
' 
'  PARAMETERS ¿
'  br% - Bottom row of the box                                          
'  lc% - Left column of the box                                         
'  rc% - Right column of the box                                        
'  tr% - Top row of the box                                             
' 
'  VARIABLES ¿
'  i%  - Looping index                                                  
' 
'  MODULE LEVEL DECLARATIONS ¿
'  DECLARE SUB SingleBorderBox (tr%, br%, lc%, rc%)                     
' 
SUB SingleBorderBox (tr%, br%, lc%, rc%) STATIC
 
  LOCATE tr%, lc%: PRINT CHR$(218); STRING$(rc% - lc% - 1, 196); CHR$(191);
  FOR i% = tr% + 1 TO br% - 1
    LOCATE i%, lc%: PRINT CHR$(179); STRING$(rc% - lc% - 1, 32); CHR$(179);
  NEXT i%
  LOCATE br%, lc%: PRINT CHR$(192); STRING$(rc% - lc% - 1, 196); CHR$(217);

END SUB

'  SUBPROGRAM ¿
'  Name : SingleBorderFullShadeBox                                      
' 
'  DESCRIPTION ¿
'  Draws a box with a single border line and a full shade               
' 
'  PARAMETERS ¿
'  br% - Bottom row of the box                                          
'  lc% - Left column of the box                                         
'  rc% - Right column of the box                                        
'  sc% - Color code of the shade                                        
'  tr% - Top row of the box                                             
' 
'  VARIABLES ¿
'  i%  - Looping index                                                  
' 
'  MODULE LEVEL DECLARATIONS ¿
'  DECLARE SUB SingleBorderFullShadeBox (tr%, br%, lc%, rc%, sc%)       
' 
SUB SingleBorderFullShadeBox (tr%, br%, lc%, rc%, sc%) STATIC
 
  LOCATE tr%, lc%: PRINT CHR$(218); STRING$(rc% - lc% - 3, 196); CHR$(191);
  FOR i% = tr% + 1 TO br% - 2
    LOCATE i%, lc%: PRINT CHR$(179); STRING$(rc% - lc% - 3, 32); CHR$(179);
  NEXT i%
  LOCATE br% - 1, lc%
  PRINT CHR$(192); STRING$(rc% - lc% - 3, 196); CHR$(217);
  COLOR , sc%
  FOR i% = tr% + 1 TO br%
    LOCATE i%, rc% - 1: PRINT STRING$(2, 32);
  NEXT i%
  LOCATE br%, lc% + 2: PRINT STRING$(rc% - lc% - 1, 32);

END SUB

