; READSUB - absolute disk read subroutine for compiled BASIC
; CALL READSUB(DRIVE%,SECTOR%,BUF$)
; DRIVE% = 0 if A:, 1 if B:, etc.
; SECTOR% - relative sector number (starting at 0)
; BUF$ - 512 byte buffer for sector's data
cseg   segment para public 'code'
public readsub
readsub proc far
    assume cs:cseg,ds:nothing,ss:nothing,es:nothing
    push bp
    mov bp,sp
    push es          ; save es
    mov si,[bp+10]   ; drive no
    mov ax,[si]
    mov cx,1         ; read 1 sector
    mov si,[bp+8]    ; sector no
    mov dx,[si]
    mov si,[bp+6]    ; buffer
    add si,2
    mov bx,[si]
    mov es,bp        ; save bp
    int 25h          ; bios absolute read
    mov bp,es        ; restore bp
    jc p88           ; error
    mov ax,0         ; no error - clear ax
p88:popf
    mov ah,0         ; leave any error in al
    mov si,[bp+8]
    mov [si],ax      ; return error in sector arg
    pop es           ; restore es
    pop bp           ; return to caller
    ret 6
readsub endp
cseg ends
    end
