;*********************************;
; PARADOX Script: PicLkUp         ;
;                                 ;
; ValCheck, Version 1.1           ;
; 15 Jan 92                       ;
; Informant Communications Group  ;
;                                 ;
; Required Scripts:               ;
;   GetValCk                      ;
;   ValCheck                      ;
;   PicLkUp                       ;
;   TabLkUp                       ;
;                                 ;
; Required Tables                 ;
;   PicTab                        ;
;*********************************;

CREATELIB "PicLkUp"

;***************************************************;
; LookUpPic() provides a "lookup" of predefined     ;
; "pictures" located in a Table named PicTab; it    ;
; calls PicLkUpScr() to open a window then displays ;
; the list of picture choices and manages input.    ;
;***************************************************;
PROC LookUpPic()
  PRIVATE c,CurrRec,LineCount,CurrLine,NextLine,
          TopRec,RecCount,TotalRecs,WorkTab

  IF NOT ISTABLE(SDIR()+"PicTab")
    THEN BEEP
         MESSAGE "Picture lookup table not present..."
         SLEEP 1500
         RETURN
  ENDIF
  ;
  ; initialize variables
  ;
  CurrRec  =1
  LineCount=1
  CurrLine =1
  NextLine =2
  TopRec   =1
  RecCount =0
  TotalRecs=NRECORDS(SDIR()+"PicTab")

  CANVAS OFF
  CURSOR OFF
  ;
  ; display picture lookup window
  ;
  PicLkUpScr()
  ;
  ; get name of current table in order to
  ; manage movement between images, and
  ; place "picture" table on workspace
  ;
  WorkTab=TABLE()
  DO_IT!
  View SDIR()+"PicTab"

  WHILE True
    RecCount=TopRec
    MOVETO RECORD TopRec
    STYLE ATTRIBUTE 79
    @7,0
    ;
    ; write picture element titles and picture
    ; strings to the scrollable window
    ;
    WHILE RecCount<=TotalRecs AND LineCount<8
      ?" "+FORMAT("w11,ar",[Title])+": "+
       FORMAT("w20,al",[Picture])
      RecCount=RecCount+1
      LineCount=LineCount+1
      DOWN
    ENDWHILE
    ;
    ; if more than one screen (7 records), display
    ; markers indicating scroll directions
    ;
    IF TotalRecs>7
      THEN IF TopRec>1
             THEN @8,42 ??CHR(30)
           ENDIF
           IF LineCount=8
             THEN IF RecCount<=TotalRecs
                    THEN @14,42 ??CHR(31)
                  ENDIF
             ELSE @6+LineCount,42
           ENDIF
    ENDIF
    ;
    ; if less than one full screen, clear
    ; remaining display of unwanted lines
    ;
    WHILE LineCount<8
      ?SPACES(34)
      LineCount=LineCount+1
    ENDWHILE
    LineCount=1

    WHILE True
      ;
      ; highlight current choice
      ;
      PAINTCANVAS
        ATTRIBUTE 116
        CurrLine+7,55,CurrLine+7,75
      CANVAS ON
      ;
      ; wait for user input
      ;
      c=GETCHAR()

      SWITCH
        CASE c=-72:                     ;Up
          IF CurrRec>1
            THEN CurrRec=CurrRec-1
                 NextLine=CurrLine-1
            ELSE BEEP
                 LOOP
          ENDIF
        CASE c=-80:                     ;Down
          IF CurrRec<TotalRecs
            THEN CurrRec=CurrRec+1
                 NextLine=CurrLine+1
            ELSE BEEP
                 LOOP
          ENDIF
        CASE c=-73:                     ;PgUp
          IF TopRec>7
            THEN TopRec=TopRec-6
            ELSE IF TopRec=1
                   THEN BEEP
                        LOOP
                   ELSE TopRec=1
                 ENDIF
          ENDIF
          CurrRec=TopRec
          CurrLine=1
          CANVAS OFF
          QUITLOOP
        CASE c=-81:                     ;PgDn
          IF TotalRecs>TopRec+6
            THEN TopRec=TopRec+6
            ELSE BEEP
                 LOOP
          ENDIF
          CurrRec=TopRec
          CurrLine=1
          CANVAS OFF
          QUITLOOP
        CASE c=-71:                     ;Home
          IF TopRec>1
            THEN TopRec=1
            ELSE BEEP
                 LOOP
          ENDIF
          CurrRec=TopRec
          CurrLine=1
          CANVAS OFF
          QUITLOOP
        CASE c=-79:                     ;End
          IF TopRec<TotalRecs-6
            THEN TopRec=TotalRecs-6
            ELSE BEEP
                 LOOP
          ENDIF
          CurrRec=TotalRecs
          CurrLine=TotalRecs-TopRec+1
          CANVAS OFF
          QUITLOOP
        CASE c=13:                      ;Enter
          ;
          ; 'picture' equals choice
          ;
          MOVETO RECORD CurrRec
          Val[4]=[Picture]
          SETMARGIN OFF
          CLEARIMAGE
          MOVETO WorkTab
          EDITKEY
          RETURN True
        CASE c=27:                      ;Esc
          ;
          ; return with no change
          ;
          SETMARGIN OFF
          CLEARIMAGE
          MOVETO WorkTab
          EDITKEY
          RETURN False
        OTHERWISE:
          BEEP
      ENDSWITCH
      CANVAS OFF
      IF NextLine<1
        THEN TopRec=TopRec-1
             CurrLine=1
             QUITLOOP
        ELSE IF NextLine>7
               THEN TopRec=TopRec+1
                    CurrLine=7
                    QUITLOOP
             ENDIF
      ENDIF
      ;
      ; clear highlight
      ;
      PAINTCANVAS
        ATTRIBUTE 79
        CurrLine+7,55,CurrLine+7,75
      CurrLine=NextLine
    ENDWHILE
  ENDWHILE
ENDPROC


;***********************************************;
; PicLkUpScr() is called by LookUpPic() to open ;
; the window used to list the Picture elements  ;
; predefined in Table PicTab.                   ;
;***********************************************;
PROC PicLkUpScr()
  ;
  ; paint shadow
  ;
  PAINTCANVAS
    ATTRIBUTE 8
    6,42,18,77

  STYLE ATTRIBUTE 79
  @5,41
  SETMARGIN 41

TEXT
Ŀ
   P I C T U R E    L O O K U P   
Ĵ
                                  
                                  
                                  
                                  
                                  
                                  
                                  
Ĵ
[] Move  [] Select  [ESC] Quit

ENDTEXT

  SETMARGIN 42
ENDPROC


WRITELIB "PicLkUp" LookUpPic,PicLkUpScr
RELEASE PROCS LookUpPic,PicLkUpScr
