;***************************************************************************
;Places a dialog box with a list of current Paradox users and a list of
;users currently logged onto Novell.  Also displays the current system
;time.  Selecting one of the Novell users will display an additional
;dialog box prompting for a message to be sent, via Novell's SEND, to that
;user.
;
;This was modified from an application where the system administrator
;wanted to be able to send Novell messages from within the application
;asking users to log out of the system.  I've found it to be a handy utility
;to access with a hot key from my station during development, especially if
;I want to send a Novell message without leaving Paradox.
;
;The list of Paradox users is updated every 5 seconds.  The list of Novell
;users is updated every 2 minutes.  These time spans are quite random and
;can be easily changed.  Look for tick.paradox and tick.novell.
;
;Enjoy.
;
;Brad Skiles
;CSERVE:  73404,1543 (personal)
;         76150,2427 (corporate)
;***************************************************************************
PROC FancyBox()
PRIVATE currentuser,selecteduser,buttonselect
; PaintPAL_Generated_Code_Begin(474058860)
msg = "Waiting..."
SHOWDIALOG ""
  PROC "FancyProc"
  TRIGGER "OPEN","SELECT" IDLE KEY "ENTER"
  @0,0 HEIGHT 26 WIDTH 81

  PICKDYNARRAY @5,7
     HEIGHT  5
     WIDTH   30
     COLUMNS 2
     PARADOXUSERS
     TAG "PARADOXUSERS"
  TO currentuser

  LABEL @3,11 "CURRENT ~P~ARADOX USERS"
  FOR "PARADOXUSERS"

  @11,14 ?? "Paradox Users:  "+STRVAL(DYNARRAYSIZE(PARADOXUSERS))

  @15,15 ?? "TIME"
  @17,13 ?? TIME()

  LABEL @3,48 "CURRENT ~N~OVELL USERS"
  FOR "NovellUsers"

  @4,45 ?? "Name            Time"

  PICKDYNARRAY @6,45 HEIGHT 10 WIDTH 25
    NovellUser
    TAG "NovellUsers"
    TO SelectedUser

  @17,51 ?? "Novell Users:  "+STRVAL(DYNARRAYSIZE(NovellUser))

;Don't need both of these buttons right now but may want them in the future.
  PUSHBUTTON @20,26 WIDTH 6
    "~O~k"
	 OK
    VALUE "ok"
    TAG "OK"
    TO ButtonSelect

  PUSHBUTTON @20,41 WIDTH 9
	 "~C~ancel"
	 CANCEL
	 VALUE "cancel"
	 TAG "CANCEL"
	 TO ButtonSelect

;Paint the entire background of the dialog box.
  PAINTCANVAS ATTRIBUTE 48 0,0,23,78

;The pattern is similar for painting each of the frames.

  ;Place the frame around the time.
  FRAME SINGLE FROM 16,12 TO 18,21 		;Inner Frame
  FRAME SINGLE FROM 14,10 TO 19,23		;Outer Frame
  PAINTCANVAS ATTRIBUTE 59 14,10,19,10 ;Outer Frame--Left Line
  PAINTCANVAS ATTRIBUTE 59 14,10,14,22 ;Outer Frame--Top Line
  PAINTCANVAS ATTRIBUTE 59 16,21,18,21 ;Inner Frame--Right line
  PAINTCANVAS ATTRIBUTE 59 18,13,18,21 ;Inner Frame--Bottom Line

  ;Place the frame around the Novell Users.
  FRAME SINGLE FROM 5,44 TO 16,72      ;Inner Frame
  FRAME SINGLE FROM 2,42 TO 18,74		;Outer Frame
  PAINTCANVAS ATTRIBUTE 59 2,42,18,42
  PAINTCANVAS ATTRIBUTE 59 2,42,2,73
  PAINTCANVAS ATTRIBUTE 59 5,72,16,72
  PAINTCANVAS ATTRIBUTE 59 16,45,16,72

  ;Place the frame around the Paradox Users.
  FRAME SINGLE FROM 4,6 TO 10,37       ;Inner Frame
  FRAME SINGLE FROM 2,4 TO 12,39       ;Outer Frame
  PAINTCANVAS ATTRIBUTE 59 2,4,12,4
  PAINTCANVAS ATTRIBUTE 59 2,4,2,38
  PAINTCANVAS ATTRIBUTE 59 4,37,10,37
  PAINTCANVAS ATTRIBUTE 59 10,7,10,37

  ;The following places the outside frames of the entire dialog box.
  FRAME SINGLE FROM 0,0 TO 23,78
  FRAME SINGLE FROM 1,2 TO 22,76
  PAINTCANVAS ATTRIBUTE 59 0,0,23,0
  PAINTCANVAS ATTRIBUTE 59 0,0,0,77
  PAINTCANVAS ATTRIBUTE 59 1,76,22,76
  PAINTCANVAS ATTRIBUTE 59 22,3,22,76
ENDDIALOG
; PaintPAL_Generated_Code_End(474058860)
CLEARIMAGE
ENDPROC

PROC FancyProc(TriggerType,TagValue,EventValue,ElementValue)
PRIVATE FancyName,FancyArray,FancyColors

SWITCH
	CASE TriggerType = "OPEN":  ;Set up attributes and colors of the dialog
    WINDOW HANDLE DIALOG       ;box when the box is first opened.
	 TO FancyName
	 WINDOW GETATTRIBUTES FancyName TO FancyArray
	 FancyArray["HasFrame"] = FALSE   ;Turn off the darn default frame.
	 WINDOW SETATTRIBUTES FancyName FROM FancyArray
;Change the colors of the dialog box according to the listing of color
;attributes on pages 386-387 of PAL REFERENCE guide.
	 WINDOW GETCOLORS FancyName TO FancyColors
	 FancyColors[6]  = 48      ;Text for label when inactive
	 FancyColors[7]  = 30      ;Text for label when active
	 FancyColors[8]  = 31      ;Hot key for label
	 FancyColors[9]  = 127     ;Text for normal push button label
	 FancyColors[10] = 113		;Text for default push button label
	 FancyColors[11] = 30		;Text for selected push button label
	 FancyColors[13] = 31		;Hot key for push button label
	 FancyColors[14] = 48		;Button Shadow
;Now apply the colors back to the dialog box.
	 WINDOW SETCOLORS FancyName FROM FancyColors

;The only "EVENT" being trapped is IDLE, so checking TriggerType for "EVENT"
;is sufficient.
	CASE TriggerType = "EVENT":
      IF EventValue["TYPE"] = "KEY" THEN
         IF TagValue = "NovellUsers" THEN
            NovellMessage()
            IF RETVAL THEN    ;Send the entered message.
               msg = "\""+NovellMessage+"\""
               RUN BIG NOREFRESH NORESTORE "SEND "+msg+"TO "+
               SUBSTR(NovellUser[SelectedUser],1,14)
               MESSAGE "Novell Message Sent!"
               ;Charge!
               SOUND 100 150 SLEEP 50 SOUND 100 150 SLEEP 50
               SOUND 100 150 SLEEP 50 SOUND 300 400 SLEEP 50
               SOUND 100 150 SLEEP 50 SOUND 300 400
               MESSAGE ""
            ENDIF
         ENDIF
;Paradox user name may not be the Novell login name, so don't allow message
;to be sent from here.
         IF TagValue = "PARADOXUSERS" THEN
            MESSAGE "You may only send messages to Novell Users."
            ;Rasberry! (Or as close as I could get!)
            SOUND 10 1500
            SLEEP 1500
            MESSAGE ""
         ENDIF
      ENDIF
      IF NOT ISASSIGNED(tick.paradox) THEN
   		tick.paradox = TICKS()      ;To keep track of elapsed time.
			tick.novell  = TICKS()
		ELSE
;If 5 seconds have elapsed, check to see if Paradox Users has changed.
   		IF TICKS() - tick.paradox > 5000 THEN   ;5 seconds elapsed.
				ParadoxUsers()
      		tick.paradox = TICKS()   ;Update tick.old value.
   		ENDIF
		ENDIF
;Check for new Novell users every 2 minutes.
      IF TICKS() - tick.novell > 120000 THEN    ;2 minutes elapsed
			NovellUsers()
         tick.novell = TICKS()       ;Update tick.novell value.
		ENDIF
		REFRESHDIALOG  ;Do this everytime to update clock.

   CASE TriggerType = "SELECT" AND TagValue = "NovellUsers":
      NovellMessage()
      IF RETVAL THEN    ;Send the entered message.
      msg = "\""+NovellMessage+"\""
RUN BIG NOREFRESH NORESTORE "SEND "+msg+"TO "+SUBSTR(NovellUser[SelectedUser],1,14)
         MESSAGE "Novell Message Sent!"
         ;CHARGE!
         SOUND 100 150 SLEEP 50 SOUND 100 150 SLEEP 50
         SOUND 100 150 SLEEP 50 SOUND 300 400 SLEEP 50
         SOUND 100 150 SLEEP 50 SOUND 300 400
         MESSAGE ""
      ENDIF
ENDSWITCH
ENDPROC

PROC ParadoxUsers()
;Generate list of Paradox Users.
MENU {tools} {INFO} {who}
DYNARRAY PARADOXUSERS[]
SCAN
   PARADOXUSERS[RECNO()] = [UserName]
ENDSCAN
ENDPROC

PROC NovellUsers()
;Generate list of Novell Users.
RUN BIG NOREFRESH "USERLIST > USERL.SC"  ;Place user list in a script.
;Import USERL.SC to USERL.DB.
{TOOLS} {EXPORTIMPORT} {IMPORT} {ASCII} {TEXT}
TYPEIN "USERL.SC" ENTER TYPEIN "USERL" ENTER
IF MENUCHOICE() = "Cancel" THEN
	{Replace}
ENDIF
{TOOLS} {DELETE} {SCRIPT} TYPEIN "USERL" ENTER {OK}  ;Clean up.
COEDITKEY   ;We are on the USERL table.
;Clean up the unneeded rows in the USERL table.
WHILE TRUE
	IF SEARCH("User Name",[Text]) = 0 THEN
		DEL   ;Removes text fields at the top of the table.
	ELSE
      DEL   ;We don't need this record.
		DEL   ;We don't need this one either.
		QUITLOOP
	ENDIF
ENDWHILE
;Now pull the user name and Login time into a DYNARRAY.
;NOTE:  13,14 pulls in the user Name and 39,11 pulls in a space and the
;		  Login time.
DYNARRAY NovellUser[]
SCAN
	NovellUser[RECNO()] = SUBSTR([Text],13,14)+
								 SUBSTR([Text],39,11)
ENDSCAN
DO_IT!    ;Return to main mode.
DELETE "Userl"   ;Remove the table.
ENDPROC


PROC NovellMessage()
ButtonSelect = ""
; PaintPAL_Generated_Code_Begin(475818229)

SHOWDIALOG ""  ; C:\PARADOX\TOOLS40\NEW.DLG
   @9,12 HEIGHT 9 WIDTH 57

   ; PaintPAL_Static_Text_Begin
   PAINTCANVAS FILL " " ATTRIBUTE 112 1,10,1,44
   @0,10
   ?? "ENTER MESSAGE TO SEND TO "+SUBSTR(NovellUser[SelectedUser],1,14)
   PAINTCANVAS ATTRIBUTE 112 1,10,1,44
   ; PaintPAL_Static_Text_End

   ; PaintPAL_Static_Text_Begin
   PAINTCANVAS FILL " " ATTRIBUTE 112 6,1,6,10
   @3,1
   ?? "Message:  "
   PAINTCANVAS ATTRIBUTE 112 3,1,3,10
   ; PaintPAL_Static_Text_End

   ;Set width to Novell maximum width for a SEND message.
   ACCEPT @3,11 WIDTH 43
      "A40"
      TAG "NovellMessage"
      TO NovellMessage

   LABEL @2,23
      "~N~ovell Message"
      FOR "NovellMessage"

   PUSHBUTTON @5,12 WIDTH 10
      "~O~k"
      OK
      VALUE "OK"
      TAG "Ok"
      TO ButtonSelect

   PUSHBUTTON @5,33 WIDTH 10
      "~C~ancel"
      CANCEL
      VALUE "Cancel"
      TAG "Cancel"
      TO ButtonSelect
ENDDIALOG
IF ButtonSelect = "OK" THEN
   RETURN TRUE
ELSE
   RETURN FALSE
ENDIF
; PaintPAL_Generated_Code_End(475818229)
ENDPROC

;*****************************************************************************
;Only run on Novell.
IF NOT NETTYPE() = "Novell" THEN
   MESSAGE "Sorry.  You must run this on a Novell LAN."
   SOUND 100 50 SOUND 30 100 SOUND 100 50
   SLEEP 1500
   RETURN
ENDIF

;Must in Main mode.  Could execute a Do_It!, but that might mess someone up.
IF SYSMODE() <> "Main" THEN
   MESSAGE "Sorry.  You must be in MAIN mode to run the User List."
   SOUND 100 150 SOUND 30 200 SOUND 100 150
   SLEEP 1500
   RETURN
ENDIF

;First, fill in the background behind the dialog box.
PAINTCANVAS FILL ""
				ATTRIBUTE 113
				0,0,24,79
ParadoxUsers()
NovellUsers()
FancyBox()   ;Call the dialog procedure.

RELEASE VARS Tick.Paradox,NovellUser,msg,retval,ParadoxUsers,Tick.Novell
