; Standard Report Layout Generator for Paradox Reports

; (c) AdSus Computer Systems
;     PO Box 62
;     Napier
;     New Zealand

;     Adrian M. Williams [100026,220]

;      this code should work in all versions of Paradox except the dialog
;      box and reference to dynamic arrays. The dialog displays the various
;      report details in the approximate positions on the report header or
;      footer. By selecting or deselecting the various check boxes, you
;      can place the featured options on the screen.

;      The lines marked with a ;* at the end indicate which lines you
;      may wish to modify to integrate the script with your default values.

;      The code in this script isn't the prettiest, but it does the job.
;      feel free to modify the code to suit your own requirements and
;      defaults.

;      I have included a small procedure which extracts the report
;      description from the report definition. This enables you to
;      place the report name on the printed page.

;      One Problem: it seems to run very slowly. It takes about 5 secs
;      to run on a 486/33 with 8mb of RAM. Still, its faster than doing
;      it manually and it is consistent.

;      Please contact me with any suggestions/improvements. Its lonely
;      in the bottom of the South Pacific at times.

;      This script and procedure reference procedures in the DS4_UTIL
;      script from DataStar International. If you don't have a copy of
;      this script then get your copy from Compuserve. The file is called
;      DS4UTL.EXE and it's excellent.
;      Special thanks to Dan Paolini, Micah Beecher and friends.

; DISCLAIMER: AdSus Computer Systems makes no warranties, either expressed
;             or implied, with respect to this program code. It is provided
;             "as-is" and may be copied, modified, used in commerical programs
;             etc, as long as the copyright notice appears in any source
;             code supplied with such code.

;             AdSus Computer Systems will not be held responsible for any
;             damage or loss of data through the use of this program.


; DOCUMENTATION:   g.PRN.y["DB"] = printer Begin Double Width Code
;                  g.PRN.y["DE"] = printer End Double Width Code
;                  g_coy_name    = company name variable
;                  g_report_name = report name (can be extracted from report definition)
;                  g_EOM         = End of Month variable

;[]----------------------------------------------------------------------[]
;    get_report_name - retrieves the report name from the table           |
;                      parameters - tbl : table name                      |
;                                   rpt : report number                   |
;[]----------------------------------------------------------------------[]
Proc get_report_name(tbl,rpt)
     Private rpt_name
     rpt=strval(rpt)
     Menu                        ;retrieve the report name
     {Report} {Change}
     Select tbl
     Select rpt
     rpt_name=Menuchoice()
     do_it!                      ;clear the report header from screen
     return rpt_name
Endproc


Proc ReportDefinition.u()
     Private toprow.n
            ,leftcol.n
            ,framehigh.n
            ,framelow.n
            ,dboxPalette.a

     toprow.n=999                      ;
     leftcol.n=999                     ; used by the procedures in DS4_UTIL
     framehigh.n=syscolor(1036)        ; script from DataStar International
     framelow.n=syscolor(1036)         ;
     dboxPalette.a="Blue"              ;

     DynArray cb.y[]
     cb.y["Coy"]=true                  ;
     cb.y["Date"]=true                 ; change these to reflect the default
     cb.y["Heading"]=true              ; status you require
     cb.y["Page"]=true                 ;
     cb.y["Time"]=true                 ;
     cb.y["EOM"]=true                  ;
     cb.y["EOR"]=true                  ;

ShowDialog "Standard Report Definition"
   Proc "dbEventHandler.l"                ; this proc is in DS4_UTIL
   @-200,-200 Height 14 Width 50

   @0,11 ?? "(c) AdSus Computer Systems"

   CheckBoxes @2,14 Height 1 Width 20
      "Company ~N~ame"   to cb.y["Coy"]

   CheckBoxes @4,4 Height 1 Width 41
      "~D~ate"           to cb.y["Date"],
      "Report ~H~eading" to cb.y["Heading"],
      "~P~age"           to cb.y["Page"]

   CheckBoxes @5,4 Height 1 Width 36
      "~T~ime"           to cb.y["Time"],
      "Month ~E~nded"    to cb.y["EOM"]

   CheckBoxes @7,14 Height 1 Width 20
      "End O~f~ Report"  to cb.y["EOR"]

   Frame From 1,2 to 8,45
   PaintCanvas Border Attribute Framehigh.n 1,2,8,45
   PaintCanvas        Attribute Framelow.n  1,2,1,44
   PaintCanvas        Attribute Framelow.n  1,2,8,2

   PushButton @10,2  Width 10 "~O~k" Ok Default Tag "OKButton" to ButtonValue
   PushButton @10,35 Width 10 "~C~ancel" Cancel Tag "CANCELButton" to Buttonvalue

EndDialog

if retval=false then return false endif

; check mode, and current status before proceeding with script
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    If Sysmode()<>"Report" then
       Beep
       Quit "Must be in Report Mode to run this script...."
    Endif

    Message "Working. Please wait...."          ; display user message
    Menu esc                                    ; make sure not at {MENU}

; erase the standard header and create a blank new one
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    Home CtrlHome
    DeleteLine Down DeleteLine DeleteLine DeleteLine DeleteLine DeleteLine DeleteLine
    Home Down
    If isinsertmode()=false then Ins Endif
    While rowno()<8 Enter endWhile

; place the company name header on the report form
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    If isinsertmode()=True then Ins Endif
    If cb.y["COY"] then
       Home
       CtrlHome
       While not match(cursorline(),"..page..") Down EndWhile
       Down
       Down
       Menu {Field} {Place} {Calculated}
       Typein "g.PRN.y[\"DB\"]+"                                               ;*
       Typein "format("+chr(34)+"W"+strval(int(pagewidth()/2))+",ac"+chr(34)
       Typein ",g_coy_name)"                                                   ;*
       Typein "+g.PRN.y[\"DE\"]"                                               ;*
       Enter
       Enter
       Home
       For count from 2 to pagewidth()
           Right
       EndFor
       Left Enter
    endIf

; place the report name on the  report
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    If cb.y["Heading"] then
       Home
       CtrlHome
       While not match(cursorline(),"..page..") Down EndWhile
       Down Down Down Down
       While Colno()<int(pagewidth()/2)-28 Right EndWhile
       If isinsertmode() Then Ins Endif
       Typein Spaces(50)
       CtrlHome
       While Colno()<int(pagewidth()/2)-28 Right EndWhile
       Menu {Field} {Place} {Calculated}
       Typein "format("+chr(34)+"W50,ac"+chr(34)
       Typein ",g_report_name)"                                                ;*
       Enter
       Enter
       Home
       x_x=0
       for x_x from 1 to 55
           right
       Endfor
       Enter
       release vars x_x
    endif

; place the page number to the right of the report name
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    if cb.y["Page"] then
       Home
       CtrlHome
       While not match(cursorline(),"..page..") Down EndWhile
       Down Down Down Down
       While colno()<pagewidth()-8 Right endWhile
       Typein "Page "
       Menu {Field} {Place} {Page} Enter Right Enter
    endIf

; place the date (dd-Mon-yy) at the start of the line
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    if cb.y["Date"] then
       Home
       CtrlHome
       While not match(cursorline(),"..page..") Down EndWhile
       Down Down Down Down
       CtrlHome  Right Right
       Menu {Field} {Place} {Date} Typein "5" Enter Enter                      ;*
    endif

; place the time underneath the date
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    if cb.y["Time"] then
       Home
       CtrlHome
       While not match(cursorline(),"..page..") Down EndWhile
       Down Down Down Down Down
       CtrlHome Typein "at "
       Menu {Field} {Place} {Time} Enter Enter
    endif

; place the MONTH ENDED text and date on report
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    if cb.y["EOM"] then
       Home
       CtrlHome
       While not match(cursorline(),"..page..") Down EndWhile
       Down Down Down Down Down
       CtrlHome
       While Colno()<int(pagewidth()/2)-25 Right EndWhile
       If isinsertmode() Then Ins Endif
       Typein Spaces(40)
       CtrlHome
       While Colno()<int(pagewidth()/2)-25 Right EndWhile
       Menu {Field} {Place} {Calculated}
       Typein "format("+chr(34)+"W50,ac"+chr(34)
       Typein ","+chr(34)+"For Month Ended "+chr(34)+"+format("+chr(34)+"w9,d5"+chr(34)+",g_EOM))"
       Enter Enter Home
       x_x=0
       for x_x from 1 to 49
           right
       Endfor
       Enter
       release vars x_x
    endif
; place the END OF REPORT message in the report footer
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    if cb.y["EOR"] then
       End
       CtrlEnd
       Enter Enter
       Menu {Field} {Place} {Calculated}
       Typein "format("+chr(34)+"W"+strval(pagewidth())+",ac"+chr(34)
       Typein ","+chr(34)+"--- End of Report ---"+chr(34)+")"                  ;*
       Enter Enter Home
       For count from 2 to pagewidth()
           Right
       Endfor
       Left Enter
       CtrlHome
    endIf
Endproc

; change to reflect the location of the source code
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Setkey -19 Play "Std_Rpt" ReportDefinition.u()
