; ͻ
;  To use these procs in an application with libraries,      
;  use "Search and Replace" with your editor to:             
;      Search:                Replace:                       
;             "xxxApp"                with your library name 
;             ;Readlib                Readlib                
;             ;Writelib               Writelib               
;             ;Release                Release                
; ͼ

if (not isfile("xxxApp.lib")) then
 Createlib "xxxApp"
endif

; 
; This procedure determines the monitor type and calls the appropriate "splash"
; screen to begin an application.   I don't know how Borland will feel about
; it, but the "splash" screens are designed to mimic the Paradox 2.01 opening
; screen.  Four variable messages need to be set as arguments to this
; procedure call.
;
; You can either pass the four messages as arguments, or you can edit them
; directly into the procedure and remove the arguments from the procedure
; definition.  I personally find it easier to hard code msgs 1,3,4 into the
; "splash" procedures.  My company name and copyright notice don't change, and
; I will not be altering the Paradox Runtime notice.  That leaves only msg2,
; the Application Name, as varying in each application.
;
; To keep the screen graphics aligned correctly, the messages must have the
; following lengths:
;
; msg1=61 char ("     S  O  F  T     S  T  E  P     S  O  F  T  W  A  R  E    ")
; msg2=43 char ("           TRIAD Invoicing System          ")
; msg3=43 char ("       Paradox Runtime, Ansa Software      ")
; msg4=36 char ("1989, Soft Step SoftWare, Inc.      ")
;
;
; I suggest using msg1 for your company name, msg2 for the Application Name,
; msg3 for giving due credit to Paradox, and msg4 for your copyright notice.
;
;
Proc SplashMaster(msg1,msg2,msg3,msg4)

 ; Get the messages parsed

 If (msg1 = "") then                                        ; This section of
     msg1 = "     S  O  F  T     S  T  E  P"+  ;Default msg ; code merely
            "     S  O  F  T  W  A  R  E    "  ;(Set your   ; determines
   else                                        ; own msg)   ; whether the
     ; these else stmts simply ensure correct string len    ; message has been
     msg1 = Substr(msg1+"                 "+                ; supplied or the
            "                                   "+          ; default message
            "         ",1,61)                               ; should be used.
 endif                                                      ;
                                                            ; If a message is
 If (msg2 = "") then                                        ; supplied, it con-
     msg2 = "           TRIAD Invoicing System          "   ; catenates blanks
   ; msg2 = "        Database Application System        "   ; and then trun-
   else                                                     ; cates to correct
     msg2 = Substr(msg2+"                   "+              ; message length.
            "                        ",1,43)                ;
 endif

 If (msg3 = "") then
     msg3 = "       Paradox Runtime, Ansa Software      "
   else
     msg3 = Substr(msg3+"                   "+
            "                        ",1,43)
 endif

 If (msg4 = "") then
     msg4 = "1989, Soft Step SoftWare, Inc.      "
   else
     msg4 = Substr(msg4+"                   "+
            "                              ",1,36)
 endif

 ; This section determines monitor type and calls the appropriate "splash"
 ; screen.
 Cursor off
 If (monitor() = "Color") then
     ;Readlib "xxxApp" SplashColor
     SplashColor(msg1,msg2,msg3,msg4)
     Release procs SplashColor
   else if (monitor() = "Mono") then
     ;Readlib "xxxApp" SplashMono
     SplashMono(msg1,msg2,msg3,msg4,"M")        ; "M" = "Mono"
     Release procs SplashMono
   else
     ;Readlib "xxxApp" SplashMono
     SplashMono(msg1,msg2,msg3,msg4,"B")        ; "B" = "B&W"
     Release procs SplashMono
   endif
 endif
 Sleep 15000
 Cursor normal
Endproc
;Writelib "xxxApp" SplashMaster
;Release procs SplashMaster

; 
; This procedure will display a Paradox-like opening screen on an EGA color
; monitor (it may produce it in CGA too, but I haven't tested it for CGA.
;
; Requires the calling procedure (SplashMaster) to supply 4 message arguments.
;
Proc SplashColor(msg1,msg2,msg3,msg4)

 ; Paint the screen
 Style Attribute 7
 @ 0,0 Clear

 ; Paint rows 0,1,2
 ?? "                                                                                "
 ?? "         "
 ?? "    ߱     "

 ; Paint row 3 with msg1
 ?? "    ",msg1
 Style Attribute 1 ?? "" Style Attribute 7 ?? "     "

 ; Paint row 4
 ?? "    "
 Style Attribute 1 ?? "" Style Attribute 7 ?? "     "

 ; Paint row 5
 ?? "    " Style Attribute 1 ?? ""
 Style Attribute 7 ?? "     "

 ; Paint rows 6,7
 ?? "         "
 ?? "    ͱ     "

 ; Paint row 8
 ?? "                                 " Style Attribute 4 ?? "" Style Attribute 7 ?? "                         "
 Style Attribute 4 ?? "" Style Attribute 7 ?? "              "

 ; Paint row 9,10
 ?? "                                                                          "
 ?? "    ͱ     "

 ; Paint row 11
 ?? "    " Style Attribute 1 ?? "" Style Attribute 7 ?? "" Style Attribute 1 ?? ""
 Style Attribute 7 ?? "" Style Attribute 1 ?? "" Style Attribute 7 ?? "" Style Attribute 1 ?? ""
 Style Attribute 7 ?? "" Style Attribute 1 ?? "" Style Attribute 7 ?? "     "

 ; Paint row 12
 ?? "    " Style Attribute 1 ?? "" Style Attribute 7 ?? ""
 Style Attribute 1 ?? "" Style Attribute 7 ?? "" Style Attribute 1 ?? "" Style Attribute 7 ?? "     "

 ; Paint row 13 with msg2
 ?? "    " Style Attribute 1 ?? "" Style Attribute 7 ?? msg2," "
 Style Attribute 1 ?? "" Style Attribute 7 ?? "     "

 ; Paint row 14
 ?? "    " Style Attribute 1 ?? "" Style Attribute 7 ?? " "
 Style Attribute 1 ?? "" Style Attribute 7 ?? "     "

 ; Paint row 15 with msg3
 ?? "    " Style Attribute 1 ?? "" Style Attribute 7 ?? msg3," "
 Style Attribute 1 ?? "" Style Attribute 7 ?? "     "

 ; Paint row 16
 ?? "    " Style Attribute 1 ?? "" Style Attribute 7 ?? " "
 Style Attribute 1 ?? "" Style Attribute 7 ?? "     "

 ; Paint row 17                                         ; 
 ?? "    " Style Attribute 1 ?? "" Style Attribute 7 ?? "                                       "
 Style Attribute 1 ?? "" Style Attribute 7 ?? "     "

 ; Paint row 18
 ?? "    " Style Attribute 1 ?? "" Style Attribute 7 ?? "" Style Attribute 1 ?? ""
 Style Attribute 7 ?? "" Style Attribute 1 ?? "" Style Attribute 7 ?? "" Style Attribute 1 ?? ""
 Style Attribute 7 ?? "" Style Attribute 1 ?? "" Style Attribute 7 ?? "     "

 ; Paint row 19
 ?? "    " Style Attribute 1 ?? "" Style Attribute 7 ?? "" Style Attribute 1 ?? ""
 Style Attribute 7 ?? "" Style Attribute 1 ?? "" Style Attribute 7 ?? "" Style Attribute 1 ?? ""
 Style Attribute 7 ?? "" Style Attribute 1 ?? "" Style Attribute 7 ?? "     "

 ; Paint row 20
 ?? "         "

 ; Paint rows 21,22(w/ msg4),23,24
 ?? "  This package is copyrighted software, licensed \"As-Is\", and without war-      "
 ?? "  ranties or liability for any damages.  Developed application is Copyright     "
 ?? "  (c) ",msg4," all rights reserved.  Underlying     "
 ?? "  Paradox Runtime Copyright (c) 1985, 1988 Borland International.               "
 Style
Endproc
;Writelib "xxxApp" SplashColor
;Release procs SplashColor


; 
; This procedure will display a Paradox-like opening screen on a monochrome
; monitor with monochrome adapter ("M") or a monochrome/B&W monitor with a
; CGA/EGA adapter ("B").
;
; Requires the calling procedure (SplashMaster) to supply 4 message arguments
; and one "switch" argument for "M" vs. "B".
;
;
Proc SplashMono(msg1,msg2,msg3,msg4,Sw)

 If (Sw="B") then
      Style Attribute 7
    else
      Style
 endif
 @ 0,0 Clear

 ? "    "
 ? "    ߱"
 ? "    ",msg1,""
 ? "    ܰ"
 ? "    "
 ? "    "
 ? "    ͱ"
 ? "                                                                   "
 ? "                                                                     "
 ? "    ͱ"
 ? "    "
 ? "    ߰"
 ? "    ",msg2," "
 ? "     "
 ? "    ",msg3," "
 ? "     "
 ? "                                           "
 ? "    "
 ? "    "
 ? "    "
 ? "  This package is copyrighted software, licensed \"As-Is\", and without war-      "
 ??"  ranties or liability for any damages.  Developed application is Copyright     "
 ??"  (c) ",msg4," all rights reserved.  Underlying     "
 ??"  Paradox Runtime Copyright (c) 1985, 1988 Borland International.  "
 Style

Endproc
;Writelib "xxxApp" SplashMono
;Release procs SplashMono
