;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;       Forms Dictionary dialogue boxes                                   ;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; --------------------------------------------------------------------------
; Procedure   : AnalyseBox()
; Description : Analyse status of a completed dialogue box
; Argument    : Value returned by showdialog
; Returns     : True if OK, False if Cancel button was pressed
; --------------------------------------------------------------------------

proc AnalyseBox(status)

dbox["status"] = status
if status = False then
   dbox["buttonval"] = "No"
endif
dbox["nvalues"] = iif(dbox["value1"] <> "", 1, 0)
dbox["nvalues"] = dbox["nvalues"] + iif(dbox["value2"] <> "", 1, 0)

return status

endproc
WriteLib AppLib AnalyseBox
Release procs AnalyseBox

; --------------------------------------------------------------------------
; Procedure   : ConfirmationBox()
; Description : Dialogue box to get authorisation to continue
; Arguments   : 2 lines of display text
; --------------------------------------------------------------------------

proc ConfirmationBox(boxtext1, boxtext2)

dbox["value1"] = ""
dbox["value2"] = ""
showdialog "Confirmation"
   @ 4,20 height 8 width 40
   @ 1,1
   ?? boxtext1
   @ 2,1
   ?? boxtext2
   pushbutton @4,2 width 10
      "~Y~es" OK
      default value "Yes" tag "Yes"
    to dbox["buttonval"]
   pushbutton @4,25 width 10
      "~N~o" CANCEL
      value "No" tag "No"
   to dbox["buttonval"]
enddialog
return AnalyseBox(retval)

endproc
WriteLib AppLib ConfirmationBox
Release procs ConfirmationBox

; --------------------------------------------------------------------------
; Procedure   : PrinterBox()
; Description : Dialogue box to ask about printer setup
; Arguments   : 2 lines of display text
; --------------------------------------------------------------------------

proc PrinterBox()

dbox["value1"] = ""
dbox["value2"] = ""
showdialog "Printer Setup"
   @ 4,22 height 9 width 36
   @ 1,1
   ?? "Current printer setup is"
   @ 2,1
   ?? " - " + controls["Printer"] + " -"
   @ 3,1
   ?? "Use current setup?"
   pushbutton @5,2 width 10
      "~Y~es" OK
      default value "Yes" tag "Yes"
    to dbox["buttonval"]
   pushbutton @5,21 width 10
      "~C~hange" CANCEL
      value "No" tag "No"
   to dbox["buttonval"]
enddialog
return AnalyseBox(retval)

endproc
WriteLib AppLib PrinterBox
Release procs PrinterBox

; --------------------------------------------------------------------------
; Procedure   : DirectoryBox
; Description : Compnay contact dialogue box
; Argument    : "Company" or "Contact"
; --------------------------------------------------------------------------

proc DirectoryBox()

dbox["value1"] = ""
dbox["value2"] = ""
showdialog "Locate Record"
   @ 4,20 height 10 width 40
   @ 1,1
   ?? "Enter the full path to the directory"
   @ 2,1
   ?? "        to be documented"
   accept
      @4,3
      width 30 "A30"
      tag "value1"
   to dbox["value1"]
   pushbutton @6,2 width 10
      "~O~K" OK
      default value "Yes" tag "Yes"
    to dbox["buttonval"]
   pushbutton @6,25 width 10
      "~C~ancel" CANCEL
      value "No" tag "No"
   to dbox["buttonval"]
enddialog
return AnalyseBox(retval)

endproc
WriteLib AppLib DirectoryBox
Release procs DirectoryBox

; --------------------------------------------------------------------------
; Procedure   : PasswordBox()
; Description : Dialogue box to get the password for a table
; Argument    : Prompt text string
; --------------------------------------------------------------------------

proc PasswordBox(tabname)

dbox["value1"] = ""
dbox["value2"] = ""
showdialog "Password Entry"
   @ 4,20 height 9 width 40
   @ 1,1
   ?? "Enter the password for table " + tabname
   accept
      @3,9
      width 17 "A14"  hidden
      tag "value1"
   to dbox["value1"]
   pushbutton @5,2 width 10
      "~O~K" OK
      default value "Yes" tag "Yes"
    to dbox["buttonval"]
   pushbutton @5,25 width 10
      "~C~ancel" CANCEL
      value "No" tag "No"
   to dbox["buttonval"]
enddialog
return AnalyseBox(retval)

endproc
WriteLib AppLib PasswordBox
Release procs PasswordBox
