Libname.a="Printman"
Createlib libname.a
MESSAGE "Building library"

;I developed the Print_Manager first as an error checking procedure when
;printing.  Following this, I had to write an app for users that had a variety
;of printers and wanted to provide an easy way to select different printers, or
;choose different printers on a network.  This lead to the truly first version
;of the Print_Manager.  By the other revisions, you can see I have made slight
;changes over time.  The latest of course being to preview the report.  This
;came from my purely selfish need to see things on the screen and not waste
;my printer paper when developing reports for applications.  Finally, I have
;a file printing feature so that I may send the reports I deveop to ascii and
;then import them to Wordperfect for use in my manuals.

;                                                John

;TO change the name at the top of the print manager, edit the 
;Topname() procedure below.


;THIS SCRIPT CONTAINS THE FOLLOWING PROCEDURES
;
;       Print_Manager   This procedure was developed to handle all printing of
;                       reports for an individual application.
;       Print_Manager_RestoreScreen     this procedure restores the images to
;                                       the screen
;       Check_Printer   This procedure was developed to handle all printing of
;                       reports for an individual application.
;       Viewscreen      Allows the report to be previewed
;       PrintToFile     Send the selected report to a file of the user's choice
;       ClearScreen     A procedure that draws a grid on the background after
;                       previewing the report.
;       Topname         An easy way to clear the ShowPulldown menu and display
;                       your company name instead.
;       Statusmess2     Displays an 'OK' button to confirm what the user
;                       has done
;       Demo            the demonstration procedure
;
;
;       buildtable_printman.u(tbl1.a)  This Procedure builds the Printman table
;                                      in users private directory if not found.

;  ******    AT THE BOTTOM OF THIS SCRIPT ******
;  is a procedure to demonstrate the way the Print_Manager procedures
;  work.  this procedure is NOT required to execute and use the P_M
;  procedure, but is instead included for convenience.



PROC Print_Manager(TblName.a,ReportNum.n);--------------------------------
;Version 2.6 Updated 01/04/95 - Added procedure 'CheckReportWidth' to 
;                               automatically check the width of the report
;                               so the user does not have to pass to changes
;                               made in Version 2.5 (John Nelson).
;Version 2.5 Updated 12/26/94 - Edit changed to Coedit. Printman table
;                               is now referenced in the Private Directory.
;                               Network compatible. (Edit changed to CoEdit.)
;                               ReportWidth.a added to show in the dialog
;                               box.  Helps user choose correct printer driver.
;                               Printers table modified to have reset string
;                               and will supply reset string if required.
;                               Updated for Pdox Version 4.5
;                               Joe Gavlas CIS 72740,2411
;Version 2.1 Updated 08/13/93 - Found error on page length setting.  Page
;                               length was never changing before.  Added
;                               option to show approximate number of pages
;                               for each printer so the user will not be
;                               surprised by an overabundance of pages.
;                               Added Report Preview feature.  Added repot
;                               file printing procedure
;Version 2.0 Updated 05/16/93 - Corrected Statsall demo version tables.
;Version 1.2 Updated 04/27/93 - Incorporated additions from Rick Spangler
;                               (CIS ID: 71554,633) to check for the
;                               existence of queries. Shown by asterisks
;Version 1.1 Updated 03/15/93 - Added Number of copies feature

;This procedure is Copyrighted (c) 1993 NELCO ENGINEERING, but may be distributed
;freely.  No fees or royalties are required by the author.
;This procedure was developed to handle all printing of reports for an
;individual application.  The procedure has been soley developed and created
;by NELCO ENGINEERING.  This procedure may be copied and improved.  This procedure
;may also be distributed with applications as long as this statement is
;included in the source code and the dialog box credits are not modified.
;
;Please pass any improvements to the author.  Merely changing such code herein
;does not entitle one to the rights of this code.
;
;01/14/93  NELCO ENGINEERING
;          John R. Nelson
;          109 Hickory Hill Lane
;          Greenville, SC  29609 USA
;          phone/FAX/BBS: 1-803-244-8765
;          COMPUSERVE ID: 70641,3562
;TABLES
;       Printman        Stores the contents of the currently selected
;                       printer, port, etc.
;               FIELD             TYPE
;           
;            Setup String        A30*  the string that will be entered in the report
;            Current Printer     A30*  a description of the printer
;            Lines               N     lines per page
;            Direction           A10   portrait or landscape
;            Port                A5    lpt1,lpt2, etc..
;
;       Printers        Stores the contents of the possible
;                       printers.
;               FIELD             TYPE
;           
;            Setup String        A30*  the string that will be entered in the report
;            Current Printer     A30*  a description of the printer
;            Lines               N     lines per page
;            Direction           A10   portrait or landscape
;
;VARIABLES
PRIVATE
        tablenum.a,      ;table with the report to print
        reportnum.n,     ;what report to print
        nimages.n,       ;number of images on the screen
        queryexists.a,   ;if query exists on screen             **************
        ReportWidth.a,   ;Width of report in ShowDialog
;ARRAYS           ;defined below
        dumbprinter.a,   ;current printer at beginning
        dumbport.a,      ;current port at beginning
        dumblines.n,     ;current number of lines at beginning
        length,port,     ;new variables to replace the dummies
        buttonvalue,     ;the user's choice from the SHOWDIALOG
        ControlVar       ;slider variable

;CALLED BY any procedure
;CALLS Check_Printer and Print_Manager_RestoreScreen and ViewScreen, 
;      CheckReportWidth


;Get the width of the report
ReportWidth.a=STRVAL(CheckReportWidth(Tblname.a+".R"+Reportnum.n))




;turn off the canvas so the user will not see what is being done
CANVAS OFF
CURSOR OFF

tbl1.a = privdir()+"printman"
if not istable(tbl1.a) then
  buildtable_printman.u(tbl1.a)
endif

nimages.n=NIMAGES()                     ;how many tables are on the screen?
IF nimages.n>0 THEN                     ;if there are tables on the
                                        ;screen then set up arrays to get the info
   ARRAY imagename.a[nimages.n]         ;array for table names
   ARRAY imagefield.a[nimages.n]        ;array for field names
   ARRAY imagerec.n[nimages.n]          ;array for current record in each table
   ARRAY formview.a[nimages.n]          ;array for formview
   ARRAY formname.a[nimages.n]          ;array for form being used
   array queryexists.a[nimages.n]       ;array for seeing if there is a query   **********
WHILE IMAGENO()<>1                      ;we need to move to the top image on
   UPIMAGE                              ;the screen
ENDWHILE
FOR x FROM 1 TO nimages.n               ;start at the top of the screen
    y=x                                 ;dummy variable
      IF IMAGETYPE()="Query" THEN                       ;see if query exists on screen  **********
         {scripts} {querysave} TYPEIN "Temp_qbe" ENTER  ;if so, save under temporary name **********
         IF SEARCH("exists",WINDOW())>0 THEN            ;make sure the temp name doesn't exist **********
                {replace}                               ;if so, correct for it  **********
         ENDIF                                          ;**********
         queryexists.a[y]=TRUE                          ;query is on workspace (there's just one) **********
         imagename.a[y]=""                              ;This is my marker to tell print_manager_restorescreen
                                                        ;that this array item has no images attached to it
     ELSE
      IF ISFORMVIEW() THEN              ;is this image in formview?
         formview.a[y]=TRUE             ;if it is we save that and get the
         formname.a[y]=FORM()           ;name of the form being used
         FORMKEY                        ;lets got to table view now
      ELSE
         formview.a[y]=FALSE            ;not in form view
      ENDIF
         queryexists.a[y]=FALSE               ;current image isn't a query  **********
         imagename.a[y]=TABLE()               ;save the name of this table
         imagefield.a[y]=FIELD()              ;save the name of the current field
         imagerec.n[y]=RECNO()                ;save the name of the current record
     endif                                    ;**********
     CLEARIMAGE                           ;remove this image and move down to
ENDFOR                                  ;the next one to repeat the process
ENDIF

TopName()
;view the Printman table and get the information that was saved
;the last time it was modified.
;VIEW "TABLES\\Printman"
tbl1.a = privdir()+"printman"
view tbl1.a
dumbprinter.a=[Current Printer]         ;save the name of the currently selected
dumbport.a=[Port]                       ;printer, port, lines
dumblines.n=[Lines]

;view the printers table to define the array that will show all of the printer
;names.

VIEW "Printers"
ARRAY Printer1[NRECORDS("Printers")]    ;dimension array for printer names
ARRAY Setup1[NRECORDS("Printers")]      ;dimension array for printer strings
ARRAY Lines1[NRECORDS("Printers")]
ARRAY Reset1[NRECORDS("Printers")]
SCAN
        Printer1[RECNO()]=[Printer]     ;save the printer name and corresponding
        Setup1[RECNO()]=[Setup string]  ;setup string
        lines1[RECNO()]=[Lines]
        reset1[RECNO()]=[Reset String]
        IF printer1[RECNO()]=dumbprinter.a THEN ;if this is the current printer
                ArrayElement=RECNO()            ;then save that array number
                                                ;so we can highlight it
        ENDIF
ENDSCAN

;now we have to set up the port so that it will work with radio buttons.
port=dumbport.a                 ;assign a dummy variable
                                ;and change it to an array element.
                SWITCH
                        CASE port="LPT1"        :
                                port=1
                        CASE port="LPT2"        :
                                port=2
                        CASE port="LPT3"        :
                                port=3
                        CASE port="COM1"        :
                                port=4
                        CASE port="COM2"        :
                                port=5
                ENDSWITCH


;now it is time to put some flashy stuff on the screen.  we will show a
;dialog box that is similar to the print manager in windows!  this will
;allow our user to select the printer, and port.
WHILE TRUE
length=dumblines.n                      ;assign a dummy variable
Buttonvalue="Cancel"
dest.n=1
;SHOWDIALOG "Print_Manager by NELCO ENGINEERING"       ;box title
SHOWDIALOG "Print Manager"       ;box title
        @4,8 HEIGHT 18 WIDTH 64         ;position and size
        @15,1 ?? FORMAT("W63, AC","Table: "+tblname.a+"   Report: "+reportnum.n)
        @1,1 ?? "Printer Name: "        ;description of list
        PICKARRAY                       ;use a PICKARRAY list to allow the
                @2,1 HEIGHT 8 WIDTH 30  ;user to select a new printer
                Printer1                ;this is the variable to use
                TAG "ArrayTag"
                TO ArrayElement

        @11,1 ?? "Estimated Pages: "+STRVAL(ROUND(CopiesVar*NRECORDS(tblname.a)/(Lines1[ArrayElement]-10),1))
        @12,1 ?? "Report Width: "+reportwidth.a
        @1,35 ?? "Port: "               ;description of radio buttons
        RADIOBUTTONS @2,35 HEIGHT 6 WIDTH 12
                "LPT1",
                "LPT2",
                "LPT3",
                "COM1",
                "COM2"
                TAG "PortTag"
                TO Port

        @9,35 ?? "Number of copies"
        STYLE ATTRIBUTE 31
        @10,47 ?? INT(Copiesvar)
        SLIDER  @10,35 HORIZONTAL LENGTH 10
                MIN 1
                MAX 10
                ARROWSTEP 1
                PAGESTEP 2
                TAG "SliderTag"
                TO Copiesvar

        FRAME SINGLE FROM 1,48 TO 4,60
        PAINTCANVAS ATTRIBUTE 112 1,48,4,60
        PAINTCANVAS ATTRIBUTE 127 1,60,4,60
        PAINTCANVAS ATTRIBUTE 127 4,49,4,59
        PUSHBUTTON @2,49 WIDTH 10
                "Preview"
                OK
                VALUE "Preview"
                TAG "ACCEPT"
                TO Buttonvalue

        FRAME SINGLE FROM 5,48 TO 8,60
        PAINTCANVAS ATTRIBUTE 112 5,48,8,60
        PAINTCANVAS ATTRIBUTE 127 5,60,8,60
        PAINTCANVAS ATTRIBUTE 127 8,49,8,59
        PUSHBUTTON @6,49 WIDTH 11
                "To File"
                OK
                VALUE "File"
                TAG "ACCEPT"
                TO Buttonvalue


        PUSHBUTTON @13,15 WIDTH 10
                "Print"
                OK
                DEFAULT
                VALUE "Accept"
                TAG "AcceptTag"
                TO Buttonvalue

        PUSHBUTTON @13,40 WIDTH 10
                "Cancel"
                Cancel
                VALUE "Cancel"
                TAG "CancelTag"
                TO Buttonvalue
ENDDIALOG
SWITCH
CASE Buttonvalue="Preview" AND retval = TRUE:  ;NOT escape or Cancel!
     IF ISFILE("Readme.com")=FALSE THEN
        MESSAGE "You must have a copy of 'Readme.com' in the current directory"
        BEEP BEEP
        SLEEP 1000
        MESSAGE "You can copy Readme.com from the Paradox or Runtime Directory"
        SLEEP 1000
     ELSE
        ViewScreen()
        ClearScreen()
        TopName()
    ENDIF

CASE Buttonvalue="File" AND retval = TRUE:  ;NOT escape or Cancel!
    PrintToFile()
OTHERWISE:
    QUITLOOP
ENDSWITCH
ENDWHILE
;now we need to determine what the user chose to do and execute the commands
;if they decided to continue.
IF Buttonvalue="Accept" AND retval = TRUE THEN  ;NOT escape or Cancel!
                    setup.a=Setup1[ArrayElement]    ;define the setup string
                    reset.a=Reset1[ArrayElement]
                    length=lines1[ArrayElement]
                    SWITCH                          ;convert the array choice back
                             CASE port=1     :       ;to plain old english so we
                                     port="LPT1"     ;may save it in the table
                             CASE port=2     :
                                     port="LPT2"
                             CASE port=3     :
                                     port="LPT3"
                             CASE port=4     :
                                     port="COM1"
                             CASE port=5     :
                                     port="COM2"
                     ENDSWITCH


;we must save their current choices so that they can be shown again next time
;                VIEW "TABLES\\Printman"                 ;view the table
                VIEW tbl1.a                 ;view the table
                COEDITKEY                         ;and go to edit mode
                  [Setup String]   =Setup1[ArrayElement]
                  [Current Printer]=Printer1[ArrayElement]
                  [Port]=port
                DO_IT!

;this is where the fun starts!  we know what kind of printer, port, etc to
;use so now it is time to print.  a TRUE condition will be set and we will
;print inside a loop while checking for printer errors.  the procedure
;Check_Printer will do the actual printing.
        FOR x FROM 1 TO CopiesVar
                WHILE TRUE
                retval=Check_Printer(tblname.a,reportnum.n,port,setup.a,
                reset.a,length)
                If retval = TRUE THEN           ;was the print job successful?
                        QUITLOOP                ;WE ARE DONE!!
                ELSE                            ;NO!!!

                                        ;now we need some help from the
                                        ;user.  let them know that an error occurred
                                        ;that attention is required to the printer.
                        SHOWDIALOG "Printer Error"
                                @10,20 HEIGHT 8 WIDTH 40
                                @1,1 ?? "    A printer error has occurred!!"
                                PUSHBUTTON @3,5 WIDTH 12
                                        "Try Again"
                                        OK
                                        DEFAULT
                                        VALUE "Accept"
                                        TAG "AcceptTag"
                                        TO Buttonvalue

                                PUSHBUTTON @3,25 WIDTH 10
                                        "Cancel"
                                        Cancel
                                        VALUE "Cancel"
                                        TAG "CancelTag"
                                        TO Buttonvalue
                        ENDDIALOG

                                        ;what did they decide to do?
                        IF ButtonValue="Accept" AND retval = TRUE THEN
                                LOOP
                        ELSE
                                QUITLOOP
                        ENDIF
                ENDIF
                ENDWHILE
        ENDFOR
ENDIF
MESSAGE ""
print_manager_restorescreen()
;at this point, we have either printed or chosen not to continue.  we need
;to restore the screen to the way we found it.
ENDPROC;-------------------------------------------------------------------

WRITELIB libname.a Print_Manager
RELEASE PROCS Print_Manager


PROC Print_Manager_RestoreScreen();----------------------------------------
;this procedure restores the screen to the images and forms it had
;before the procedure was executed.
;
;This procedure is part of the Print_Manager group of files.

;TABLES
;VARIABLES
;       queryexists.a     did a query exist?  **********
;       nimages.n       number of images
;       imagefiled.a[]  field in each table
;       imagename.a[]   name of the table
;       formview.a[]    was form view being used?
;       imagerec.n[]    current record in the table
;       formname.a[]   name of the form
;
;CALLED BY Print_Manager
;
;clear all images from the screen so we can rebuild from scratch
CLEARALL
IF nimages.n>0 THEN                     ;were there any images on the screen?

FOR x FROM 1 TO nimages.n               ;start looping for the number
   if queryexists.a[x] then             ;see if a query was on the screen **********
        {scripts} {Play} typein         ;if so, return it to the screen  **********
        "Temp_qbe" enter {tools}
        {delete} {script}               ;and delete temporary query  **********
        typein "Temp_qbe" enter
        {ok}
   else
   VIEW imagename.a[x]                  ;view the first image
   MOVETO FIELD imagefield.a[x]         ;move to the right field
   MOVETO RECORD imagerec.n[x]          ;get to the correct record
   IF formview.a[x]=TRUE THEN           ;lets go to formview
      PICKFORM formname.a[x]
   ENDIF
   endif                                ;**********
ENDFOR
ENDIF
CANVAS OFF
ENDPROC;---------------------------------------------------------------------

WRITELIB libname.a Print_Manager_RestoreScreen
RELEASE PROCS Print_Manager_RestoreScreen


PROC Check_Printer(tblname.a,reportnum.n,port.a,setup.a,Reset.a,Length); ------
;This procedure is part of the Print_Manager group of files.

;TABLES
;       tablenam.a      the table with the report to print
;VARIABLES
;       tblname.a       the table with the report to print, passed from Print_Manager
;       reportnum.n     the number of the report, passed from Print_Manager
;       port.a          the port to use, passed from Print_Manager
;       setup.a         the setup string, passed from Print_Manager
;       Length          the length of the page, passed from Print_Manager
;       errorproc       the error procedure name
;       printerr        the variable to assign if a printer error occurs
;       printdone       printing done successfully?
;CALLED BY Print_Manager

;assign the private variables and make them private so they will not
;effect the applications global error handling
PRIVATE errorproc,printerr,printdone
MESSAGE "     Printing......           "        ;let the user know whats happening

;select the report and change the settings
MENU {Report} {Change} SELECT tblname.a SELECT reportnum.n ENTER
{Setting} {Setup} {Custom} SELECT port.a TYPEIN setup.a ENTER
if menuprompt() <> "Error" then
   typein Reset.a ENTER
endif
ENTER
Menu {Setting} {PageLayout} {Length} CTRLBACKSPACE TYPEIN length ENTER

;this is the error handler to use in case we can not print the report.
;of course, we hope that the report prints successfully
PROC ErrorHandler();-----------------------------------
     BEEP BEEP BEEP
     STYLE ATTRIBUTE 79
     PrintErr=True
     RETURN 1
ENDPROC;-----------------------------------------------
     ErrorProc="ErrorHandler"                   ;define the error handler
     PrintErr=False                             ;set the inital variable
     PrintDone=False                            ;states
     WHILE NOT PrintErr AND NOT PrintDone       ;we want PrintErr and PRintDone to
          {OUTPUT}{Printer}                     ;both be true, otherwise we had a
          PrintDone=TRUE                        ;printing error
     ENDWHILE
     Menu {Cancel} {Yes}                        ;these will not be permanent
     IF Printdone=TRUE AND PrintErr=False THEN  ;report changes
        RETURN TRUE                             ;IT WORKED!
     ELSE
        RETURN FALSE                            ;NICE TRY!!
     ENDIF
ENDPROC;----------------------------------------------------------------------


WRITELIB libname.a Check_Printer
RELEASE PROCS Check_Printer

PROC ViewScreen(); -----------------------------------------------------
;This procedure is part of the Print_Manager group of files

;TABLES
;       tablenam.a      the table with the report to print
;VARIABLES
;       tblname.a       the table with the report to print, passed from Print_Manager
;       reportnum.n     the number of the report, passed from Print_Manager
;       port.a          the port to use, passed from Print_Manager
;       setup.a         the setup string, passed from Print_Manager
;       Length          the length of the page, passed from Print_Manager
;       errorproc       the error procedure name
;       printerr        the variable to assign if a printer error occurs
;       printdone       printing done successfully?
;CALLED BY Print_Manager

;assign the private variables and make them private so they will not
;effect the applications global error handling
MESSAGE "     Loading......           "        ;let the user know whats happening
        IF ISFILE("Myreprt.txt")=TRUE THEN
                RUN NOREFRESH "Del Myreprt.txt"
        ENDIF
        {Report} {Output} SELECT tblname.a SELECT reportnum.n {File} TYPEIN "Myreprt.txt" ENTER
        BEEP
        RUN NOSHELL "README.COM Myreprt.txt"
        

ENDPROC;----------------------------------------------------------------------

WRITELIB libname.a ViewScreen
RELEASE PROCS ViewScreen

PROC PrintToFile();--------------------------------------------------------
PRIVATE Curpath,Tofile,filename
ButtonValueFile=""
CurPath=DIRECTORY()
WHILE TRUE
    SHOWDIALOG "File Name"
            @10,10 HEIGHT 10 WIDTH 60

            @1,5 ?? "Path= "
            ACCEPT @1,9 WIDTH 30
                "A28"
                PICTURE "*!"
                TAG "curpath"
                TO CurPath

            @3,5 ?? "Enter the desired filename: "
            ACCEPT @3,33 WIDTH 12
                "A8"
                PICTURE "*!"
                TAG "Filename"
                TO ToFile

            PUSHBUTTON @5,15 WIDTH 12
                    "OK"
                    OK
                    DEFAULT
                    VALUE "Accept"
                    TAG "AcceptTag"
                    TO ButtonvalueFile
             PUSHBUTTON @5,35 WIDTH 10
                    "Cancel"
                    Cancel
                    VALUE "Cancel"
                    TAG "CancelTag"
                    TO ButtonvalueFile
    ENDDIALOG
    IF Buttonvaluefile="Accept" AND retval=TRUE THEN
        drv=SUBSTR(CurPath,1,1)
        filename=Curpath+Tofile
        IF DRIVESTATUS(drv)=TRUE THEN
                IF ISFILE(filename+".rpt")=TRUE THEN
                        Statusmess2("The file already exists, rename")
                        LOOP
                ELSE
                        {Report} {Output} SELECT tblname.a SELECT reportnum.n {File} TYPEIN filename ENTER
                        Statusmess2(filename+".rpt was successfully written")
                        QUITLOOP
                ENDIF
        ELSE
                Statusmess2("The drive is not ready, try again")
                LOOP
        ENDIF
    ELSE
        Statusmess2("No file written")
        QUITLOOP
    ENDIF
ENDWHILE
ENDPROC;-------------------------------------------------------------

WRITELIB libname.a PrintToFile
RELEASE PROCS PrintToFile

PROC TopName();----------------------------------------------------------
;This procedure is part of the Print Manager group of files

;Modify the following lines to display your own application name or company
;name.  I also call this procedure every time I load a form to the screen
;when I am not using the ShowPulldown menu so there won't be just a blank
;bar at the top of the screen.  It is a nice finishing touch.
CANVAS OFF
CLEAR
;PAINTCANVAS FILL("") ATTRIBUTE 25 0,0,24,79
CANVAS ON
CLEARPULLDOWN

SHOWPULLDOWN
        "                 ":"":"z$$",
        "~Print_Manager - DEMO~":"":"node1"
ENDMENU

ENDPROC;------------------------------------------------------------------

WRITELIB libname.a TopName
RELEASE PROCS TopName

PROC ClearScreen();---------------------------------------------------------
;This procedure is part of the Print_Manager group of files
PRIVATE x
CANVAS OFF
CLEAR
;PAINTCANVAS FILL("") ATTRIBUTE 25 0,0,24,79
CANVAS ON
ENDPROC;-------------------------------------------------------------------

WRITELIB libname.a CLEARSCREEN
RELEASE PROCS ClearScreen

PROC Statusmess2(msg);--------------------------------------------
;**************************************************************************
;**** Procedure Name: StatusMess1       Called by: All Scripts         ****
;****     Written by: JOHN R. NELSON         Date: 2/14/92             ****
;****                                                                  ****
;**** Purpose: Generic procedure for displaying a one line             ****
;****          message on the screen.                                  ****
;****                                                                  ****
;**** Variable's (Private)                                             ****
;****                                                                  ****
;****                                                                  ****
;**************************************************************************
PRIVATE f,a,ButtonValue

Canvas Off
a=len(msg)+5
IF a>70 THEN
        msg=SUBSTR(msg,1,69)
        a=LEN(msg)+5
ENDIF
IF a<24 THEN
        a=24
ENDIF
f=INT(a/2)

BEEP BEEP
SHOWDIALOG "System Message"
        @8,41-f HEIGHT 7 WIDTH f*2
        STYLE ATTRIBUTE 79
        @1,1 ?? msg

        PUSHBUTTON @3,INT(f)-6 WIDTH 10
        "OK"
        OK
        DEFAULT
        VALUE "Yes"
        TAG "ACCEPT"
        TO Buttonvalue
ENDDIALOG
ENDPROC;--------------------------------------------------------

Writelib libname.a StatusMess2
Release Procs StatusMess2



Proc buildtable_printman.u(tbl1.a);------------------------------------
;Procedure courtesy of Joe Gavlas, Compuserve ID 72740,2411
;
;-----Build the printman table in the users private directory
;     If private directory is not defined it goes to the root directory
;

create tbl1.a
 "Setup String"              :  "A30",
 "Current Printer"           :  "A30",
 "Lines"                     :  "N",
 "Direction"                 :  "A10",
 "Port"                      :  "A5"
 Do_It!
 Coedit tbl1.a
 [Setup String]    = "\027@"
 [Current Printer] = "Standard Epson Dot Matrix"
 [Lines]           =  60
 [Direction]       = "Portrait"
 [Port]            = "Lpt1"
 Do_It!
 clearimage

Endproc;-------------------------------------------------------------

WRITELIB libname.a  buildtable_printman.u
RELEASE PROCS       buildtable_printman.u


PROC CheckReportWidth(reportname.a);-------------------------------------
;This procedure reads in the structure of a report as a binary file. It
;then scans the Page header in the file to check the report width.
;YES!  It nails it every  time <VBG>.
;Written by John R. Nelson 1/4/95 after getting inspiration from
;Joe Gavlas' change to include the report width.

;open the report to check
FILEREAD BINARY reportname.a TO reportstructure.a
        currentchar.a=SUBSTR(reportstructure.a,96,1)  ;this is the byte
                     ;position in the file where the width is described.
                     ;I do not know what would happen if this was greater
                     ;than 255.  I can not see it happening.
        reportwidth.n=ASC(currentchar.a)
RETURN reportwidth.n
ENDPROC;----------------------------------------------------------------

WRITELIB libname.a CheckReportWidth
RELEASE PROCS CheckReportWidth        
        





;********************************************************************
;DELETE THIS WHEN READY TO USE.
;********************************************************************


PROC Demo();----------------------------------------------------------
;this procedure will demonstrate how the Print_Manager code works.


{Tools} {Info} {Inventory} {Files} {*.r*} 
CLEARALL
IF ISEMPTY("List") THEN
        BEEP BEEP
        MESSAGE "No reports found!!"
        SLEEP 1500
ELSE

;we are going to set up a list of all of the files in the directory
;with reports
        SHOWDIALOG "Reports to print"
                @4,22 HEIGHT 16 WIDTH 39
                PICKFILE @1,2 HEIGHT 8 WIDTH 32
                COLUMNS 2
                DIRECTORY()+"*.r*"
                TAG "PickTag"
                TO Filename
        PUSHBUTTON @12,5 WIDTH 10
                 "OK"
                 OK
                 DEFAULT
                 VALUE "Accept"
                 TAG "AcceptTag"
                 TO Buttonvalue
          PUSHBUTTON @12,21 WIDTH 10
                 "Cancel"
                 Cancel
                 VALUE "Cancel"
                 TAG "CancelTag"
                 TO Buttonvalue                      
ENDDIALOG
IF Buttonvalue="Accept" THEN            ;the user said go ahead
        decimal=SEARCH(".",filename)    ;where is the decimal in the filename?
        tbl=SUBSTR(filename,1,decimal-1)        ;get the table name
        rep=SUBSTR(filename,decimal+2,LEN(filename))    ;get the report number
        Print_Manager(tbl,rep)
ENDIF
ENDIF
ENDPROC;--------------------------------------------------------------

WRITELIB libname.a Demo
RELEASE PROCS Demo

AUTOLIB=libname.a
DEMO()


