CLEAR ClearAll
CREATELIB "Steve1"

MESSAGE"Creating STEVE1 library of Printit procedures..."

;Printit! Procs & Tables
;Copyright 1991, Steve Dickinson
;For noncommercial & educational use by Paradox users & programmers
;I can be reached Days 212-382-2102 Ext 34
;Eves 516-484-4528
;
;I use this (& close cousins) on (at?) several independent sites around the
;world, on LAN, WAN, and stand-alone systems, and have found them to be of
;great utility no matter the configuration.
;
;I've found that printing ONCE, to a text file, greatly reduces the
;processing time needed, allowing the object to be manipulated without
;requiring Paradox to regenerate (sometimes endlessly) the report again
;and again
;
;The driving table, PRINTIT, holds two command-text fields:
;Structure of "C:\\PDOX35\\PRINTIT"
;"Selection"                 :  "A10",
;"Descr"                     :  "A25",
;"Run command"               :  "A50",         ; This is one
;"Use command"               :  "A50"          ; This is the other one
;
;The [Run Command] is the BEFORE command, if needed, such as the ENDCAP that
;allows a networked user to print to LPT1, rather than to a network printer.
;The [Use Command] is the AFTER, or active, actual, DOS command.  The "!"
;symbol tells the procedure where to substitute the filename.
;In one case, the "*" symbol holds the place of the destination filename.
;
;I have not included the extensive key- and error-trapping that a good,
;solid WAIT-loop requires in a user-intensive environment.  We all
;generally employ our own favorite strategy, anyway, and that's not an
;issue I wanted to address here.
;
;Enjoy!  Use it well, and don't be shy about dropping me some Email
;
;=>Steve


PROC printit(tabl,rpnum)
  PRIVATE  fn,pchoice, z, ff, reptname, AUTOLIB, tbl, rnum,runcmdef,echoice,nfn
  AUTOLIB="Steve1"
  nfn=""
  fn=""
  IF SYSMODE()<>"Main" THEN
    Do_It!
  ENDIF

  IF tabl<>"" AND rpnum<>"" THEN
    Menu {Report} {Output} SELECT tabl
    SELECT rpnum
    {File}
    fn=PrivDir()+"Text.rpt"
    working("Sending report "+tabl+"."+rpnum+" to file: "+fn+"...")
    TYPEIN fn Enter
    IF WINDOW()<>"" THEN
      {Replace}
    ENDIF
  ENDIF
  CLEAR
  WHILE (true)
    STYLE INTENSE
    @10,0 ?? "Please input filename (or [Esc] to cancel): "
    @11,5
    ACCEPT "A50" TO fn
    IF RETVAL=false THEN
      LOOP
    ENDIF
    IF fn="" THEN
      RETURN false
    ENDIF
    IF NOT IsFile(fn) THEN
      BEEP BEEP
      @12,10 ?? "That file: "+fn+" cannot be found.."
      SLEEP 2000

      SHOWMENU
      "Create":"Create new file",
      "Cancel":"Start over or Quit"
      TO schoice

      IF schoice="Cancel" THEN
        LOOP
      ELSE
        PRINT FILE fn "\n\n"
      ENDIF
    ENDIF
    STYLE
    QUITLOOP
  ENDWHILE
  STYLE

  prtfile(fn)

ENDPROC

WRITELIB "Steve1" printit
RELEASE VARS printit

PROC prtfile(filename)
  PRIVATE  fn,pchoice, z, ff, reptname, AUTOLIB, tbl, rnum,runcmdef,echoice,nfn,rcmd2
  AUTOLIB="Steve1"
  nfn=""

  IF SYSMODE()<>"Main" THEN
    Do_It!
  ENDIF
  fn=""
  fn=filename

  CLEAR
  IF fn="" THEN
    WHILE (true)
      STYLE INTENSE
      @10,0 ?? "Please input filename (or press [Enter] to cancel): "
      @11,5
      ACCEPT "A50" TO fn
      IF RETVAL=false THEN
        LOOP
      ENDIF
      IF fn="" THEN
        RETURN false
      ENDIF
      IF NOT IsFile(fn) THEN
        BEEP BEEP
        @12,10 ?? "That file: "+fn+" cannot be found.."
        SLEEP 2000

        SHOWMENU
        "Create":"Create new file",
        "Cancel":"Start over or Quit"
        TO schoice

        IF schoice="Cancel" THEN
          LOOP
        ELSE
          PRINT FILE fn "\n\n"
        ENDIF
      ENDIF
      STYLE
      QUITLOOP
    ENDWHILE
    STYLE
  ENDIF


  SetSwap 35000
  VIEW "Printit"
  Menu {Image} {Pickform} {1}
  WHILE (true)
    IF nfn<>"" THEN
      fn=nfn
      nfn=""
    ENDIF
    WAIT RECORD
      PROMPT "  FILENAME: "+fn,
      "[F2]-Select, [Esc]-Cancel/Quit, [Ctrl-C]-ReConfigure Print Options"
    UNTIL "F2", "Esc", "Right", "Left" ,"Up", "Down", "Enter", 3

    SWITCH
      CASE RETVAL=3:; Ctrl-C
        configprt()
        LOOP

      CASE RETVAL="Esc":
        RETURN true

      CASE RETVAL="F2":
        rcmd2=[run command]
        IF rcmd2<>"" THEN
          RUN norefresh norestore rcmd2
        ENDIF
        rcmd=[Use command]
        IF MATCH(rcmd,"..!..",a,b) THEN
          runcmd=a+" "+fn+" "+b
          IF MATCH(runcmd,"..*..",a,b)
            THEN
            STYLE REVERSE

            @10,10 ?? "Typein new file name:   "
            ACCEPT "A50" TO nfn
            IF nfn<>"" THEN
              runcmd=a+" "+nfn+" "+b
            ENDIF
          ENDIF

        ENDIF

        working("Sending report to "+[Selection]+"...")
        RUN norefresh norestore runcmd
        LOOP

      OTHERWISE:
        KEYPRESS RETVAL
        LOOP



    ENDSWITCH
  ENDWHILE
ENDPROC

WRITELIB "Steve1" prtfile
RELEASE VARS prtfile


PROC configprt()
  AUTOLIB="Steve1"
  Menu {Image} {Pickform} {F}
  CoEditKey
  WHILE (true)
    WAIT TABLE
      PROMPT "[F2]-Done, [Ins]-Insert, [Del]-Delete",""
    UNTIL "F2", "Esc"

    SWITCH

      CASE RETVAL="F2" OR RETVAL="Esc":
        Do_It!
        Menu {Image} {Pickform} {1}
        RETURN true

    ENDSWITCH

  ENDWHILE
ENDPROC
WRITELIB "Steve1" configprt
RELEASE VARS configprt

PROC working(msg)
  PRIVATE  msg
  STYLE REVERSE
  IF msg>"" THEN
    msg = " "+msg+" "
  ENDIF
  @24,0 CLEAR EOL ?? msg
  STYLE BLINK, REVERSE
  @0,0 CLEAR EOL ??" Working...."
  @1,0 CLEAR EOL
  STYLE
ENDPROC

WRITELIB "Steve1" working
RELEASE PROCS working


;Test script
AUTOLIB="steve1"
printit("","")   ;no table name, no report #, will ask for a file name.

