; pictproc.sc
; Original version written by Tony Jordan, then at XL/Proteus Software.
; Updated slightly by Ann Lynnworth, SynchroniciTech.  71242,3456.
; This is FREEWARE, no complaints accepted!


PROC PICT( PICT.TYPE )
; Defines PAL pictures for DOS paths and filenames
; PICT.TYPE --> "PATH", "PATH.REQ", "FILE" or "FILE.NOEXT"
;               "FIRSTNAME", "ALLCAPS", "PHONE1", "PHONE2", "INITCAPS"
; retval    --> picture string
  Switch

    Case PICT.TYPE = "PATH" :
	; DOS PATH only
      Return  "[&:][\\][{&,#,;!,;@,;#,$,%,^,;&,(,),_,-,;{,;},~,`,'}" +
              "*7[{&,#,;!,;@,;#,$,%,^,;&,(,),_,-,;{,;},~,`,'}]" +
              "*{\\{&,#,;!,;@,;#,$,%,^,;&,(,),_,-,;{,;},~,`,'}" +
              "*7[{&,#,;!,;@,;#,$,%,^,;&,(,),_,-,;{,;},~,`,'}]}[\\]]"

    Case PICT.TYPE = "PATH.REQ" :
      ; PATH REQUIRED
      Return  "[&:][\\]" +
              "*{{&,#,;!,;@,;#,$,%,^,;&,(,),_,-,;{,;},~,`,'}" +
              "*7[{&,#,;!,;@,;#,$,%,^,;&,(,),_,-,;{,;},~,`,'}]\\}"

    Case PICT.TYPE = "FILE" :
	; DOS FILE NAME
      Return  "[&{:}][\\]{&,#,;!,;@,;#,$,%,^,;&,(,),_,-,;{,;},~,`,'}" +
              "*7[{&,#,;!,;@,;#,$,%,^,;&,(,),_,-,;{,;},~,`,'}]" +
              "*{\\{&,#,;!,;@,;#,$,%,^,;&,(,),_,-,;{,;},~,`,'}" +
              "*7[{&,#,;!,;@,;#,$,%,^,;&,(,),_,-,;{,;},~,`,'}]}" +
              "[.*3[{&,#,;!,;@,;#,$,%,^,;&,(,),_,-,;{,;},~,`,'}]]"

    Case PICT.TYPE = "FILE.NOEXT" :
	; DOS FILE NAME BUT DON'T ALLOW AN EXTENSION
      Return  "[&{:}][\\]{&,#,;!,;@,;#,$,%,^,;&,(,),_,-,;{,;},~,`,'}" +
              "*7[{&,#,;!,;@,;#,$,%,^,;&,(,),_,-,;{,;},~,`,'}]" +
              "*{\\{&,#,;!,;@,;#,$,%,^,;&,(,),_,-,;{,;},~,`,'}" +
              "*7[{&,#,;!,;@,;#,$,%,^,;&,(,),_,-,;{,;},~,`,'}]}]"

    Case PICT.TYPE = "ALLCAPS" :
      Return "*!"                   ; any char allowed; convert to upper

    Case PICT.TYPE = "FIRSTNAME" :  ; for firstname, other short text fields
      Return "&*@"                  ; capitalize 1st letter only

    Case PICT.TYPE = "INITCAPS" :   ; any A__ field
      Return "\*\{\!\*\?\[\*\ \]\}" ; capitalize 1st letter of each word

    Case PICT.TYPE = "PHONE1" :     ; datatype A14
      Return "(###) ###-####"

    Case PICT.TYPE = "PHONE2" :     ; datatype A13
      Return "###/ ###-####"

  Endswitch

ENDPROC