;----------------------------------------------------------------------------
;
;	LIBINFO	This script:
;				- does an INFOLIB on any Lib (using a SHOWFILES menu),
;				- adds a column called Percentage,
;				- sorts the resulting List table by procedure size in descending
;				  order,
;				- calculates each procedures size as a percentage of the total
;				  size of the library,
;				- calculates the total size of all procedures and adds a record
;				  called "TOTAL----",
;				- then finally VIEWs the resulting List table
;
;	It's best to use a SETKEY for this script, as it can be helpful in
;	(relatively) quickly determining the "fattest" procedures for trimming
;	(less than 4k is optimum, I believe).
;
;	Jerome Yuzyk, IMC Consulting Group Inc.  CSID: 73340,2555
;
;----------------------------------------------------------------------------

CLEAR												; present a menu of Libs
SHOWFILES NOEXT DIRECTORY()+"*.lib"
	"Select Lib to report on"
TO name
IF ( name = "Esc" ) THEN
	CLEAR
	RETURN
ENDIF

CLEAR
@ 12, 0 ?? FORMAT ( "w80,ac", "One moment please..." )

INFOLIB ( name )
MENU {Modify} {Restructure}				; restructure the List table to add
SELECT "List"									; the "Percentage" field
END
DOWN
TYPEIN "Percentage"
RIGHT
TYPEIN "N"
DO_IT!

SORT "List" on "Size" D						; sort List on "Size" in descending
sum = CSUM ( "List", "Size" )				; order
EDITKEY
CTRLEND
MENU {Image} {Format} ENTER {Fixed}		; set the column to Fixed format with
ENTER												; 2 decimal places
MENU {Image} {KeepSet}
SCAN												; calculate Percentages
	[] = ( [Size] / sum ) * 100
ENDSCAN
DOWN
CTRLHOME											; enter total proc sizes
RIGHT
TYPEIN "TOTAL----"
RIGHT
[] = sum                               ; this has already been calculated,
RIGHT												; so use the number
[] = IMAGECSUM ()								; this hasn't been calculated yet, so
DO_IT!											; calc (just to verify percentages)

HOME												; display first record
