;--------------------------------------------------------
;IMPROPER.SC - proc to subvert 'proper case' val check
;              so you can advantages of automatic first
;              letter caps without being locked in - such
;              as when you want a person's title to read
;              "Attorney at Law" or an address to read
;              "25 Avenue of the Americas"
;--------------------------------------------------------
;LibName = "Improper"   ;commented out - use if you want
;createlib LibName      ;to set up these procs by them-
;                       ;selves for a test
;--------------------------------------------------------


;--------------------------------------------------------
;we need a special error procedure to handle the run error
;when ImproperCase() assigns the changed value to a field
;with a table lookup valcheck - then you can gracefully go
;back and allow changing the lookup table or however you
;want the situation to be handled
;--------------------------------------------------------
proc ImpCaseErr()
  if errorcode() = 23 then
    beep
    message "Sorry - your entry failed a " +
            "different validity check"
    sleep 1000
  endif
  undo
  return 1
endproc

;writelib LibName ImpCaseErr
;release procs ImpCaseErr



;--------------------------------------------------------
; this proc controls right (easy) and left (trickier)
; movement by word - called when CtrlRight or CtrlLeft
; keys are pressed
;--------------------------------------------------------
proc ImpCaseWord(Direction)
  CurrentProc = "ImpCaseWord"

  if Direction = "Left" then
    if P = 1 then
      return
    endif
    if substr(S,P-1,1) = " " then
      P = P - 1
      C = C - 1
      while substr(S,P,1) = " "
        P = P - 1
        C = C - 1
        if P = 1 then
          return
        endif
      endwhile
    endif
    P = P - 1
    C = C - 1
    while substr(S,P,1) <> " "
      P = P - 1
      C = C - 1
      if P = 1 then
        return
      endif
    endwhile
    P = P + 1
    C = C + 1

  else   ;DIRECTION = RIGHT

    if P = L then
      return
    endif
    while substr(S,P,1) <> " "
      P = P + 1
      C = C + 1
      if P = L or P = 1 then
        return
      endif
    endwhile
    while substr(S,P,1) = " "
      P = P + 1
      C = C + 1
      if P = L or P = 1 then
        return
      endif
    endwhile

  endif
endproc

;writelib LibName ImpCaseWord
;release procs ImpCaseWord



;-----------------------HERE'S THE MAIN PROC---------------------
proc ImproperCase()
  private x,N,R,C,C1,C2,P,S,Ch,ErrorProc,A
  CurrentProc = "ImproperCase"

  ErrorProc = "ImpCaseErr"

  if search(sysmode(),"CoEditDataEntry") = 0 then
    beep
    message "You must be editing a table to use ImproperCase"
    sleep 1000
    return false
  endif

  if substr(fieldtype(),1,1) <> "A" then
    beep
    message "You must be in an AlphaNumeric field",
            " to use ImproperCase"
    sleep 1000
    return false
  endif

  ; only reliable in CoEdit mode because nkeyfields()
  ; always returns 0 in other editing modes
  if colno() <= nkeyfields(table())+1 then
    beep
    message "Sorry - we don't do key fields"
    sleep 1000
    return false
  endif

  L = len([])
  S = []       ;save it before fieldview restores proper case
  Ch = ""

  fieldview    ;will re-cap the field
  home         ;go to beginning of the field
  synccursor   ;synch PAL cursor with workspace sursor
  C1 = col()   ;get first character position
  R = row()
  end          ;go the end of the field
  synccursor
  ;end moves cursor to just beyond the last character,
  ;so we have to subtract 1 to get last character position
  C2 = col()-1

  if row() <> R then  ;see if we're on a different row
    beep
    enter
    message "ImproperCase cannot work in wrapped fields"
    sleep 1000
    return false
  endif

  enter        ;end the fieldview
  [] = S       ;restore from pre-fieldview state

  P = 1        ;position in string
  C = C1       ;cursor position on screen
  A = syscolor(0)  ;get top screen menu attribute

  cursor off
  ;write user prompts on the top two lines
  @ 0,0 ?? format("w62,al",chr(27)+" "+chr(26) +
           " move by character, Ctrl "+chr(27) +
           " " + chr(26) + " by word, Home, End") +
           format("w18,ar","Enter when done")
  @ 1,0 ?? format("w62,al","Use "+chr(24)+"," +
           chr(25)+" keys to change case at cursor") +
           format("w18,ar","  Esc to cancel")


  ;set the string area to the top line menu attributes
  paintcanvas attribute A  R,C1,R,C2

  while true

    paintcanvas blink,reverse R,C,R,C ;mark the spot
    x=getchar()
    paintcanvas R,C,R,C               ;restore to normal
    switch

      case x = -75: C = max(C1,C-1)            ;Left
                    P = max(P-1,1)

      case x = -77: C = min(C2,C+1)            ;Right
                    P = min(P+1,L)

      case x = -115: ImpCaseWord("Left")   ;CtrlLeft

      case x = -116: ImpCaseWord("Right")  ;CtrlRight

      case x = -71: C = C1                     ;Home
                    P = 1

      case x = -79: C = C2                     ;End
                    P = L

      case x = -72: Ch = upper(substr(S,P,1))  ;Up
                    S = substr(S,1,P-1) + Ch +
                        substr(S,P+1,L)
                    @ R, C1+P-1 ?? Ch

      case x = -80: Ch = lower(substr(S,P,1))  ;Down
                    S = substr(S,1,P-1) + Ch +
                        substr(S,P+1,L)
                    @ R, C1+P-1 ?? Ch

      case x =  13: [] = S                     ;Enter
                    return true

      case x =  27: return false               ;Esc

      otherwise   : beep

    endswitch
  endwhile

endproc



;writelib LIBNAME ImproperCase
;release procs ImproperCase




; -----------------------------------------------------
;            TEST SETUP FOR IMPROPER CASE
; -----------------------------------------------------
; autolib = "Improper" ; see lines commented out at the
;                      ; beginning of these procedures
; setkey 3 ImproperCase() ; CtrlC calls the proc
;
; now load up a table that has some 'proper case'
; valchecks and check it out
; -----------------------------------------------------


