;This file is copyright (c) 1991, 1992 Informant Communications Group and the
;article author. The material here may be used in an application provided
;that this copyright/disclaimer information is kept in the original source
;file. The material presented here is provided "as is" and with no guarantee.
;Informant Communications Group/Paradox Informant assume no responsibility
;for the use or misuse of the material contained within.
;
;Contents        : Script PACKID.SC
;Source File     : PACKID.SC
;Author          : Randolph Brown
;                  PC Support Center
;                  Minneapolis, MN
;                  (612) 377-2954
;
;Informant Issue : October 1992
;
;Description     : PACKID.SC finds an unused ID and enters it when adding new 
;                  names.
;
; Paradox Informant
; 10519 E. Stockton Blvd.
; Suite 142
; Elk Grove, CA  95624-9743
; Phone: (916) 686-6610
; Fax  : (916) 686-8497
; BBS  : (916) 686-4740


CLEAR CLEARALL
VIEW "Master"
COEDITKEY

@5,6??"What I.D. Number do you wish to start the search from? "

ACCEPT "S" MIN 1 MAX 3000
TO rightnum
MOVETO [ID]
WHILE TRUE
   LOCATE rightnum
   IF retval THEN
      idnum = [ID]
      QUITLOOP
      ELSE
         rightnum = rightnum - 1
   ENDIF
ENDWHILE
CLEAR
@5,6??"The genie is now seeking the next available I.D. number."
SLEEP 2000

WHILE TRUE
  IF idnum = rightnum THEN
        DOWN
        IF ISBLANK([ID]) THEN      ;You are at the end of the table so
          QUITLOOP                   ;stop looking for I.D.'s
        ENDIF
        idnum = [ID]
        rightnum = rightnum + 1
        MESSAGE "Now on record " + STRVAL(RECNO())
        LOOP
    ELSE               ;if idnum <> rightnum
       INS             ;insert blank line
       [ID] = rightnum
       WHILE TRUE
       WAIT RECORD
          PROMPT "ID for this record is " + STRVAL(rightnum) + ".",
                 "Enter data and press <F2> to save, <Esc> to cancel."
          UNTIL "F2", "esc"
          SWITCH
            CASE retval = "esc":
               CLEAR
               @5,6??"Are you sure you wish to cancel? Y/N"
               choice = GETCHAR()
               IF LOWER(CHR(choice)) = "y" THEN
                  DEL
                  QUITLOOP
                  ELSE
                     LOOP
               ENDIF
            CASE retval = "F2":
               QUITLOOP
          ENDSWITCH
       ENDWHILE
      CLEAR
      @5,6??"PRESS <enter> to move to next number or <esc> to quit."
      choice = GETCHAR()

      IF choice = ASC("Esc") THEN
            QUITLOOP
      ENDIF
      IF ISFORMVIEW() THEN
         CtrlPgDn
         ELSE
            DOWN
      ENDIF
      idnum = [ID]
      rightnum = rightnum + 1        ;reset idnum and rightnum for next
                                    ;pass thru loop.
  ENDIF
ENDWHILE
