

;BSC
; PROCEDURE   : GetFileList
; AUTHOR      : Mark T. Houpt
; COPYRIGHT   : (C) 1993 BAT-Systems Consulting
; PARAMETERS  : None
;
; RETURNS     : None
;
; Special Info: Creates a file called DosDir showing filenames,
;               size and creation date of all files with a DB or SC
;               Extension.
;
;BSC

proc GetFileList()
   ; run the GetFiles utility with two params
   ; it can have up to 9 total params, incuding different directories
   ; IE:  run norefresh "GetFiles *.DB C:\*.sc G:\Test\*.exe"
   Message "Locating files..."
   run norefresh "GetFiles *.DB *.exe *.sc2 C:\*.sys C:\*.BAT"

   clearall
   ;delete the old file if it exists
   if istable("Ddir") then
      delete "DDIR"
   endif
   ; import the FILELIST.TXT file created by GetFiles.exe

   if IsFile("FILELIST.TXT") then
      {Tools} {ExportImport} {Import} {ASCII} {Text} {Filelist} {ddir}
      clearall
   ; Delete old DosDir File
      if istable ("DOSDIR") then
         delete "DOSDIR"
      endif
   ; Create a new one
   ; Could always just empty an existing one
      create "DOSDIR"
      "NAME"    :   "A12",
      "DIRECTORY" : "A127",
      "SIZE"    :   "N",
      "DATE"    :   "D",
      "FILETIME" :   "A8"
      clearall
      ; read data in DDir File into DOSDIR file

      if Istable("DDIR") then
         if Nrecords("DDIR") >= 1 then
            recs = Nrecords("DDIR")
            view "DDir"
            coedit "DosDIR"
            for i from 1 to recs
               moveto "DDir"
               moveto record(i)
               ltext=len([text])
               nam=substr([text],1,12)
               siz=Numval(substr([text],14,12))
               MM=Substr([text],26,2)
               DD=Substr([text],29,2)
               YY=Substr([text],34,2)
               dat=Dateval(mm+"/"+dd+"/"+yy)
               tm=Substr([text],38,8)
               FDir=Substr([text],48,ltext-46)
               moveto "DosDir"
               if i > 1 then
                  end
                  down
               endif
               [name] = nam
               [Directory] = Fdir
               [size] = siz
               [date] = Dat
               [FileTime]=tm
            endfor

            do_it!
         endif
      endif
      clearall
      Message "View the results"
      beep
      sleep 1500
      view "DosDir"
   endif
endproc

GetFileList()
