;Contents        : procedure explodewindow
;Source File     : EXWIN.SC
;Submitted By    : Peter M. Jagielski, Borland International
;Revised By      : Peter M. Jagielski, Borland International
;Description     : This procedure writes an "exploding" window to the PAL
;                  canvas in a user specified color and size.
;Call Syntax     : explodewindow(trow,tcol,brow,bcol,attrib,shadow)
;Parameters      : trow = top left corner row
;                  tcol = top left corner column
;                  brow = bottom right corner row
;                  bcol = bottom right corner column
;                  attrib = color attribute (see Appendix A in PAL User's Guide)
;                  shadow = true or false
;Returns Value?  : no
;Paradox Version : 3
;Special Notes   : none

proc explodewindow(trow,tcol,brow,bcol,attrib,shadow)
 private centerrow,centercol,columnratio,r1,c1,r2,c2
  centerrow = round((trow + brow) / 2,0)                     ;get center
  centercol = round((tcol + bcol) / 2,0)                     ;  of box
  columnratio = round(((bcol - tcol) / (brow - trow)) + 1,0) ;get "scaling" ratio
  r1 = centerrow                                             ;initialize
  c1 = centercol                                             ;  counter for
  r2 = centerrow                                             ;  box
  c2 = centercol                                             ;  corners
  paintcanvas fill " " attribute attrib r1,c1,r2,c2          ;place initial block
  while (true)                                               ;while we haven't reached the corners yet
    if (r1 <> trow) then
      r1 = r1 - 1
    endif
    if (c1 > tcol + columnratio) then                        ;since there's more columns than rows,
      c1 = c1 - columnratio                                  ;  use a ratio to draw box as proportionately as possible
    else
      c1 = tcol
    endif
    if (r2 <> brow) then
      r2 = r2 + 1
    endif
    if (c2 < bcol - columnratio) then
      c2 = c2 + columnratio
    else
      c2 = bcol
    endif
    paintcanvas fill " " attribute attrib r1-1,c1,r2-1,c2         ;place a colored box
    if (r1 = trow and c1 = tcol and r2 = brow and c2 = bcol) then ;have all corners been placed
      if (shadow) then
        paintcanvas attribute 0 brow,tcol+1,brow,bcol+1           ;place horizontal shadow
        paintcanvas attribute 0 trow,bcol+1,brow,bcol+1           ;place vertical shadow
      endif
      quitloop                                                    ;get out of this while loop
    endif
  endwhile
  style attribute attrib                                          ;set background color
  paintcanvas fill "" attribute attrib trow-1,tcol+1,trow-1,bcol-1 ;place
  paintcanvas fill "" attribute attrib brow-1,tcol+1,brow-1,bcol-1 ;  the
  paintcanvas fill "" attribute attrib trow,tcol,brow-2,tcol       ;  box
  paintcanvas fill "" attribute attrib trow,bcol,brow-2,bcol       ;  borders
  @ trow-1,tcol ?? ""                                              ;place
  @ trow-1,bcol ?? ""                                              ;  the
  @ brow-1,tcol ?? ""                                              ;  box
  @ brow-1,bcol ?? ""                                              ;  corners
endproc
