;-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;               PARADOX APPLICATION DOCUMENTOR
;               ==============================
;
; Version:      1.3
;
; Written by:   Gert Bakker, UK
;
; Copyright:    The scripts and procedures contained in this file are part of
;               the "Document" application. Please see the documentation of
;               this application for the full copyright notice.
;
;               Copyright (c) 1992  Gert Bakker, UK
;-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

;-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
; The following procedures can be customised to suit your requirement:
;
; DocOut_Init
; -----------
; This procedure will initilise the array of output device/format menu options.
;
; Two  arrays need to be modified to setup tthe arrays for the output  device/
; format options.  They are "DEVOPT" for the menu options and "DEVDES" for the
; description of the options.
; Amend  the two arrays to suit your output requirements.  The information  of
; the  arrays is displayed in the OUTPUT splash screen to inform the  user  of
; the possible output devices and formats.
; Make  sure that the strings for "DEVOPT" are 1-10 chars long and the strings
; for "DEVDES" are a maximum of 60 chars. No blank values may be used.
;
; DocOut_80col
; ----------------
; This  procedure will send the standard 80 column wide documentation file  to
; the  output  device/format  you  wish to use.  All  documentation  with  the
; exception of the REPORT documentation is formatted to suit an 80 column wide
; by  60 lines long page format using FORMFEED characters to skip to the  next
; page.
;
; Amend the SWITCH CASE statements to suit your needs.  Please be sure to  use
; the  CASE statement  "frmt = devopt[n]".  This ensures that you do not  make
; spelling mistakes with the testing of the choice strings as returned by  the
; SHOWARRAY command.
;
; DocOut_Reprt
; ----------------
; This  procedure  will  send the REPORT documentation to  the  chosen  output
; device  or format.  Because reports are by nature wider than 80 columns  and
; because the documentation should reflect the actual report layout as best as
; possible,  this procedure is selected when sending the REPORT  documentation
; to the output device/format.
; Amend the SWITCH CASE statements to suit your needs.  Please be sure to  use
; the  CASE statement  "frmt = devopt[n]".  This ensures that you do not  make
; spelling mistakes with the testing of the choice strings as returned by  the
; SHOWARRAY command.
;-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

;-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
; Procedure:    DocOut_Init
;               Setup the arrays that specify the output device/format options
;               to suit your environment
;
; Arguments:    None
;
; Operation:    Set-up the array sizes and initialise the elements.
;
;-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;
PROC docout_init()                              ; DocOut_Init
    PRIVATE procname                            ; Procedure name
    procname = "Docout_Init"                    ; For use by ERRORPROCedure

    ;--------------------------------------------------------------------------
    ; Setup  the array "devopt" and "devdes" with the correct size.  Put  the
    ; Choice strings in the "devopt" elements.  Put the Prompt strings in the
    ; "devdes" elements.
    ;--------------------------------------------------------------------------
    ARRAY devopt[ 3 ]
    ARRAY devdes[ 3 ]

    ; Menu CHOICES strings
    devopt[1] = "1"
    devopt[2] = "2"
    devopt[3] = "Screen"

    ; Menu PROMPT strings
    devdes[1] = "Print document(s) to printer on LPT1"
    devdes[2] = "Print document(s) to printer on LPT2"
    devdes[3] = "View the document on the screen"

ENDPROC                                         ; (DocOut_Init)
;-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

;-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
; Procedure:    DocOut_80col( Fname, Htype, Frmt )
;               Send  the standard 80 column wide only documentation file  to
;               the output device
;
; Arguments:    Fname           Full filename of the documentation file
;               Htype           Name of the document for progress message
;               Frmt            output format option name selected
;
; Operation:    Depending on the output device/format selected,  perform  the
;               document output task.
;
; NOTE:         Change  this  routine to provide your own output  device  and
;               formatting.
;-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;
PROC docout_80col( fname, htype,  frmt )        ; DocOut_80Col
    PRIVATE procname                            ; Procedure name
    procname = "DocOut_80Col"                   ; For use by ERRORPROCedure

    ;--------------------------------------------------------------------------
    ; Send the document to the output device depending on the "frmt" argument
    ; value. Add more CASE statements, Amend the MESSAGE text and the commands
    ; to output the documentation.
    ;--------------------------------------------------------------------------
    SWITCH
        CASE frmt = devopt[1] :
            MESSAGE "Sending "+ htype +" documentation to LPT1..."
            RUN NOREFRESH "Copy "+fname+" lpt1 > nul"

        CASE frmt = devopt[2] :
            MESSAGE "Sending "+ htype +" documentation to LPT2..."
            RUN NOREFRESH "Copy "+fname+" lpt2 > nul"

        CASE frmt = devopt[3] :
            MESSAGE "Viewing "+ htype +" on the screen..."
            RUN "readme " + fname

    ENDSWITCH

ENDPROC                                         ; (DocOut_80Col)
;-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

;-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
; Procedure:    DocIut_Report( Fname, Htype, Frmt )
;               Send the report documentation file to the output device.
;               Because  the  report documentation is assumed wider  than  80
;               cols this procedure is written.
;
; Arguments:    Fname           Full filename of the documentation file
;               Htype           Name of the document for progress message
;               Frmt            output format option name selected
;
; Operation:    Depending on the output device/format selected,  perform  the
;               document output task.
;
; NOTE:         Change  this  routine to provide your own output  device  and
;               formatting.
;-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;
PROC docout_report( fname, htype, frmt )        ; DocOut_Report
    PRIVATE procname                            ; Procedure name
    procname = "DocOut_Report"                  ; For use by ERRORPROCedure

    ;--------------------------------------------------------------------------
    ; Send the document to the output device depending on the "frmt" argument
    ; value. Add more CASE statements, Amend the MESSAGE text and the commands
    ; to output the documentation.
    ;--------------------------------------------------------------------------
    SWITCH
        CASE frmt = devopt[1] :
            MESSAGE "Sending "+ htype +" documentation to LPT1..."
            RUN NOREFRESH "Copy " + fname + " lpt1 > nul"

        CASE frmt = devopt[2] :
            MESSAGE "Sending "+ htype +" documentation to LPT2..."
            RUN NOREFRESH "Copy " + fname + " lpt2 > nul"

        CASE frmt = devopt[3] :
            MESSAGE "Viewing "+ htype +" on the screen..."
            RUN "Readme " + fname

    ENDSWITCH

ENDPROC                                         ; (DocConf_OutReprt)
;-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;
;------------------------------------------------------------End of DOCCONF.sc