;********  dirutl.sc

;********  (c) Copyright 1991 by Creative Solutions
;********  All Rights Reserved
;********  PAL programming by Norm Bowler -- Compuserve ID# 72570,3654
;********
;********  Creative Solutions Computer Consulting
;********  P. O. Box 209
;********  Ridgefield, WA 98642
;********  (206) 887-0937
;********


;********  This script Creates a Paradox table which
;********  holds directory information, allowing you
;********  to build DOS shell-like functions into PAL
;********  applications.



;********
;********  NOTES
;********


;********  VARIABLES USED
;********
;********  THESE VARIABLES ARE RELEASED:
;********
;********  L    : LENGTH OF TEXT
;********  NR   : NUMBER OF RECORDS IN DIRUTIL0
;********  X    : CONTENTS OF [TEXT]
;********  TMP  : TEMP VARIABLE
;********  TMP2 : TEMP VARIABLE
;********  PATH : DIRECTORY PATH INPUT BY USER
;********
;********  THESE VARIABLES ARE RETAINED FOR USE BY YOUR APP:
;********
;********  DOSPATH   : DIRECTORY PATH RETURNED BY DOS
;********  BYTESFREE : BYTES FREE RETURNED BY DOS


;********  TABLES USED:
;********
;********  DIRUTIL0 : TEMPORARY TABLE TO HOLD RAW DIR LISTING
;********  DOSDIR   : TABLE WHICH HOLDS FORMATTED DATA

;********  PROCS USED (ALL ARE RELEASED):
;********
;********  L(Q)       : REMOVE LEADING AND TRAILING BLANKS
;********  MSG(X)     : DISPLAY MESSAGE ON LINE 22
;********  DATAFRMT() : DATA FORMATTING SCAN LOOP PROC'D FOR SPEED

;********
;********  SCRIPT BEGINS
;********



;********  setup
reset
clear
@0,0
CURSOR NORMAL

;********  LEADING AND TRAILING BLANK PROC
PROC L(Q)
  private qlen
  qlen=LEN(Q)
  WHILE SUBSTR(Q,1,1)=" "
    qlen=qlen-1
    Q=SUBSTR(Q,2,qlen)
  ENDWHILE
  WHILE SUBSTR(Q,qlen,1)=" "
    qlen=qlen-1
    Q=SUBSTR(Q,1,qlen)
  ENDWHILE
  RETURN Q
ENDPROC

PROC MSG(X)
  PRIVATE R,C
  R=ROW()
  C=COL()
  STYLE ATTRIBUTE 79
  @22,0 ?? FORMAT("W80,AC",X)
  STYLE
  @R,C
ENDPROC





;********  user inputs path

while true
  CLEAR
  @0,0 ??"ENTER DRIVE & PATH:    "
  ACCEPT "A60" picture "*!" required TO PATH
  if not retval then
    return
  endif
  l=len(path)

  ;********  if drive letter specified, check drivestatus
  if substr(path,1,1)<>"\\" then
    if not drivestatus(substr(path,1,1)) then
      msg ("Drive Not Ready!")
      beep sleep 2500 loop
    endif
  endif

  ;********  add closing backslash if necessary
  if substr(path,l,1)<>"\\" then
    path=path+"\\"
  endif

  ;********  check for existence of path
  if isfile(path+"*.*") then quitloop endif
  msg ("Path does not exist!")
  beep sleep 2500
endwhile
release vars l
CURSOR OFF

;********  PIPE DIRECTORY TO TEXT FILE
MSG ("Redirecting directory to text file. . .")
RUN norefresh "DIR "+PATH+" > dirutil.TXT"
RELEASE VARS PATH

;********  IMPORT TO TEXT TABLE
MSG ("Importing directory to text table. . .")
IF ISTABLE("dirutil0") THEN
  DELETE "dirutil0"
ENDIF
MENU {Tools} {ExportImport} {Import} {Ascii} {Text} {dirutil} {dirutil0}
RUN norefresh "del dirutil.txt"
clearall

VIEW "dirutil0"


;********  EXTRACT PATH
MSG ("Getting DOS path. . .")
MOVETO RECORD 2
l=LEN([TEXT])
DOSPATH=SUBSTR([TEXT],16,l-15)
release vars l

;********  DELETE UNECESSARY RECORDS
MSG ("Editing. . .")
MOVETO RECORD 1
coeditkey
DEL ;********  volume label
DEL ;********  path
DEL ;********  blank line
MOVETO [TEXT]
while substr([],1,1)="." del endwhile  ;********  "." and ".." directories

;********  EXTRACT BYTES FREE
MSG ("Getting bytes free. . .")
END
X=SUBSTR([TEXT],18,11)
X=L(X)
BYTESFREE=NUMVAL(X)
release vars x
DEL
DO_IT! ;********  END EDIT

MSG ("Formatting data. . .")
;********  CREATE DOSDIR TABLE
IF ISTABLE ("DOSDIR") THEN
  delete "DOSDIR"
ENDIF

Create "DOSDIR"
"TYPE"    :   "A1*",
"NAME"    :   "A8*",
"EXT"     :   "A3*",
"SIZE"    :   "N",
"DATE"    :   "D",
"TIME"    :   "A6",
"PDXTIME" :   "A8"
clearall

;********  MASSAGE & TRANSFER DATA
VIEW "DOSDIR"
COEDIT "dirutil0"
NR=NRECORDS("dirutil0")

PROC DATAFRMT()
  SCAN
    @24,0 ?? [#]," / ",NR CLEAR EOL
    X=[TEXT]
    MOVETO "DOSDIR"    DOWN

    ;********  determine whether file or directory
    IF SUBSTR(X,15,3)="DIR" THEN
      [TYPE]="D"
     ELSE
      [TYPE]="F"
      ;********  file size
      TMP=SUBSTR(X,13,9)
      TMP=L(TMP)
      [SIZE]=NUMVAL(TMP)
    ENDIF

    ;********  file name
    TMP=SUBSTR(X,1,8)
    [NAME]=L(TMP)

    ;********  file extension
    TMP=SUBSTR(X,10,3)
    [EXT]=L(TMP)

    ;********  date
    TMP=SUBSTR(X,24,8)
    IF SUBSTR(TMP,1,1)=" " THEN
      tmp2="0"+SUBSTR(TMP,2,1)
     ELSE
      tmp2=SUBSTR(TMP,1,2)
    ENDIF
    tmp2=tmp2+"/"+SUBSTR(TMP,4,2)+"/"+SUBSTR(TMP,7,2)
    [DATE]=DATEVAL(tmp2)

    ;********  time
    [TIME]=SUBSTR(X,34,6)


    ;********  PARADOX TIME
    x=SUBSTR(X,34,6)
    if substr(x,1,1)=" " then
      x="0"+substr(x,2,5)
    endif
    switch
      case substr(x,6,1)="p":
        tmp=numval(substr(x,1,2))
        if tmp<>12 then
          tmp=tmp+12
        endif
        [PDXTIME]=strval(tmp)+substr(x,3,3)+":00"
      otherwise:
        if substr(x,1,2)="12" then
          [PDXTIME]="00"+substr(x,3,3)+":00"
          else
          [PDXTIME]=substr(x,1,5)+":00"
        endif
    endswitch
    MOVETO "dirutil0"
  ENDSCAN
ENDPROC
DATAFRMT()


DO_IT! ;********  END EDIT
@24,0 clear eol
MSG("Formatting complete -- results are in DOSDIR table.")
sleep 2500

;********  cleanup

DELETE "dirutil0"
release vars nr,x,tmp,tmp2
RELEASE PROCS L,MSG,DATAFRMT

;********  dosdir on workspace in main mode
home ;********  moveto record 1


;********
;********  SCRIPT ENDS
;********
