// DIR2DB  1.0e - dec.91/nov.92 - Guido Salvestroni, Consist srl., Milano
// Compile w/Borland Turbo C v.2.0, model Large
// Include PXENGTCL.LIB in the project file

#include <dir.h>
#include <dos.h>
#include "pxengine.h"

/* If you are running on a network, uncomment the following statement
 * and also check the network-specific information (such as NETPATH,
 * NETUSERNAME, and NETTYPE)
#define NETWORK */

#ifdef NETWORK
#define NETUSERNAME    "username"    /* network username */
#define NETPATH        ""            /* .net directory */
#define NETTYPE        NOTONNET      /* network type */
#endif

// Field handles of Pdox table FIELDHANDLE Fa, Fo, Fd, Fdim, Fn;->1,2,3,4,5

// Field names of Paradox table
char *FieldNames[] =
{
    "Attribute",
    "Time",
    "Date",
    "Size",
    "Name"
};

// Field types of Paradox table
char *FieldTypes[] =
{
    "S",  // attributo FA_... vedi dos.h
    "A8", // time HH:MM:SS
    "D",
    "N",
    "A13"
};

#define NBRFIELDS    (sizeof(FieldNames) / sizeof(char *))
#define DIRTAB "Dirtab"

main(int argc, char *argv[])
{
 struct ffblk ffblk;
 TABLEHANDLE tbh;
 RECORDHANDLE rch;
 int done, mo, dd, yy, hh, mi, ss;
 char t[8];
 char dirtab[80];
 long d;

 printf("DIR2DB 1.0e - dic.91/nov.92- Guido Salvestroni, Consist srl., Milano\n");

/*----------------------------------------------------- CONTROLLO ARGOMENTI */
 if (argc < 2)
   {printf("\n-> Command line arguments to specify:\n");
    printf("1. Dos pathname for the files to include in DIRTAB.DB\n");
    printf("2. [optional] pathname for the DIRTAB Paradox table\n");
    printf("   (the default is: current.dir.\\DIRTAB.DB\n");
    printf("\n  e.g.: DIR2DB  *.C  C:\\APPL\\XYZ  (table XYZ.DB will include *.C files)\n");
    exit(1);}
 if (argc < 3) strcpy(dirtab, DIRTAB);
    else strcpy(dirtab, argv[2]);
 printf("\n path\\name: %s    DIRTAB: %s\n",argv[1],dirtab);

/* ------------------------------------------ CONTROLLO DIRECTORY NON VUOTE */
 if (findfirst(argv[1],&ffblk,FA_ARCH)!=0)
  {printf("\n-> No file for path\\name: %s\n",argv[1]); exit(2);}

/*----------------------------------------------- Inizializza l'Engine */
#ifndef NETWORK
    if (Error(PXInit()))
#else
    if (Error(PXNetInit(NETPATH, NETTYPE, NETUSERNAME)))
#endif
    exit(3);

 if (Error(PXTblCreate(dirtab, NBRFIELDS, FieldNames, FieldTypes))) exit(4);
 if (Error(PXTblOpen(dirtab, &tbh, 0, 0))) PXExit();
 if (Error(PXRecBufOpen(tbh, &rch))) PXExit();

 done = findfirst(argv[1],&ffblk,FA_ARCH);
 while (!done)
 {
   if (Error(PXRecBufEmpty(rch))) PXExit();
   if (Error(PXPutShort(rch,1,ffblk.ff_attrib))) PXExit();

   hh = (ffblk.ff_ftime >> 11) & 0x1f;
   mi = (ffblk.ff_ftime >> 5) & 0x3f;
   ss = (ffblk.ff_ftime & 0x1f) * 2;
   sprintf(t, "%02d:%02d:%02d",  hh,mi,ss);
   if (Error(PXPutAlpha(rch,2,t))) PXExit();

   mo = (ffblk.ff_fdate >> 5) & 0x0f;
   dd = ffblk.ff_fdate & 0x1f;
   yy = ((ffblk.ff_fdate >> 9) & 0x7f) + 1980;
   if (Error(PXDateEncode(mo,dd,yy,&d))) PXExit();
   if (Error(PXPutDate(rch,3,d))) PXExit();

   if (Error(PXPutLong(rch,4,ffblk.ff_fsize))) PXExit();
   if (Error(PXPutAlpha(rch,5,ffblk.ff_name))) PXExit();
   if (Error(PXRecAppend(tbh,rch))) PXExit();
   printf(" %15s\t", ffblk.ff_name);
   printf(" %02d/%02d/%02d %02d:%02d:%02d \n",   dd,mo,yy, hh,mi,ss);

   done = findnext(&ffblk);
 }
 PXExit();
 return(0);
}

int Error(int rc)
{
  if (rc != PXSUCCESS)
     printf("Error in DIR2DB: %s\n",PXErrMsg(rc));
  return rc;
}