; conform.sc
; Procedure to make the Answer table conform to another 
; table's structure.  Use this when the structures are so different
; that you cannot copy a report between them successfully.
; This procedure will work whether the source table has more, or
; less, fields than the Answer table.
; It references some message procedures which are uploaded in
; msgprocs.sc on compuserve as well.
; Written by Ann Lynnworth, uploaded to compuserve 7/27/94.
; This code was included in Ann's presentation at BIC '94.
; Permission is granted to copy & improve this code.


PROC MAKE.ANSWER.CONFORM( RPT.TBL )
; Utilities - Generic
; Restructure Answer to match RPT.TBL
; RPT.TBL --> name of "target" table, can include path
; retval  --> TRUE/FALSE: success

  Private i, nBorrow, nAnswer

  nBorrow = nFields( RPT.TBL )
  nAnswer = nFields( "Answer" )

;= Requires that starting mode be Main mode.
;=
  if sysmode() <> "Main" then
    msgStop( "SysMode is " + sysmode() + " instead of Main.  Can't continue." )
    return FALSE
  endif

;= Deletes keyviol & problems tables if pre-existant.
;=
  if isTable( "Keyviol") then
    delete "keyviol"
  endif

  if isTable( "Problems" ) Then
    delete "problems"
  endif

  Message "Making Answer table structure conform"
  {Modify} {Restructure} {Answer}
  {Borrow} Select RPT.TBL

  if sysMode() <> "Restructure" then
    Menu Esc
    ClearAll
    msgStop( "Couldn't restructure Answer table" )
    Return FALSE
  endif

;= Borrows the structure of target table (RPT.TBL)
;= Then moves cursor DOWN past those fields.
  For i From 1 to nBorrow
    Down
  Endfor

;= Then deletes all previous fields from original Answer structure.
  For i From 1 to nAnswer
    Del
  Endfor
  Do_it!

  if sysmode() = "Restructure" then
    switch
;= Selects "Trimming" automatically if necessary
;=
      case menuchoice() = "Trimming" :
        Enter
    Endswitch
  endif

;= Gives user 2-second message if key violations resulted
;=
  if table() = "Keyviol" then
    Message "There were key violations"
    Sleep 2000
    clearimage
  endif

  If table() <> "Answer" Then
    Message ""
    Menu {Cancel}
    ClearAll
    msgStop( "Couldn't conform Answer table to " + RPT.TBL )
    Return FALSE
  Endif

  ClearAll
  Message ""
  Return TRUE

ENDPROC
Writelib AppLib MAKE.ANSWER.CONFORM
Release Procs MAKE.ANSWER.CONFORM
