;  WHAT...
;  CompressLibrary() is a Paradox utility to clean up the slack space
;  in your Library files.  It presents you with an informative screen
;  as the work progresses and shows you how much you have reduced the
;  Library file size.

;  WHY...
;  This is a handy tool written in PAL and it (or a similar utility)
;  should be used to clean up an application before distribution.
;  Whenever you revise a procedure and rewrite it to a library, the old
;  version is merely flagged as obsolete and the new version is tacked
;  onto the end of your library file.  After a few rewrites you will find
;  quite a lot of wasted space -- and we all know how valuable disk space
;  is becomming now.

;  WHO...
;  For additional info on this and other utilities by R. Worrell, refer
;  inquiries to CompuServe id 71441 3664 or write to:
;                          R. Worrell
;                          206 Woodmont
;                          Georgetown, Tx. 78628

;  WHAT ELSE...
;  Source code available for $5 (includes Clock() and Colors() -- two more
;  handy PAL utilities)

;  HOW...
;  In PAL Just:           ReadLib("Compress") CompressLibrary
;                         CompressLibrary(Your_Library_Name)
;
;                         and enjoy your newfound disk space

;  CAVEATS...
;  You should have enough free space on your working disk to hold an extra
;  copy of your library file (temporarily) plus about 10k.
;  Should you loose power during the library compression or if some other
;  calamity occurs while compressing, your original library can be found
;  as "Templib.lib" in the same directory.  Simply use the DOS Rename command
;  to "Ren Templib.lib your_library_name" where your_library_name is the name
;  of your Paradox library file (without extension).  MAKE SURE YOU HAVE NO
;  OTHER LIBRARY FILE CALLED TEMPLIB.LIB IN YOUR DIRECTORY OR IT WILL BE
;  DELETED BY DOS!!!  Also, don't try to compress a library containing the
;  CompressLibrary() procedure.

;  YOUR RIGHTS...
;  Use this as often as you want, on any PC you want.  If it doesn't work
;  I apologize -- let me know what happened.  Maybe I can fix it.
;  If you want source code, I'll send it on disk with some other usefull
;  utilities for Paradox for just $5.  You will also be placed on my mailing
;  list for other powerful PAL utilities both present and future.  Should
;  you use any of my work in any of your work -- don't forget to give me
;  a little credit -- the advertising helps.

;  AND LAST
;  If you like it, please let me know -- your thanks mean a lot to me.
;  Also,  your ideas and suggestions are greatly appreciated.

AutoLib = "Compress"
 While True
  ProcName = ""
  InfoBox("|Please Enter Library Name to Compress||||",14)
  Message " Press [Enter] or [Esc] to QUIT "
  Cursor Normal
  Style Attribute 13
  @13,37 ??
  Accept "A8" to ProcName
   If (ProcName = "") or (Not IsAssigned(ProcName))
    Then QuitLoop
   EndIf
  CompressLibrary(ProcName)
  Clear
 EndWhile
