;libname="backmgr"
;Createlib libname


;HAVE FUN WITH THIS!!  please let me know what can be done to improve
;this procedure further and add more bells and whistles to it.



;Each procedure in this code is structured as follows:
;
;       PROC procedurename();---------          The Command to create
;                                               a procedure and the name
;                                               of that procedure.  The
;                                               dashed line is for convenience.
;
;       ENDPROC;-------                         Command to end a procedure
;                                               and a dashed line to help
;                                               mark the end.
;       WRITELIB libname procedurename          Command to add this procedure
;       RELEASE PROCS procedurename             to the library. libname is 
;                                               defined at the beginning of
;                                               the program.  RELEASE PROCS
;                                               is used to allow procedures
;                                               to be unloaded from memory
;                                               as they are called.
;
;THIS SCRIPT CONTAINS THE FOLLOWING PROCEDURES
;       BackupManager   This procedure was developed to provide an easy way 
;                       to incorporate a backup  function into any application.
;                       This is a common request among many users, and this 
;                       utility will fill that need


PROC BackupManager();---------------------------------------------------
;This procedure is Copyrighted (c) 1993 JRN Enterprises, but may be distributed
;freely as SHAREWARE.  No fees or royalties are required by the author.
;
;This procedure was developed to provide an easy way to incorporate a 
;backup  function into any application.  This is a common request among many
;users, and this utility will fill that need.
;
;The procedure has been soley developed and created by JRN Enteprises.  
;This procedure may be copied and improved.  This procedure
;may also be distributed with applications all long as this statement is
;included.
;
;Please pass any improvements to the author.  Merely changing such code herein
;does not entitle one to the rights of this code.
;
;02/04/93  JRN ENTERPRISES
;          John R. Nelson
;          110 W. Marley Lane
;          Simpsonville, SC  29681
;          COMPUSERVE ID: 70641,3562
;          PRODIGY ID: RPJH51A


;VARIABLES

PRIVATE
        backupstring,    ;what will be used to perform the backup
        path,            ;the path to backup to
        nocurpath,       ;dummy variable testing for the current path
        buttonvalue,     ;used in all of the dialog boxes
        drvsize,         ;what size disk will be formatted
        msg,             ;dialog messages of any length
        f,               ;length of generic messages
        time.a,          ;the time to use for backing up with the /t switch
        retval,          ;system variable
        date1.d,         ;the date to use for backing up with the /d switch
        drv,             ;the drive to back up to
        curpath,         ;the path to backup from
        backupopts,      ;the array for the backup switches
        checkbox,        ;the array for the checkboxes for backupopts
        a,               ;length of generic dialog message
        backuppath       ;the path to backup to
        


curpath=DIRECTORY()                     ;get the current path
Buttonvalue="Cancel"                    ;initialize

;set up an array for the radio buttons.  These are the options that are 
;shown in any DOS book.
ARRAY BackupOpts[7]
        BackupOpts[1]="/s Include subdirectories"
        BackupOpts[2]="/m files changed since last BU"
        BackupOpts[3]="/a Add files to those on BU disk"
        BackupOpts[4]="/f Format target disk"
        BackupOpts[5]="/d Only files modified after date"
        BackupOpts[6]="/t Only files modified after time"
        
;BEWARE!!  An error seemed to occur every time that I tried to make a log
;file.  That is why it is not included.        
;       BackupOpts[7]="/L Make log entry in specified file"   ;left this out 
                                                              ;for ease
;Array for the checkboxes themselves.  Checkbox 1 and 4 will already
;be marked when the user arrives                                                              
ARRAY Checkbox[7]
        Checkbox[1]=True
        Checkbox[4]=True


;lets show the dialog box that the user will see                                        
SHOWDIALOG "Backup Manager"              ;box title
        @3,3 HEIGHT 18 WIDTH 76          ;position and size

        @2,2 ??"Current Path: "          ;information about where we are when 
        ACCEPT @3,4 WIDTH 25             ;starting       
                "A23"
                TAG "curpathtag"
                TO curpath

        @8,2 ?? "Backup Drive: "        ;description of radio buttons        
        RADIOBUTTONS @9,5 HEIGHT 3 WIDTH 10
                "A",
                "B",
                "C"
                TAG "DrvTag"
                TO Drv


        STYLE ATTRIBUTE  126            ;yellow on gray description to show the 
        @1,44 ?? "Backup Options"       ;checkboxes
        
        CHECKBOXES @2,33 HEIGHT 7 WIDTH 40
                TAG "Check"
                BackupOpts[1] TO Checkbox[1],
                BackupOpts[2] TO Checkbox[2],
                BackupOpts[3] TO Checkbox[3],
                BackupOpts[4] TO Checkbox[4],
                BackupOpts[5] TO Checkbox[5],
                BackupOpts[6] TO Checkbox[6]
;               BackupOpts[7] TO Checkbox[7]    ;commented out because it
                                                ;is not included
        PUSHBUTTON @14,15 WIDTH 10
                "OK"
                OK
                DEFAULT
                VALUE "Accept"
                TAG "AcceptTag"
                TO Buttonvalue

        PUSHBUTTON @14,40 WIDTH 10
                "Cancel"
                Cancel
                VALUE "Cancel"
                TAG "CancelTag"
                TO Buttonvalue       
ENDDIALOG        

IF Buttonvalue="Accept" THEN            ;the user chose to continue!!
        nocurpath=TRUE                  ;dummy var. to see if the surrent path
                                        ;exists
        IF DIREXISTS(curpath)=0 THEN    ;does it exist?  
                                        ;NO!!
                msg="Directory "+curpath+" does not exist"
                a=len(msg)+10           ;get the length of the message and
                                        ;add 5 spaces to it
                f=a                     ;set f
                IF f<30 THEN            ;make sure we have a big enough box
                        f=30
                ENDIF
        
;a dialog box to give the user a chance to know that the current path does
;not exist
        SHOWDIALOG "Directory Message"  ;Initiate a SHOWDIALOG box
                @8,INT(41-f/2) HEIGHT 7 WIDTH f                 
                                                ;on length of message
                @1,4 ?? msg                     ;print the message
        
                PUSHBUTTON @3,INT(f/2)-6 WIDTH 10;Acknowledgment pushbutton
                        "OK"
                        OK
                        DEFAULT
                        VALUE "Yes"
                        TAG "ACCEPT"
                        TO Buttonvalue
        ENDDIALOG 
        nocurpath=FALSE                         ;the current path did not
                                                ;exist set the value to FALSE
        ENDIF
        IF nocurpath THEN                       ;if the current path does exist
                                                ;then keep going
        SWITCH                                  ;change the radio buttons
                CASE drv=1:                     ;to drive letters that are
                        drv="A:"                ;usable as switches
                CASE drv=2:
                        drv="B:"
                CASE drv=3:
                        drv="C:"
        ENDSWITCH
                        
        Buttonvalue="Accept"                    ;initialize
        WHILE TRUE                              ;set up a loop to check the 
                                                ;backup drive
        IF DRIVESTATUS(SUBSTR(drv,1,1))=FALSE THEN      ;is the drive ready?
                Buttonvalue="Cancel"            ;NO!!!
                msg="Drive "+drv+" is not ready, please correct the error."
                a=len(msg)+10           ;get the length of the message and
                                        ;add 5 spaces to it
                f=a                     ;set f
                IF f<30 THEN            ;Make the boz big enough
                        f=30
                ENDIF                
                SHOWDIALOG "Drive Message"  ;Initiate a SHOWDIALOG box to give the
                                            ;user a chance to reset the drive
                        @8,INT(41-f/2) HEIGHT 7 WIDTH f                 
                                                        ;on length of message
                        @1,4 ?? msg                     ;print the message
                
                        PUSHBUTTON @3,INT(f/2)-16 WIDTH 10;Acknowledgment pushbutton
                                "Retry"
                                OK
                                DEFAULT
                                VALUE "Retry"
                                TAG "ACCEPT"
                                TO Buttonvalue
                        PUSHBUTTON @3,INT(f/2)+6 WIDTH 10;Cancel pushbutton
                                "Cancel"
                                CANCEL
                                VALUE "Cancel"
                                TAG "CANCEL"
                                TO Buttonvalue                                
                ENDDIALOG 
                IF Buttonvalue="Cancel" THEN    ;the user decided not to go on
                        QUITLOOP
                ENDIF               
        ELSE                                    ;the drive was ready to start with
                QUITLOOP
        ENDIF
        ENDWHILE
        IF Buttonvalue<>"Cancel" THEN           ;OK, we are still going.  the user made
                                                ;it through the drive test.
                backuppath=drv                  ;set up the backup path
                IF Buttonvalue<>"Cancel" THEN            ;OK, the path exists
                        backupstring="BACKUP "+curpath+" "+backuppath   ;we will now set the backup string
                        IF Checkbox[1]=TRUE THEN                        ;did the user select the 's' switch?
                                backupstring=backupstring+" /s"         ;add it to the backup string
                        ENDIF
                        IF Checkbox[2]=TRUE THEN                        ;did the user select the 'm' switch
                                backupstring=backupstring+" /m"         ;add it to the backup string
                        ENDIF
                        IF Checkbox[3]=TRUE THEN                        ;did the user select the 'a' switch
                                backupstring=backupstring+" /a"         ;add it to the backup string
                        ENDIF
                        IF Checkbox[4]=TRUE THEN                        ;did the user select the 'f' switch
                                Buttonvalue="Cancel"                    ;we will initialize like Cancel
                                SHOWDIALOG "Backup Manager Disk Size"              ;box title
                                        @3,15 HEIGHT 16 WIDTH 50   ;position and size
                                        @1,10 ?? "Specify the backup disk type:"
                                
                                        RADIOBUTTONS @3,5 HEIGHT 7 WIDTH 40
                                                "160K single-sided 5.25 inch disk",
                                                "180K single-sided 5.25 inch disk",
                                                "320K double-sided 5.25 inch disk",
                                                "360K double-sided 5.25 inch disk",
                                                "1.2M double-sided 5.25 inch disk",
                                                " 720K  double-sided 3.5 inch disk",
                                                " 1.44M double-sided 3.5 inch disk"                                               
                                                TAG "Drvsize"
                                                TO Drvsize
                                
                                        PUSHBUTTON @12,10 WIDTH 10
                                                "OK"
                                                OK
                                                DEFAULT
                                                VALUE "Accept"
                                                TAG "AcceptTag"
                                                TO Buttonvalue
                                
                                        PUSHBUTTON @12,30 WIDTH 10
                                                "Cancel"
                                                Cancel
                                                VALUE "Cancel"
                                                TAG "CancelTag"
                                                TO Buttonvalue       
                                ENDDIALOG                        
                                IF Buttonvalue<>"Cancel" THEN                   ;did they choose cancel?
                                        SWITCH                                  ;no, so convert the radiobuttons
                                                CASE drvsize=1:                 ;to something meaningful.
                                                        drvsize=160
                                                CASE drvsize=2:
                                                        drvsize=180
                                                CASE drvsize=3:
                                                        drvsize=320
                                                CASE drvsize=4:
                                                        drvsize=360
                                                CASE drvsize=5:
                                                        drvsize=720
                                                CASE drvsize=6:
                                                        drvsize=1200
                                                CASE drvsize=7:
                                                        drvsize=1440
                                        ENDSWITCH                       
                                        backupstring=backupstring+" /f:"+STRVAL(drvsize)        ;add this to the backupstring
                                
                                ENDIF
                        ENDIF
                        IF Buttonvalue<>"Cancel" THEN                   ;ensure that cancel has not been chosen
                                IF Checkbox[5]=TRUE THEN                ;do they want to backup since a date?
                                        date1.d=1/1/90                  ;set default variable values
                                        Buttonvalue="Cancel"

                                        ;show a dialog box that will allow the user to enter the dates in an
                                        ;easy manner
                                        SHOWDIALOG "Date entry"
                                                @5,15 HEIGHT 8 WIDTH 53
                                        
                                                @2,2 ?? "Enter the date to backup from: "
                                                ACCEPT @2,33
                                                        WIDTH 10 "D"
                                                        MIN 1/1/90 
                                                        MAX TODAY()
                                                        REQUIRED
                                                        TAG "Date1"
                                                        TO date1.d                        

                                                PUSHBUTTON @4,5 WIDTH 10
                                                        "~O~K"
                                                        OK
                                                        VALUE "Accept"
                                                        TAG "Yes"
                                                        TO Buttonvalue
                                                PUSHBUTTON @4,35 WIDTH 10
                                                        "~C~ANCEL"
                                                        CANCEL
                                                        VALUE "Cancel"
                                                        TAG "No"
                                                        TO Buttonvalue         
                                        ENDDIALOG                                       
                                        IF Buttonvalue<>"Cancel" THEN           ;add the date to the backup string
                                                backupstring=backupstring+" /d:"+STRVAL(date1.d)
                                        ENDIF 
                                ENDIF                        
                                IF Buttonvalue<>"Cancel" THEN                   ;what about a time?
                                        IF Checkbox[6]=TRUE THEN
                                                time.a="00:00"   ;set default variable values
                                                Buttonvalue="Cancel"
        
                                                ;show a dialog box that will allow the user to enter the dates in an
                                                ;easy manner
                                                SHOWDIALOG "Time entry"
                                                        @5,15 HEIGHT 8 WIDTH 53
                                                
                                                        @2,2 ?? "Enter the time to backup from: "
                                                        ACCEPT @2,33
                                                                WIDTH 8 "A5"
                                                                PICTURE "{0#,1#,2{0,1,2,3}}:{0,1,2,3,4,5}#"
                                                                REQUIRED
                                                                TAG "timea"
                                                                TO time.a                        
        
                                                        PUSHBUTTON @4,5 WIDTH 10
                                                                "~O~K"
                                                                OK
                                                                VALUE "Accept"
                                                                TAG "Yes"
                                                                TO Buttonvalue
                                                        PUSHBUTTON @4,35 WIDTH 10
                                                                "~C~ANCEL"
                                                                CANCEL
                                                                VALUE "Cancel"
                                                                TAG "No"
                                                                TO Buttonvalue         
                                                ENDDIALOG                                       
                                                IF Buttonvalue<>"Cancel" THEN           ;add the time to the string
                                                        backupstring=backupstring+" /t:"+time.a
                                                ENDIF 
                                        ENDIF
                                        IF Buttonvalue<>"Cancel" THEN           ;Lets backup
                                                BEEP BEEP
                                                MESSAGE "Executing backup command: "
                                                SLEEP 500
                                                MESSAGE backupstring
                                                SLEEP 2000          

                                                RUN backupstring

                                                BEEP BEEP
                                                MESSAGE "Backup command executed!!"
                                                SLEEP 1000              
                                        ENDIF
                                ENDIF
                        ENDIF
                ENDIF                        
        ENDIF
        ENDIF
ENDIF
ENDPROC;---------------------------------------------------------------

;WRITELIB libname BackupManager
;RELEASE PROCS BackupManager

BackupManager()