;[]=====================================================================[]

; Copyright (c) 1993 AdSus Computer Systems.    All rights reserved
;                    PO Box 62
;                    Napier
;                    New Zealand
;
;   Compuserve       [100026,220]

; You are free to use these procedures in either private or commercial
; use as long as the above copyright message appears in the source code.

; This source code is provided "as is" and AdSus Computer Systems assumes
; no liability for any damages occuring through the use of these procedures

;[]=====================================================================[]





Release Vars All
;[]---------------------------------------------------------------------[]
;
;    GENERAL_REPORT - allows the user to select alpha/numerical listings
;                     and select a range to print....
;
;      Return         TRUE        - report selected and printed ok
;                     FALSE       - user quit or error occurred
;[]---------------------------------------------------------------------[]
Proc General_Report(tbl               ; table to print/select
                   ,rpt_n             ; numeric report to print
                   ,rpt_a             ; alpha report to print
                   ,fld_n             ; numeric field to base selection
                   ,fld_a             ; alpha field to base selection
                   ,rpt_desc          ; the report description to be displayed
                   )

     Private Prn_Rpt                  ; array to hold printer options
            ,fld
            ,rpt

     ;get selections from user
     ;~~~~~~~~~~~~~~~~~~~~~~~~
     Report.Selection()
     If retval=false then
        return false                  ; user cancelled or error
     Endif

     ; define fields depending on whether user selected ALPHA or NUMERICAL seq
     ;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     Switch
       case Prn_Rpt["Type"]=1 : fld=fld_n  rpt=rpt_n         ; numerical
       case Prn_Rpt["Type"]=2 : fld=fld_a  rpt=rpt_a         ; alphabetical
     Endswitch

     ; now perform query and sort output file
     ;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	 Message "Extracting Data From Data Files .... Please Wait"
     Menu {Ask} Select tbl
          Check
          Moveto Field fld
          Switch
            Case Prn_Rpt["Type"]=2 and search("..",Prn_Rpt["From"])<>0 :
				 Typein Prn_Rpt["From"]

            Otherwise :
				 If not isblank(Prn_Rpt["From"]) then Typein ">= "+strval(Prn_Rpt["From"]) endif
				 If not isblank(Prn_Rpt["From"]) and
					not isblank(Prn_Rpt["To"]) then Typein ", " Endif
				 If not isblank(Prn_Rpt["To"]) then Typein "<= "+Strval(Prn_Rpt["To"])
					If search("A",type(Prn_Rpt["To"]))<>0 then
                       Typein "zzzzzz"
                    Endif
                 Endif
          EndSwitch

          ; now setup for auto sorting the Answer table
          ;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
          CtrlHome
          Right
          While field()<>fld
                Rotate
          EndWhile
		  If isassigned(Prn_Rpt["Seq"]) then
             Switch
				Case Prn_Rpt["Seq"]=1 :              ; ignore normal ascending
				Case Prn_Rpt["Seq"]=2 : While checkmarkstatus()<>"CheckDescending"
                                          CheckDescending
                                    EndWhile
             EndSwitch
          Endif
          SetQueryOrder ImageOrder
          Do_it!
          Clearall

     ; check if query worked!
     ;~~~~~~~~~~~~~~~~~~~~~~~
     If not istable("Answer") or isempty("Answer") then
		beep
		message "No data to print. Press any key..."
		retval=getchar()
        Return false
        Endif

     ; now setup report parameters
     ;~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     Copyreport tbl rpt "Answer" rpt

     ; print report
     ;~~~~~~~~~~~~~
     Report.Output("Answer",rpt)
     Return true
Endproc

;[]---------------------------------------------------------------------[]
; Report.SELECTION
;
;     Parameters  none
;
;        return   Dynamic Array Prn_Rpt
;[]---------------------------------------------------------------------[]
Proc Report.Selection()

  DynArray Prn_Rpt[]

  ShowDialog rpt_desc

     @3,17 Height 19 Width 44

     Label @1,5
        "Print ~F~rom:"
        For "AcceptFrom"

     Label @3,5
        "        ~T~o:"
        For "AcceptTo"

     Accept @1,18 Width 23
       "A20"
       Tag "AcceptFrom"
       to Prn_Rpt["From"]

     Accept @3,18 Width 23
       "A20"
       Tag "AcceptTo"
       to Prn_Rpt["To"]

     @5,6 ?? "Type"

     RadioButtons @5,18
       Height 2 Width 18
       "~N~umerical","A~l~phabetical"
       Tag "Type"
       To Prn_Rpt["Type"]


     @8,6 ?? "Sequence"

     RadioButtons @8,18
       Height 2 Width 16
       "~A~scending","~D~escending"
       Tag "Sequence"
       To Prn_Rpt["Seq"]


     @11,6 ?? "Destination"

     RadioButtons @11,18
       Height 3 Width 16
       "~P~rinter","~S~creen","F~i~le"
       Tag "output"
       To Prn_Rpt["Dest"]


     PushButton @15,2 Width 10
       "~O~k"
       OK
       Default
       Value "OK"
       Tag "OK"
       To Prn_Rpt["Button"]


     PushButton @15,30 Width 10
       "~C~ancel"
       Cancel
       Value "Cancel"
       Tag "Cancel"
       To Prn_Rpt["Button"]

 EndDialog


 Switch

   Case retval=False : Return False

   Case Prn_Rpt["Dest"]=1 : ;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
           Prn_Rpt["Dest"]="Printer"
           Prn_Rpt["Copies"]=1

           ShowDialog "Select Printer Output"
              @6,22 Height 14 Width 32

              RadioButtons
              @2,10 Height 5 width 12
              "LPT~1~","LPT~2~","LPT~3~","C~O~M1","CO~M~2"
              TAG "Out_Port"
              To Prn_Rpt["Port"]

              Label @8,5
                "Co~p~ies:"
                For "NO_OF_COPIES"

              Accept @8,14 Width 6
                "S"
                Tag "NO_OF_COPIES"
                To Prn_Rpt["Copies"]

              PushButton @10,1 Width 10
                  "~O~k"
                  OK
                  Default
                  Value "OK"
                  Tag "OK"
                  To Prn_Rpt["Button"]

                PushButton @10,18 Width 10
                  "~C~ancel"
                  Cancel
                  Value "Cancel"
                  Tag "Cancel"
                  To Prn_Rpt["Button"]

           EndDialog

           If retval=false then return false Endif     ; used cancelled

   Case Prn_Rpt["Dest"]=2:  ;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
           Prn_Rpt["Dest"]="Screen"

   Case Prn_Rpt["Dest"]=3:  ;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        Prn_Rpt["Dest"]="File"
        ShowDialog "Select File Output"
           @6,12 Height 7 Width 54

           Label @1,5
             "File Name:"
             For "File_Name"

           Accept @1,18 Width 32
             "a30"
             Tag "File_Name"
             To Prn_Rpt["File"]

           PushButton @3,1 Width 10
               "~O~k"
               OK
               Default
               Value "OK"
               Tag "OK"
               To Prn_Rpt["Button"]

             PushButton @3,40 Width 10
               "~C~ancel"
               Cancel
               Value "Cancel"
               Tag "Cancel"
               To Prn_Rpt["Button"]

        EndDialog

        If retval=false then return false Endif   ; user cancelled

   Endswitch

Endproc

;[]---------------------------------------------------------------------[]
; Report.OUTPUT
; Select output device and print out
;
; Parameters: tbl     (A), report table
;             rpt     (A), report number (R - R14)
;[]---------------------------------------------------------------------[]
proc Report.output (tbl,rpt)
     Private i                        ; simple counter

  ; get the report's name to print on the top of the report
  ;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  g_report_name=get_report_name(tbl,rpt)     ; get the report name from the tbl

  switch
    case Prn_Rpt["Dest"]= "Printer" :

      Report.DESTINATION()

      If isassigned(g_setup_string) then Report.setup(g_setup_string) endif
      if CheckPrinterStatus()  then
        for i from 1 to Prn_Rpt["Copies"] report tbl rpt endfor
        Report.setup("")
      else
        return false
      endif

    case Prn_Rpt["Dest"] = "Screen" :
      {Report} {Output} select tbl
      select rpt {File}
      Select "Temp$yxz.rpt"
      if menuchoice()="Cancel" then {replace} endif
      Run Norefresh "readme Temp$xyz.rpt"
      Run NoRefresh "Del Temp$xyz.rpt"

    case Prn_Rpt["Dest"] = "File" :
      {Report} {Output} select tbl
      select rpt {File}
      Select Prn_Rpt["File"]
      if menuchoice()="Cancel" then {replace} endif
  endswitch

endproc

;[]---------------------------------------------------------------------[]
; Report.SETUP
; Setup code to report
;
; Parameters: setup (A), setup code for printer
;[]---------------------------------------------------------------------[]
;
proc Report.setup(setup)

  {Report} {SetPrinter} {Override} {Setup} ctrlbackspace Select setup

endproc

;[]---------------------------------------------------------------------[]
; Report.DESTINATION
; Setup report destination
;
; Parameters: setup (A), setup code for printer
;[]---------------------------------------------------------------------[]
;
proc Report.DESTINATION()

  {Report} {SetPrinter} {Override} {PrinterPort}
  Switch
    case Prn_Rpt["Port"]=1 : Select "LPT1"
    case Prn_Rpt["Port"]=2 : Select "LPT2"
    case Prn_Rpt["Port"]=3 : Select "LPT3"
    case Prn_Rpt["Port"]=4 : Select "COM1"
    case Prn_Rpt["Port"]=5 : Select "COM2"
  Endswitch

EndProc

;[]---------------------------------------------------------------------[]
;	 GET_REPORT_NAME - retrieves the report name from the table
;					   parameters - tbl (A), table name
;									rpt (A), report number
;[]---------------------------------------------------------------------[]
Proc get_report_name(tbl,rpt)
     Private rpt_name
     rpt=strval(rpt)
     Menu                        ;retrieve the report name
     {Report} {Change}
     Select tbl
     Select rpt
     rpt_name=Menuchoice()
     do_it!                      ;clear the report header from screen
     return rpt_name
Endproc

;[]---------------------------------------------------------------------[]
;  CHECKPRINTERSTATUS()
;
;  Parameters : none
;
;      Return:  TRUE - okay to print
;               FALSE - user pressed [ESC]
;[]---------------------------------------------------------------------[]
Proc  CheckPrinterStatus()

      While not PrinterStatus()
            beep beep
			Message "Printer is offline! - Please fix or press [Esc] to quit report"
			While charwaiting()
				  retval=getchar()
				  if revtal=chr(27) then return false endif
			Endwhile
      Endwhile
      Return true
Endproc

;WriteLib libname General_Report
;                ,Report.Selection
;                ,Report.Output
;                ,Report.Setup
;                ,Report.Destination
;                ,get_report_name
;                ,CheckPrinterStatus
;Release  Procs   All

