'////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'// 
'//		Zip Studio 1.2 COPYRIGHT 1993, 1994 Denis CHEVRON ( Patch 1, 12 july 1994 )
'//
'////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'//
'//		Zip functions declarations header file for Basic and Basic like languages
'//		To Zip, Put ZDLL12A.DLL and ZDLL12B.DLL in the current dir and add
'//		declarations below into your GLOBAL.BAS file.
'//		To UnZip, Put UZDLL12.DLL in the current dir.                               
'//
'////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'//
'//		To get more informations, have a look at ZIP.H.
'//		Patch version 1.0, see ZPATCH1.WRI for more informations
'//
'////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

'////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'//
'//		Zip functions
'//
'////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

'/* Errors constants */
Global Const ZERROR_OK		=0	' No error
Global Const ZERROR_WARNING	=1	' Just a warning (not an error)
Global Const ZERROR_DESTFILE	=2	' Destfile ( *.ZIP ) error
Global Const ZERROR_INTERNAL 	=3	' Internal error
Global Const ZERROR_FORMAT	=4	' Not a Zip file
Global Const ZERROR_NOMEM	=5	' Not enough memory 
Global Const ZERROR_NOFILE	=6	' Nothing to do ( can be just a warning )
Global Const ZERROR_NODLL	=7	' Can' t find required DLLs
Global Const ZERROR_COMMENT	=8	' Comment missing or NULL


'/* Overwrite mode */
Global Const OVERWRITE_ALWAYS	=0	' Always overwrite ( always zip files ) (default)
Global Const OVERWRITE_NEVER	=1 	' Never overwrite
Global Const OVERWRITE_PROMPT	=2	' Ask the user
Global Const OVERWRITE_UPDATE	=3	' Overwrite if external file is newer


'/* Language mode ( for the replace dialog box )*/
Global Const LANGUAGE_FRENCH	=0	' French mode
Global Const LANGUAGE_ENGLISH	=1	' US Mode ( default )


'/* More easy to use with AddFileToZip */
Global Const STOREPATH_NO	=0	' Don' t store paths
Global Const STOREPATH_YES	=1	' Store paths
Global Const RECURSE_NO		=0	' Don' t recurse sub dirs
Global Const RECURSE_YES	=1	' Recurse sub dirs


'/* Notification messages */
'Global Const ZN_ZIPPING	=WM_USER + 46	' Zipping a file, WP = compressed size in K, LP = current file name
'Global Const ZN_FILEZIPPED	=WM_USER + 45	' File is zipped, WP = compress rate, LP = file name
'Global Const ZN_WRITING	=WM_USER + 48	' Replace the Zip file, LP = zip file name
'Global Const ZN_DELETING	=WM_USER + 47	' Delete a file , LP = current file name
'Global Const ZN_REPARING	=WM_USER + 49	' Repare a Zip file, WP = (int)state
						' step =  1 : Read / Write ,  LP = current file name
						' step = 3 : Checking zip file, LP = zip file name
'Global Const ZN_COMPUTE	=WM_USER +52	' Before zip read, WP = zip files ( over 500, computing can be very long )


'/* Main functions */
Declare Sub 	 ZipInit 	Lib "ZDLL12A.dll"( ByVal szYourName$, ByVal szPassword$ )      		'Init the Zip DLL
Declare Function AddFileToZip 	Lib "ZDLL12A.dll"( ByVal szZipFile$, ByVal szMask$, ByVal OverwriteMode%, ByVal bStorePath%, ByVal bRecurse%, ByVal hParentWnd% ) As Integer	'Zip a file
Declare Function ZipDeleteFiles Lib "ZDLL12A.dll"( ByVal szZipFile$, ByVal szFiles$, ByVal hParentWnd% ) As Integer			'Delete files in a Zip
Declare Function ZipRepare 	Lib "ZDLL12A.dll"( ByVal szZipFile$, ByVal hParentWnd% ) As Integer	'Recreate the Zip file
Declare Function ZipSetComment 	Lib "ZDLL12A.dll"( ByVal szZipFile$, ByVal szComment$, ByVal hParentWnd% ) As Integer			'Set the Zip Comment
				  

'/* Helpers */
Declare Function ZipSetLanguage Lib "ZDLL12A.dll"( ByVal cZipLanguage% ) As Integer			'Set the Language
Declare Function ZipGetReplaceFlag Lib "ZDLL12A.dll"( ) As Integer				 	'Return the current overwrite mode



////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//		UnZip functions
//
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


'/* Initialisation function */
Declare Sub 	 UnzipInit Lib "UZDLL12.dll"( ByVal szYourName$, ByVal szPassword$ )	'required, if you are not a registered user szYourName = "TEST"


'/* Interface constants --- Already defined*/
'Global Const LANGUAGE_FRENCH		=0	' french language will be used in the replace dialog box
'Global Const LANGUAGE_ENGLISH		=1	' English language will be used in the replace dialog box ( default )


'/* Interface setting functions */
Declare Function UnzipSetMsgBoxTitle Lib "UZDLL12.dll"( ByVal szNewTitle$ ) As Integer	'Set the replace dialog box title ( default = "Replace...");
Declare Sub 	 UnzipSetLanguage Lib "UZDLL12.dll"( ByVal iLanguage% )			'Set the language for the replace dialog box
Declare Function UnzipSetReceivingWindow Lib "UZDLL12.dll"( ByVal hWnd% ) As Integer	'Set the window for notification messages
Declare Sub 	 UnzipSetBackgroundMode Lib "UZDLL12.dll"( ByVal bBackGroundMode% )	'if TRUE, activate the multitask mode ( default )


'/* Zip method constants */
Global Const ZMETHOD_STORED		=0
Global Const ZMETHOD_SHRUNK		=1
Global Const ZMETHOD_REDUCE1		=2
Global Const ZMETHOD_REDUCE2		=3
Global Const ZMETHOD_REDUCE3		=4
Global Const ZMETHOD_REDUCE4		=5
Global Const ZMETHOD_IMPLODE		=6
Global Const ZMETHOD_TOKEN		=7
Global Const ZMETHOD_DEFLATE		=8
Global Const ZMETHOD_UNKNOWN		=9
Global Const ZMETHOD_ERROR		=10


' ----------------------------------
' Some patched functions...
'/* Information functions ( Zip ) */
Declare Function CountFileInZip 	Lib "UZDLL12.dll"( ByVal szFileName$ ) As Integer			'Return number of files in this Zip File
' WARNING <<< -------- ( ZPATCH1 )
' As a VB user, you must call this patch function instead of GetFileNameFromZIP:
Declare Sub  VBGetFileNameFromZIP Lib "UZDLL12.DLL"( ByVal szFileName$, ByVal iFileNumber%, ByVal szResult$ )
Declare Function GetFileNameFromZIP 	Lib "UZDLL12.dll"( ByVal szFileName$, ByVal iFileNumber% ) As String	'Return the name of the iFileNumber file in this Zip File
Declare Function GetZFileOriginalSize 	Lib "UZDLL12.dll"( ByVal szZIPFileName$, ByVal szFileName$ ) As Long	'Return the not compressed size of szFileName in octets.
Declare Function GetZFileCompressedSize Lib "UZDLL12.dll"( ByVal szZIPFileName$, ByVal szFileName$ ) As Long	'Return the compressed size of szFileName in octets.
' WARNING <<< -------- ( ZPATCH1 )
' As a VB user, you must call this patch function instead of GetFileNameFromZIP:
Declare Sub  VBGetZFileDate Lib "UZDLL12.DLL"( ByVal szZIPFileName$, ByVal szFileName$, ByVal szResult$ )
Declare Function GetZFileDate 		Lib "UZDLL12.dll"( ByVal szZIPFileName$, ByVal szFileName$ ) As String	'Return the date of a file in a Zip
' WARNING <<< -------- ( ZPATCH1 )
' As a VB user, you must call this patch function instead of GetFileNameFromZIP:
Declare Sub  VBGetZFileTime Lib "UZDLL12.DLL"( ByVal szZIPFileName$, ByVal szFileName$, ByVal szResult$ )
Declare Function GetZFileTime 		Lib "UZDLL12.dll"( ByVal szZIPFileName$, ByVal szFileName$ ) As String	'Return the time of a file in a Zip
Declare Function GetZCompressMethod 	Lib "UZDLL12.dll"( ByVal szZipFileName$, ByVal szFileName$ ) As Integer	'Return the Zip method for a file ( ZMETHOD_* )
Declare Function IsThisFileAZipFile 	Lib "UZDLL12.dll"( ByVal szFileName$ ) As Integer			'Return TRUE if this file seems to be a zip file
Declare Function IsFileUnzipable 	Lib "UZDLL12.dll"( ByVal szFileName$ ) As Integer			'Return TRUE if this file name can be reproduce under DOS
Declare Function GetZipCommentLength 	Lib "UZDLL12.dll"( ByVal szFileName$ ) As Integer			'Return the size of the zip file comment in octets
Declare Function GetZipComment 		Lib "UZDLL12.dll"( ByVal szFileName$, ByVal szBuffer$ ) As Integer		'Put the zip comment in buffer


'/* Information functions ( General ) */
Declare Function bDoesFileExist 	Lib "UZDLL12.dll"( ByVal szFileName$ ) As Integer			'True if this file exists
Declare Function GetShortFileName 	Lib "UZDLL12.dll"( ByVal szFileName$ ) As String			'Return filename without any path
Declare Function GetPathFromFileName 	Lib "UZDLL12.dll"( ByVal szFileName$ ) As String			'Return the path without the file name
Declare Function IsFileNameInFilter 	Lib "UZDLL12.dll"( ByVal szFileName$, ByVal szMask$ ) As Integer	'Return TRUE if filename is in specified filter


'/* Extraction function result constants */
Global Const ZEXTRACT_OK		=0
Global Const ZEXTRACT_INTERNALERROR	=1
Global Const ZEXTRACT_FILENOTFOUND	=2
Global Const ZEXTRACT_CORRUPTED		=3
Global Const ZEXTRACT_EMPTY		=4
Global Const ZEXTRACT_ERRORINZIPFILE	=5
Global Const ZEXTRACT_NOMEM		=6
Global Const ZEXTRACT_DISKFULL		=8
Global Const ZEXTRACT_WARNING		=10


'/* Helper constants */
Global Const OVERWRITE_FALSE		=0
Global Const OVERWRITE_TRUE		=1
Global Const OVERWRITE_QUERY		=2
Global Const CREATEDIR_FALSE		=0
Global Const CREATEDIR_TRUE		=1


'/* Extraction functions */                                        
Declare Function ExtractZipFiles 	Lib "UZDLL12.dll"( ByVal szFileName$, ByVal szMask$, ByVal szDestDir$, ByVal bOverwrite%, ByVal bCreateDir% ) As Integer
Declare Function GetQueryFlag 		Lib "UZDLL12.dll"( ) As Integer						'Return the overwrite mode the user asked for


'/* Notification messages for UNZIP and VIEW*/
'Global Const ZN_OPENFILE	=WM_USER + 38	' Open a file, WP = TRUE if Ok, LP = filename
'Global Const ZN_EXPANDING	=WM_USER + 39	' Unzipping a file, WP = file current rate, LP = filename
'Global Const ZN_CLOSEFILE	=WM_USER + 40	' Close a file, WP = TRUE if Ok, LP = filename


'/* View function */
Declare Function ViewFileFromZip 	Lib "UZDLL12.dll"( ByVal szZipFile$, ByVal szMask$, ByVal bTextOnly% ) As Integer			'View one or several files in a Zip
							   


'/* ---------------------------------------- End of file ------------------------------------------*/
			
