{****************************************}
{*            WINTL.PAS 1.00            *}
{*                                      *}
{*       Author : Thomas Bargholz       *}
{*    Written : September 12th, 1994    *}
{*                                      *}
{*    Donated to the Public Domain      *}
{****************************************}

{

This unit gives you access to the country info on the PC running your
application. It can give you information from DOS and from WIN.INI, as
it's possible to set Windows to a country different to the DOS setting.

In CountryInfoRec the parameters return the following info:

CountryCode returns a code that indentifies the country. The possible
country code are:
$001 : US
$002 : Canadien-French
$003 : Latin America
$01F : Netherlands
$020 : Belgium
$021 : France
$022 : Spain
$024 : Hungary
$026 : Yugoslavia
$027 : Italy
$029 : Switzerland
$02A : Tjekia (Czechoslovakia)
$02B : Austria
$02C : UK
$02D : Denmark
$02E : Sweden
$02F : Norway
$030 : Poland
$031 : Germany
$037 : Brazil
$03D : International English (Australia in DR-DOS 5)
$051 : Japan
$052 : Korea
$056 : China
$058 : Taiwan
$05A : Turkey
$15F : Portugal
$162 : Iceland
$166 : Finland
$311 : Middle East/Saudi Arabia
$3CC : Israel

DateFormat returns a code for the type of date to display:
0 : US (mm-dd-yy)
1 : Europe (dd-mm-yy)
2 : Japan (yy-mm-dd)

TimeFormat returns a code for the type of time to display:
0 : 12h clock
1 : 24h clock

DateSeparator returns the char used to separate the different parts of
a date. E.g "-" (dd-mm-yy) or "/" (dd/mm/yy)

TimeSeparator returns the char used to separate the different parts of
a clock. E.g "." (hh.mm.ss) or ":" (hh:mm:ss)

CurrencySymbol is the symbol for the countrys currency.

ThousandSeparator is the char that separates the thousand in the numbers.
E.g "," (1,000) or "." (1.000)

DecimalSeparator is the char that separates the decimal in the numbers.
E.g "," (7,5) or "." (7.5)

DigitsAfterDecimal is the number of digits after decimal in the countrys
currency.

If you have any comments, suggestions or bug reports, please contact me:

e-mail    : tba@m.dia.dk
snail mail: Thomas Bargholz
            Smallegade 20, 3 tv.
            DK-2000 Frederiksberg
            Denmark
}


Unit WIntl;

Interface

Type
  CountryInfoRec = Record
    CountryCode : Word; {Country code for the currentcountry}
    DateFormat : Word; {Format for date (US/Europe/Japan)}
    TimeFormat : Word; {Time format (12h/24h)}
    DateSeparator : Array[0..1] Of Char;  {Char to separate date entries (d,m,y)}
    TimeSeparator : Array[0..1] Of Char;  {Char to separate time entries (h,m,s)}
    CurrencySymbol : Array[0..3] Of Char; {Currency symbol (e.g $ or )}
    ThousandSeparator : Array[0..1] Of Char; {Char to separate thousands in numbers}
    DecimalSeparator : Array[0..1] Of Char; {Char to separate decimal in numbers}
    DigitsAfterDecimal : Byte; {Number of digits after decimal in currency}
  End;

Type
  TSource = (DOS, WIN);

Procedure GetDOSCountryInfo(Var CIR : CountryInfoRec);
   {- Return the country information from DOS}

Procedure GetWinCountryInfo(Var CIR : CountryInfoRec);
   {- Return the country info from WIN.INI}

Function CountryAsString(Code : Word; Source : TSource) : PChar;
   {- Return the country as a string. Source can be either
      DOS or WIN, to determine where to get the info from}

Implementation

Uses
  WinProcs,
  WinDOS,
  Strings;

Procedure GetDosCountryInfo(Var CIR : CountryInfoRec);
Var
  Regs : TRegisters;
  CountryInfo : Array[0..33] Of Byte;
  I : Integer;
Begin
  With Regs Do
  Begin
    AX := $3800;
    DX := Ofs(CountryInfo);
    DS := Seg(CountryInfo);
    MsDos(Regs);
    CIR.CountryCode := BX;
  End;
  With CIR Do
  Begin
    DateFormat := Word(CountryInfo[1]) Shl 8 + CountryInfo[0];
    DateSeparator[0] := Char(CountryInfo[11]);
    If (CountryInfo[17] And $01) = $00 Then
      TimeFormat := 0
    Else
      TimeFormat := 1;
    TimeSeparator[0] := Char(CountryInfo[13]);
    For I := 0 To 3 Do
      CurrencySymbol[I] := Char(CountryInfo[2+I]);
    ThousandSeparator[0] := Char(CountryInfo[7]);
    DecimalSeparator[0] := Char(CountryInfo[9]);
    DigitsAfterDecimal := CountryInfo[16];
  End;
End;

Procedure GetWinCountryInfo(Var CIR : CountryInfoRec);
Var
  Return : Integer;
Begin
  With CIR Do
  Begin
    CountryCode := GetProfileInt('intl','iCountry',1);
    DateFormat := GetProfileInt('intl','iDate',0);
    TimeFormat := GetProfileInt('intl','iTime',0);
    Return := GetProfileString('intl','sDate','/',DateSeparator,2);
    Return := GetProfileString('intl','sTime',':',TimeSeparator,2);
    Return := GetProfileString('intl','sCurrency', '$', CurrencySymbol, 4);
    Return := GetProfileString('intl', 'sThousand', ',', ThousandSeparator, 2);
    Return := GetProfileString('intl', 'sDecimal', '.', DecimalSeparator, 2);
    DigitsAfterDecimal := GetProfileInt('intl', 'iDigits', 2);
  End;
End;

Function CountryAsString(Code : Word; Source : TSource) : PChar;
Var
  S : Array[0..47] Of Char;
  Return : Integer;
Begin
  If Source = WIN Then
  Begin
    Return := GetProfileString('intl', 'sCountry', 'International English', S, 48);
    CountryAsString := S;
  End
  Else
    Case Code Of
      $001 : CountryAsString := 'US';
      $002 : CountryAsString := 'Canadien-French';
      $003 : CountryAsString := 'Latin America';
      $01F : CountryAsString := 'Netherlands';
      $020 : CountryAsString := 'Belgium';
      $021 : CountryAsString := 'France';
      $022 : CountryAsString := 'Spain';
      $024 : CountryAsString := 'Hungary';
      $026 : CountryAsString := 'Yugoslavia';
      $027 : CountryAsString := 'Italy';
      $029 : CountryAsString := 'Switzerland';
      $02A : CountryAsString := 'Tjekia'; {What used to be Czechoslovakia}
      $02B : CountryAsString := 'Austria';
      $02C : CountryAsString := 'UK';
      $02D : CountryAsString := 'Denmark';
      $02E : CountryAsString := 'Sweden';
      $02F : CountryAsString := 'Norway';
      $030 : CountryAsString := 'Poland';
      $031 : CountryAsString := 'Germany';
      $037 : CountryAsString := 'Brazil';
      $03D : CountryAsString := 'International English'; {Australia in DR-DOS 5}
      $051 : CountryAsString := 'Japan';
      $052 : CountryAsString := 'Korea';
      $056 : CountryAsString := 'China';
      $058 : CountryAsString := 'Taiwan';
      $05A : CountryAsString := 'Turkey';
      $15F : CountryAsString := 'Portugal';
      $162 : CountryAsString := 'Iceland';
      $166 : CountryAsString := 'Finland';
      $311 : CountryAsString := 'Middle East/Saudi Arabia';
      $3CC : CountryAsString := 'Israel';
    Else
      CountryAsString := 'Unknown';
    End;
End;

End.