{ This file lists all definitions of records, types and fields as
  defined in WINCATOS.TPU. }

{****************************************************************
Catalog record definitions
****************************************************************}
type
  TFileRecord = record
     id : char;
     nam: array[0..11] of char;
     pat: integer;
     siz: longint;
     dat: integer;
     tim: integer;
  end;

type
  TPathRecord = record
     id : char;
     pat: array[0..63] of char;
     siz: longint;
     fil: integer;
     tok: integer; 
     res: array[0..1] of char;
  end;

type
  TVolume1Record = record
   id : char;
   lbl: array[0..11] of char;
   fre: longint;
   usd: longint;
   fil: integer;
   pat: integer;
   dat: array[0..8] of char;
   grp: array[0..8] of char;
   act: array[0..8] of char;
   own: array[0..8] of char;
   loc: array[0..8] of char;
   drv: char;
   xcl: char;
   med: char;
   res: array[0..1] of char;
end;

type
  TVolume2Record = record
   id : char; 
   com: array[0..51] of char;
   res: array[0..21] of char;
end;

type
  TVolumeIRecord = record
   id : char;
   idx: integer; 
   ico: array[0..51] of char;
   res: array[0..19] of char;
end;

{****************************************************************
Type definitions
****************************************************************}
type
FilPtr  = ^FilTabEntry;
VolPtr  = ^VolTabEntry;
PatPtr  = ^PatTabEntry;
GrpPtr  = ^GrpTabEntry;
CIBPtr  = ^Catalog_Information_Block;
VTBPtr  = ^TVolumeTable;
FTBPtr  = ^TFileTable;
ComPtr  = ^TCom_Page;

TVolumeTable = array[0..1000] of VolPtr;
TFileTable   = array[0..5000] of FilPtr;

FilTabEntry = record
   FRec : TFileRecord;     { File record }
   Link : FilPtr;          { Pointer to next file entry } 
   PPtr : PatPtr;          { Pointer to path }
   VPtr : VolPtr;          { Pointer to volume }
   Trd  : FilPtr;          { Directory thread }
   Com  : PChar;           { Pointer to comment entry } 
   Sel  : Boolean;         { True : File selected }
   Tag  : Boolean;         { True : File tagged }
   Kep  : Boolean;         { True : Keep descr. in combobox } 
end;

VolTabEntry = record
   VRec : TVolume1Record;  { Volume1 record }
   WRec : TVolume2Record;  { Volume2 record }
   IRec : TVolumeIRecord;  { VolumeI record }
   FPtr : FilPtr;          { Pointer to first file }
   PPtr : PatPtr;          { Pointer to first path }
   Tokn : Integer;         { Volume token }
   Icon : HIcon;           { Icon to display }  
   Stor : Boolean;         { True : In storage }
   Sel  : Boolean;         { True : Volume selected }
   Kep  : Boolean;         { True : keep descr. in combobox } 
end;

PatTabEntry = record
   PRec : TPathRecord;     { Path record }
   Link : PatPtr;          { Pointer to next path entry }
   VPtr : VolPtr;          { Pointer to volume }
   Trd  : FilPtr;          { Start of directory thread }
end;

GrpTabEntry = record
   Grp  : array[0..8] of char;
   Link : GrpPtr;
end;

Catalog_Information_Block = record
  Status              : word;
  Volume_Table        : VTBPtr;   { Pointer to table with pointers to all volumes }
  Total_Volumes       : longint;  { Total nr. of volumes in catalog }
  Total_Files         : longint;  { Total nr. of files }
  Total_Used          : longint;  { Total bytes used }
  Total_Free          : longint;  { Total bytes free }
  CatalogSize         : longint;  { Size of catalog in bytes }
  CatalogUpdated      : boolean;
  CatalogName         : array[0..fsPathName] of char; { current open catalog, full path }
  Last_Token          : integer;  { Last used volume token }
  Total_Groups        : longint;  { Total defined groups }
  Total_Locations     : longint;  { Total defined locations }
  Total_Owners        : longint;  { Total defined owners }
  Grp_Table           : GrpPtr;   { Pointer to first Group in chain }
  Loc_Table           : GrpPtr;   { Pointer to first location in chain} 
  Own_Table           : GrpPtr;   { Pointer to first Owner in chain }
  Com_FirstPage       : ComPtr;   { Pointer to first page textbuffer }
  Com_LastPage        : ComPtr;   { Pointer to last page textbuffer } 
  Com_Page            : ComPtr;   { Pointer to current page textbuffer }
  Com_TotalSize       : longint;  { Total size of textbuffer }
  Catalog             : file;
  { these fields are updated after SelectVolumes service }
  SV_Total_Volumes    : longint;  { Volumes in group}
  SV_Total_Files      : longint;  { Files in group}
  SV_Total_Free       : longint;  { Free space in group}
  SV_Total_Used       : longint;  { Used space in group}
  { these fields are used to select volumes } 
  SV_Group            : array[0..8] of char;
  SV_Owner            : array[0..8] of char;
  SV_Location         : array[0..8] of char;
  SV_DiskType         : char;
  SV_FreeSpace        : longint;
  { this field is updated after SearchFiles and SelectFiles services }
  SF_Total_Files      : integer;
  SF_File_Table       : FTBPtr;   { Pointer to File_Table }
  { these fields are used to search files }
  SF_Filename         : array[0..20] of char;
  SF_Extension        : array[0..20] of char;
  SF_Directory        : array[0..36] of char;
  SF_Comment          : array[0..20] of char;
  SF_Size             : longint;
  SF_Date             : word;
  SF_Range            : word;
  SF_DateFlag         : word;
end;

{****************************************************************
Global variables
****************************************************************}
var
  FileRecord    : TFileRecord;
  Volume1Record : TVolume1Record;
  Volume2Record : TVolume2Record;
  VolumeIRecord : TVolumeIRecord;
  PathRecord    : TPathRecord;

  Vol       : VolPtr;
  Fil       : FilPtr;
  Pat       : PatPtr;
  Grp       : GrpPtr;
  Loc       : GrpPtr;
  Own       : GrpPtr;
  NewGrp    : GrpPtr;

  CIB       : CIBPtr;

  work   : array[0..512] of char;
  pw     : pchar;

{****************************************************************
Global constants
****************************************************************}
const
  VSO_Volume        = $0001;
  VSO_FreeSpaceD    = $0002;
  VSO_Group         = $0004;
  VSO_FreeSpaceA    = $0008;

  VSL_Clear         = $0001;
  VSL_Select        = $0002;

  FSL_Clear         = $0001;
  FSL_Select        = $0002;

  FSO_Filename      = 1;
  FSO_Extension     = 2;
  FSO_Volume        = 3;
  FSO_DateA         = 4;
  FSO_SizeA         = 5;
  FSO_Directory     = 6;
  FSO_DateD         = 7;
  FSO_SizeD         = 8;

  SFD_Before        = $0001;
  SFD_On            = $0002;
  SFD_After         = $0004;
  SFD_Until         = $0008; 

  DF_ddmmyy         = $0001;
  DF_mmddyy         = $0002;


{****************************************************************
functions and procedures defined in WINCATOS.TPU
****************************************************************}
function  CreateCIB:CIBPtr;
procedure PurgeCIB(XCIB:CIBPtr);
procedure ReadCatalog(XCIB:CIBPtr);
procedure SortFileTable(XCIB:CIBPtr;Order:word);
procedure SelectFiles(XCIB:CIBPtr;Func:word);
procedure SelectVolumes(XCIB:CIBPtr;Func:word);
procedure SortVolumeTable(XCIB:CIBPtr; SortOrder: word);
function  GetDiskType(MediaDescriptor: char): string;
function  ConvTime(Time: integer): string;
function  ConvDate(Date: integer;Date_Format:word): string;
function  FFormat(X: longint): string;
