Unit Vmode;
{$Define Test}
{	Remove this line to remove debug code (see compiler directives). }

{	Version 1.0.0.T.
	Created Monday, January 23, 1995.

	Requires Borland Turbo Pascal version 6.0 or later to compile.

	Author:  Bruce J. Lackore of Kestrel Technologies.  
	Copyright (c) 1995 Bruce J. Lackore.  ALL RIGHTS RESERVED.
}

{$IFDEF Test}
	{$A+,B-,D+,F+,G-,I+,L+,O+,R+,S+,V-,X+}
{$ELSE}
	{$A+,B-,D-,F+,G-,I-,L-,O+,R-,S-,V-,X+}
{$ENDIF}

{	This simple unit contains the code necessary to change video modes on VGA
	and EGA monitors.  The routines are Real Simple and require no parameters
	of any kind.  Writing programs to surround them to change modes at the
	DOS prompt is trivial (see examples).

	One caveat:  I have NOT tested these routines on an EGA system - I don't
							 have one.  Let me know if they don't work for some reason.
}

Interface

Type
	Video_font_modes					= (CGA_25, EGA_25, EGA_43,
																VGA_25, VGA_43, VGA_50);

Var
	Video_font_mode:					Video_font_modes;

Procedure VGA25;

{	This procedure sets the video display to standard 25-line mode.  This
	procedure can be selected without prior knowledge of the current video
	settings, the procedure automatically presumes worst case.
}

Procedure VGA43;

{	This procedure sets the video display to the little-known 43 line mode of
	the VGA card.  (normally the 8x8 font gives 50 lines).  It does so by
	selecting the standard 8x8 font BUT it switches the scan line count from
	the normal 480 to 350, making the characters slightly larger, giving the
	43 lines of text.
}

Procedure VGA50;

{	This procedure sets the video display to standard 50-line mode.  This
	procedure can be selected without prior knowledge of the current video
	settings, the procedure automatically presumes worst case.
}

Procedure EGA25;

{	This procedure sets the video display to 25-line mode.
}

Procedure EGA43;

{	This procedure sets the video display to 43-line mode.
}

{ ************************************************************************** }

Implementation

Uses Dos;

Procedure VGA25;

	Var
		Regs:										Registers;

	Begin  { Procedure VGA25 }

		{	Reset video mode }

		Regs.Ax := $0003;
		Intr($10, Regs);

		{	Select 480 scan lines - standard }

		Regs.Ax := $1202;
		Regs.Bl := $30;
		Intr($10, Regs);

		{	Reset the video mode again (just in case) }

		Regs.Ax := $0003;
		Intr($10, Regs);

		{	Select standard 8x14 font }

		Regs.Ax := $1114;
		Regs.Bl := $00;
		Intr($10, Regs);
		Video_font_mode := VGA_25
	End;  { Procedure VGA25 }

Procedure VGA43;

	Var
		Regs:										Registers;

	Begin  {  Procedure VGA43 }

		{	Reset video mode }

		Regs.Ax := $0003;
		Intr($10, Regs);

		{	Select 350 scan lines - this gives 43 lines when using the 8x8 font }

		Regs.Ax := $1201;
		Regs.Bl := $30;
		Intr($10, Regs);

		{	Reset the video mode again (just in case) }

		Regs.Ax := $0003;
		Intr($10, Regs);

		{	Select standard 8x8 font }

		Regs.Ax := $1112;
		Regs.Bl := $00;
		Intr($10, Regs);
		Video_font_mode := VGA_43
End;  { Procedure VGA43 }

Procedure VGA50;

	Var
		Regs:										Registers;

	Begin  { Procedure VGA50 }

		{	Reset video mode }

		Regs.Ax := $0003;
		Intr($10, Regs);

		{	Select 480 scan lines - standard }

		Regs.Ax := $1202;
		Regs.Bl := $30;
		Intr($10, Regs);

		{	Reset the video mode again (just in case) }

		Regs.Ax := $0003;
		Intr($10, Regs);

		{	Select standard 8x8 font }

		Regs.Ax := $1112;
		Regs.Bl := $00;
		Intr($10, Regs);
		Video_font_mode := VGA_25
	End;  { Procedure VGA50 }

Procedure EGA25;

	Var
		Regs:										Registers;

	Begin  { Procedure EGA25 }

		{	Reset the video mode (just in case) }

		Regs.Ax := $0003;
		Intr($10, Regs);

		{	Select standard 8x14 font }

		Regs.Ax := $1114;
		Regs.Bl := $00;
		Intr($10, Regs);
		Video_font_mode := EGA_25
	End;  { Procedure EGA25 }

Procedure EGA43;

	Var
		Regs:										Registers;

	Begin  { Procedure EGA43 }

		{	Reset the video mode (just in case) }

		Regs.Ax := $0003;
		Intr($10, Regs);

		{	Select standard 8x8 font }

		Regs.Ax := $1112;
		Regs.Bl := $00;
		Intr($10, Regs);
		Video_font_mode := VGA_43
	End;  { Procedure EGA43 }

End.  { Unit Vmode }