{ *************************************************************************** }
{                  V I S U A L  I M P L E M E N T A T I O N                   }
{                            Shadowed Popup Boxes                             }
{                     Pascal Code (C)1993 Bobby R. Wallen                     }
{                            All Rights Reserved                              }
{               Please do not remove my Credits from this file                }
{ *************************************************************************** }
unit SPopup;
interface
uses OWindows, Objects, WinTypes;

const
     WM_SPOPUP_DONE = WM_USER + 1;
     SPopUp_ShadowWidth  = 16;
     SPopup_ShadowHeight = 16;
     SPopUp_MaxWidth     = 400;
     SPopUp_BrushPattern : array[0..7] of Integer = ( $AA, $55, $AA, $55,
                                                      $AA, $55, $AA, $55 );

type
     PSPopUp = ^TSPopUp;
     TSPopUp = object( TWindow )
       ABitmap : HBitmap;
       ABrush  : HBrush;
       ARect : TRect;
       PopText : array[0..1023] of Char;
       constructor Init( AParent: PWindowsObject; oX, oY : Integer;
                         AText: PChar);
       destructor  Done; virtual;
       procedure   CalcRect( var Rect: TRect; AText: PChar ); virtual;
       procedure   GetWindowClass( var AWndClass: TWndClass ); virtual;
       function    GetClassName : PChar ; virtual;
       procedure   WMRButtonDown( var Msg: TMessage ); virtual WM_First + WM_RButtonDown;
       procedure   WMMButtonDown( var Msg: TMessage ); virtual WM_First + WM_MButtonDown;
       procedure   WMLButtonDown( var Msg: TMessage ); virtual WM_First + WM_LButtonDown;
       procedure   WMKeyDown( var Msg: TMessage ); virtual WM_First + WM_KeyDown;
       procedure   WMSysKeyDown( var Msg: TMessage ); virtual WM_First + WM_SysKeyDown;
       procedure   WMNCCalcSize( var Msg: TMessage ); virtual WM_First + WM_NCCalcSize;
       procedure   WMNCPaint( var Msg: TMessage ); virtual WM_First + WM_NCPaint;
       procedure   Paint( PaintDC: HDC; var PaintStruct: TPaintStruct ); virtual;
     end;

implementation
uses WinProcs, Strings;

procedure TSPopUp.CalcRect;
var
   WinDC: HDC;
begin
     WinDC := CreateDC( 'DISPLAY', nil, nil, nil );
     SelectObject( WinDC, GetStockObject( System_Font ) );
     SetRect( ARect, 0, 0, SPopUp_MaxWidth, 0 );
     DrawText( WinDC, AText, -1, ARect, DT_NoPrefix or DT_WordBreak or DT_CalcRect );
     inc( ARect.Right, 10 );
     DeleteDC( WinDC );
end;

procedure TSPopUp.Paint;
begin
     OffsetRect( ARect, SPopUp_ShadowWidth, SPopUp_ShadowHeight );
     DrawText( PaintDC, PopText, -1, ARect, DT_WordBreak or DT_NoPrefix );
     SetFocus( HWindow );
     SetCapture( HWindow );
end;


procedure TSPopUp.GetWindowClass;
begin
     inherited GetWindowClass( AWndClass );
     AWndClass.hbrBackground := HBrush( Color_Window + 1 );
end;

function TSPopUp.GetClassName : PChar;
begin
     GetClassName := 'SPOPUP';
end;

procedure TSPopUp.WMNCCalcSize;
var
   lpClientRect : PRect;
begin
     lpClientRect := PRect( Msg.lParam );
     inc( lpClientRect^.Left, 1 );
     inc( lpClientRect^.top, 1 );
     dec( lpClientRect^.Right, SPopUp_ShadowWidth + 1 );
     dec( lpClientRect^.Bottom, SPopUp_ShadowHeight + 1 );
end;

procedure TSPopUp.WMNCPaint;
var
   WinDC : HDC;
   Rect : TRect;
   hbrFrame : HBrush;
   hbrOld   : HBrush;
begin
     WinDC := GetWindowDC( HWindow );
     GetWindowRect( HWindow, Rect );
     dec( Rect.Right, Rect.Left );
     dec( Rect.Bottom, Rect.Top );
     Rect.Top := 0;
     Rect.Left := 0;

     UnrealizeObject( ABrush );
     hbrOld := SelectObject( WinDC, ABrush );
     PatBlt( WinDC, Rect.Left + SPopUp_ShadowWidth,
             Rect.Bottom - SPopUp_ShadowHeight,
             Rect.Right - SpopUp_ShadowWidth,
             SPopUp_ShadowHeight, $A000C9 );
     PatBlt( WinDC, Rect.Right - SPopUp_ShadowWidth,
             Rect.Top + SPopUp_ShadowHeight,
             SPopUp_ShadowWidth,
             Rect.Bottom, $A000C9 );
     SelectObject( WinDC, hbrOld );
     hbrFrame := CreateSolidBrush( GetSysColor( Color_WindowFrame ) );
     dec( Rect.Right, SPopUp_ShadowWidth );
     dec( Rect.Bottom, SPopUp_ShadowHeight );
     FrameRect( WinDC, Rect, hbrFrame );
     DeleteObject( hbrFrame );
     ReleaseDC( HWindow, WinDC );
end;


constructor TSPopUp.Init;
begin
     inherited Init( AParent, nil );
     CalcRect( ARect, AText );
     Attr.X := oX;
     Attr.Y := oY;
     Attr.W := ARect.Right + SPopUp_ShadowWidth * 3 - oX;
     Attr.H := ARect.Bottom + SPopUp_ShadowHeight * 3 - oY;
     Attr.Style := WS_CHILD or WS_OVERLAPPEDWINDOW or WS_VISIBLE;
     ABitmap := CreateBitmap( 8, 8, 1, 1, @SPopUp_BrushPattern );
     ABrush  := CreatePatternBrush( ABitmap );
     StrCopy( PopText, AText );
     EnableKBHandler;
end;

destructor TSPopUp.Done;
begin
     if ABitmap <> 0 then DeleteObject( ABitmap );
     if ABrush <> 0 then DeleteObject( ABrush );
     inherited Done;
end;

procedure TSPopUp.WMRButtonDown;
begin
     ReleaseCapture;
     SendMessage( Parent^.HWindow, WM_SPOPUP_DONE, Msg.wParam, Msg.lParam );
end;

procedure TSPopUp.WMMButtonDown;
begin
     ReleaseCapture;
     SendMessage( Parent^.HWindow, WM_SPOPUP_DONE, Msg.wParam, Msg.lParam );
end;

procedure TSPopUp.WMLButtonDown;
begin
     ReleaseCapture;
     SendMessage( Parent^.HWindow, WM_SPOPUP_DONE, Msg.wParam, Msg.lParam );
end;

procedure TSPopUp.WMKeyDown;
begin
     ReleaseCapture;
     SendMessage( Parent^.HWindow, WM_SPOPUP_DONE, Msg.wParam, Msg.lParam );
end;

procedure TSPopUp.WMSysKeyDown;
begin
     ReleaseCapture;
     SendMessage( Parent^.HWindow, WM_SPOPUP_DONE, Msg.wParam, Msg.lParam );
end;

end.