{ ********************************************************************************* }
{ ** Unit AuxCRT                                                                 ** }
{ ** This unit redirects CRT output to AUX: (or to the Microsoft DBWIN tool)     ** }
{ ** to be used in place of WinCRT                                               ** }
{ ** Must be used ONCE in the main program                                       ** }
{ ** Will not work if any unit imports WinCRT                                    ** }
{ **                                                                             ** }
{ ** for trace purpose only : do NOT use Read, ReadLN                            ** }
{ **   works fine even from inside an Excel's XLL                                ** }
{ **                                                                             ** }
{ ** Written by Cyrille Chplov, 100420,1574 August 1994 - FREEWARE             ** }
{ **                                                                             ** }
{ ********************************************************************************* }

{$ifdef RETAIL}
{$UNDEF DEBUG}
{$else}
{$Define DEBUG}
{$endif}

unit AuxCRT;  { OutPutDebugStrings etc... }
interface
Uses WinTypes,WinProcs,WinDOS,strings;

{$IFDEF DEBUG}
Const
     AuxCrtActive : bool = TRUE;
{$else}
Const
     AuxCrtActive : bool = FALSE;
{$endif}


implementation



var
   buffer,buf : Array[0..500] of char;

Procedure WriteBuf(Buffer : Pchar; Count : word);
begin
     if not AuxCrtActive then exit;
     StrlCopy(buf,buffer,count);
     OutPutDebugString(buf);
end;

Procedure WriteChar(ch : char);
begin
     WriteBuf(@ch,1);
end;

Function ReadBuf(buffer : PChar; Count : word) : integer;
begin
     DebugBreak;   { pas fait pour fonctionner }
end;

Function CrtOutPut(var f : TTextRec) : integer; far;
begin
     if f.BufPos <> 0 then
     begin
          WriteBuf(PChar(f.BufPtr),f.BufPos);
          F.BufPos := 0;
     end;
     CrtOutPut := 0;
end;

Function CrtInput(var f : TTextRec) : integer; far;
begin
     F.BufEnd := ReadBuf(PChar(F.BufPtr),F.BufSize);
     F.BufPos := 0;
     CRTInput := 0;
end;

Function CrtClose(var f : TTextRec) : integer; far;
begin
     CrtClose := 0;
end;

Function CrtOpen(var f : TTextRec) : integer; far;
begin
     f.mode := fmOutPut;
     F.InOutFunc := @CrtOutPut;
     F.FlushFunc := @CrtOutPut;
     F.CloseFunc := @CrtClose;
     CrtOpen := 0;
end;

Procedure AssignCRT(var f : text);
begin
     with TTextRec(f) do
     begin
          handle := $FFFF;
          Mode := fmClosed;
          bufSize := Sizeof(buffer);
          BufPtr := @buffer;
          OpenFunc := @CrtOpen;
          StrCopy(Name,'Aux:');
     end;
end;

begin
     AssignCrt(OutPut);
     Rewrite(OutPut);    { Do NOT use Readln ! }
end.

