{$R-,K-,S-}
UNIT VBAPI_; {Visual Basic Custom Control API}
INTERFACE
  USES WINPROCS,
       WINTYPES;

CONST
	VB100_VERSION	=	$0100;
	VB200_VERSION	=	$0200;
	VB_VERSION		=	VB200_VERSION;


{General types and modifiers}

TYPE BOOL       = WordBool;
	 Enum       = Byte;
	 LPStr      = PChar;
	 Hsz        = LPHandle;
	 PHSZ       = ^HSZ;
	 HLStr      = LPHandle;
	 HCtl       = LPHandle;
     HAD        = LPHandle;
	 HFormFile  = PHandle;
	 ERR		= Word;
	 HPic       = Word;
	 Float      = Single;
     ULONG      = Longint;
     USHORT     = Word;


TYPE tOffset = Word; {offset for near pointers}

{language Variant structures}

{variant TYPE constants. these are the return value of GetVariantType.}
{these are also defined in Constant.Txt for return value of VarType()}
CONST vt_EMPTY    =0 ;  {	 Empty}
	  vt_NULL     =1 ;  {	 Null}
	  vt_I2	      =2 ;  {	 Integer}
	  vt_I4	      =3 ;  {	 Long}
	  vt_R4	      =4 ;  {	 Single}
	  vt_R8	      =5 ;  {	 Double}
	  vt_CURRENCY =6 ;  {	 Currency}
	  vt_DATE     =7 ;  {	 Date}
	  vt_STRING   =8 ;  {	 String}

TYPE tVariantType = vt_EMPTY..vt_STRING;


TYPE tCurrency = RECORD
		lo  :Longint;
        hi  :Longint;
	 END;

	 pValue 	= ^TValue;
	 tValue	= RECORD
		 case tVariantType of
			 vt_I2:(
                i2   :Integer
                );
			 vt_I4:(
                i4   :Longint
                );
			 vt_R4:(
                r4   :Single
                );
			 vt_R8:(
                r8   :Double
                );
			 vt_CURRENCY:(
                cy   :TCurrency
                );
			 vt_STRING:(
                hstr :HLStr
                );
	 END;


{The size of Variant is needed when a Variant is passed by value}
{or in a structure (user-defined TYPE).}

	PVariant   = ^TVariant;
	TVariant = RECORD
		v: array[0..15] of char;
    end;

{COLOR - a Windows RGB DWORD value.}
TYPE  Color=	TCOLORREF;
	  LPColor = ^Color;

{Property data structure}
TYPE
   TIndex = RECORD
	   datatype: Word;    {TYPE of nth index (Currently always dt_Integer)}
	   data:     Longint	   {Value of nth index}
   END;

TYPE TDataStruct = RECORD
		data: Longint;	    {Data for Get/Set}
    	cindex: Word;	    	{Number of indecies}
    	index : array[0..0]of TIndex
	END;

	PDataStruct = ^TDataStruct;


{VISUAL BASIC variable types}
CONST
	et_I2		=1 ;	{16 bit signed integer scalar or array variable}
	et_I4		=2 ;	{32 bit signed integer scalar or array variable}
	et_R4		=3 ;
	et_R8		=4 ;	{64 bit real scalar or array variable}
	et_CY		=5 ;	{64 bit currency scalar or array variable}
	et_HLSTR	=6 ;  	{string scalar or array variable}
	et_SD		=6 ;	{older string scalar or array variable}
	et_FS		=7 ;	{fixed-length string variable}


{Control Property definitions and structures.}
CONST
	pf_datatype	        =	$000000FF;
	pf_fPropArray	    =	$00000100;
	pf_fSetData	        =	$00000200;
	pf_fSetMsg	        =	$00000400;
	pf_fNoShow	        =	$00000800;
	pf_fNoRuntimeW	    =	$00001000;
	pf_fGetData	        =	$00002000;
	pf_fGetMsg	        =	$00004000;
	pf_fSetCheck	    =	$00008000;
	pf_fSaveData	    =	$00010000;
	pf_fSaveMsg	        =	$00020000;
	pf_fLoadDataOnly    =   $20010000;
	pf_fLoadMsgOnly     =   $20020000;
	pf_fGetHszMsg	    =	$00040000;
	pf_fUpdateOnEdit    =	$00080000;
	pf_fEditable	    =	$00100000;
	pf_fPreHwnd	        =	$00200000;
	pf_fDefVal	        =	$00400000;
	pf_fNoInitDef	    =	$00800000;
	pf_fNoRuntimeR	    =   $02000000;
	pf_fNoMultiSelect   =   $04000000;

TYPE  OfsPPROPINFO = tOffset;
	  pPropInfo = ^tPropInfo;
	  tPropInfo = RECORD
		  npszName    :tOffset;
		  fl          :Longint;			{pf_ flags}
		  offsetData: Byte;		{Offset into static structure}
		  infoData:	Byte;		{0 or _INFO value for bitfield}
		  dataDefault: 	Longint;		{0 or _INFO value for bitfield}
		  npszEnumList: 	tOffset;		{For TYPE == dt_ENUM, this is
						   a near ptr to a string containing
						   all the values to be displayed
						   in the popup enumeration listbox.
						   Each value is an sz, with an
						   empty sz indicated the end of list.}
		  enumMax:	Byte;		{Maximum legal value for enum.}
	  END;

{Values for PROPINFO pf_datatype}
CONST dt_HSZ	      = $01;
	  dt_SHORT		  = $02;
	  dt_Integer      = dt_SHORT;
	  dt_LONG         = $03;
	  dt_BOOL         = $04;
	  dt_COLOR        = $05;
	  dt_ENUM         = $06;
	  dt_REAL         = $07;
	  dt_XPOS         = $08;
	  dt_XSIZE        = $09;
	  dt_YPOS         = $0A;
	  dt_YSIZE        = $0B;
	  dt_PICTURE      = $0C;
	  dt_HLSTR        = $0D;
	  dt_OBJECT       =	$20;

{Control event definitions and structures.}

	ef_fNoUnload	=$00000001;

TYPE
    pEventInfo = ^tEventInfo;
	tEventInfo = RECORD
		npszName        :tOffset;
    	cParms          :Word;      {# of parameters}
    	cwParms         :Word;	    {# words of parameters}
		npParmTypes     :tOffset;	{list of parameter types}
		npszParmProf    :tOffset;	{event parameter profile string}
		fl              :Longint;	{ef_ flags}
    END;

	OfsPEVENTINFO = tOffset;


{Structure for vbm_DRAGOVER and vbm_DRAGDROP events}
TYPE
	TDRAGINFO=RECORD
		Control: 	HCtl;
		pt:			TPOINT;
		state: 		Word;	{Enter, Over, Exit; only used for vbm_DRAGOVER}
    END;

	PDRAGINFO = ^TDRAGINFO;
	NPDRAGINFO = tOffset;
	LPDRAGINFO = ^TDRAGINFO;

CONST
	drag_state_ENTER       =$00;
	drag_state_EXIT        =$01;
	drag_state_OVER        =$02;


{Control MODEL structure}

TYPE
 	LPMODEL = ^TMODEL;
	TModel=RECORD
		usVersion:		Word;		{VB version used by control}
		fl:				Longint;    {Bitfield structure}
		ctlproc:		TFARPROC;	{the control proc.}
		fsClassStyle:	Word;	 	{window class style}
		flWndStyle:		Longint;	{default window style}
		cbCtlExtra:		Word;		{# bytes alloc'd for HCtl structure}
		idBmpPalette:	Word;		{BITMAP id for tool palette}
		DefCtlName: 	tOffset;		{PSTR; 	{default control name prefix}
		ClassName:		tOffset;		{PSTR;		{Visual Basic class name}
		ParentClassName :tOffset;	{PSTR;	{Parent window class if subclassed}
		proplist:		tOffset;		{Property list}
		eventlist:		tOffset;		{Event list}
		nDefProp: 		Byte;		{index of default property}
		nDefEvent:		Byte;		{index of default event}
		nValueProp:		Byte;		{Index of control value property}
	END;



CONST
	model_fArrows	    =$00000001;
	model_fFocusOk	    =$00000002;
	model_fMnemonic     =$00000004;
	model_fChildrenOk   =$00000008;
	model_fInitMsg	    =$00000010;
	model_fLoadMsg	    =$00000020;
	model_fDesInteract  =$00000040;
	model_fInvisAtRun   =$00000080;
	model_fGraphical    =$00000100;

{MODELINFO structure}
TYPE
    LPModelInfo = ^TModelInfo;
	TModelInfo	= RECORD
		usVersion:	Word;
		lplpmodel:	^LPMODEL;
    END;


{Picture structure}
CONST
	pictype_NONE =		0;
	pictype_BITMAP		=1;
	pictype_METAFILE	=2;
	pictype_ICON		=3;

	hpic_INVALID	   =	$FFFF;
	hpic_NULL		=0;

TYPE TPicVariant = RECORD
		case  Integer of
			pictype_BitMap   :  (
               BitMap :HBitMap;
               hpal   :HPalette
               );
			pictype_MetaFile : 	(
               Meta    :THandle;
               xExt,
               yExt    :Integer);
			pictype_Icon	 :	(
               Icon   :HIcon
               );
    END;

	PPIC = ^TPIC;
	TPIC = RECORD
		picType: 	Byte;
        picVariant:	TPicVariant;
		picReserved: array[1..4] of Byte;
	END;

{Mode constants}
CONST
	mode_DESIGN	=1;
	mode_RUN	=2;
	mode_BREAK	=3;


{Control flags for use with VBSetControlFlags}
CONST
	ctlflg_HASPALETTE	          = $00000001;
	ctlflg_USESPALETTE	          = $00000002;
	ctlflg_GRAPHICALOPAQUE	      = $00000004;
	ctlflg_GRAPHICALTRANSLUCENT   = $00000008;
	ctlflg_DATACHANGED	          = $00000010;
	ctlflg_BOUNDDATASET	          = $00000020;

{Bound control interface}

{values for the sAction parameter on vbm_DATA_GET messages.}
CONST
	data_FIELDVALUE      =0;
	data_FIELDNAME	     =1;
	data_FIELDTYPE	     =2;
	data_FIELDSIZE	     =3;
	data_FIELDSCOUNT     =4;
	data_FIELDCHUNK      =5;
	data_FIELDPOSITION   =6;
	data_FIELDATTRIBUTES =7;

	data_BOF	     =16;
	data_EOF	     =17;
	data_BOOKMARK	     =18;
	data_BOOKMARKABLE    =19;
	data_UPDATABLE	     =20;
	data_RECORDCOUNT     =21;
	data_LASTMODIFIED    =22;

{sAction values during vbm_data_AVAILABLE messages}

	data_MOVEFIRST	      =64;
	data_MOVENEXT	      =65;
	data_MOVEPREV	      =66;
	data_MOVELAST	      =67;
	data_FINDFIRST	      =68;
	data_FINDNEXT	      =69;
	data_FINDPREV	      =70;
	data_FINDLAST	      =71;
	data_DELETE	      =72;
	data_ADDNEW	      =73;
	data_REFRESH	      =74;
	data_ROLLBACK	      =76;
	data_CLOSE	      =77;
	data_DATAFIELDCHANGED =78;
	data_SAVEDATA	      =79;
	data_READDATA	      =80;
	data_UPDATE	      =81;
	data_UNLOAD	      =82;


{return types for vbm_data_GET with sAction = data_FIELDTYPE}

	data_vt_BOOL	   =1;
	data_vt_VAR_BYTE   =2;
	data_vt_INTEGER    =3;
	data_vt_LONG	   =4;
	data_vt_CURRENCY   =5;
	data_vt_SINGLE	   =6;
	data_vt_DOUBLE	   =7;
	data_vt_DATETIME   =8;
	data_vt_TEXT	   =10;
	data_vt_BINARY	   =11;
	data_vt_MEMO	   =12;

{vbm_DATA_GET with sAction = data_BOOKMARK fill in ldata with one of these}

	data_BOOKMARKFIRST	  :Longint	= $80000000;
	data_BOOKMARKPREV	  :Longint	=	-1;
	data_BOOKMARKCURRENT  :Longint	=	0;
	data_BOOKMARKNEXT	  :Longint	=	1;
	data_BOOKMARKLAST	  :Longint	=$7FFFFFFF;


	da_fNull    =	$0001;
	da_fBOF     =	$0002;
	da_fEOF     =	$0004;


{DA structure used for conversations with the data control}
TYPE
	LPDataAccess = ^TDataAccess;
	TDataAccess = RECORD
		usVersion:	Word;  	{VB version of structure filled in when
							 structure is created}
		sAction:	Integer;{ on vbm_DATA_GET/SET specifies what to get/set
							 on vbm_DATA_AVAILABLE/REQUEST tells why}
		hctlData:	HCtl;	{the data control providing data}
		hctlBound:	HCtl;		  {the bound control receiving data}
		hszDataField:	HSZ; 	  {the name of the field to get value of}
		sDataFieldIndex: Integer; {the field index used when FieldName is null}
		usDataType:	Word;		  {the property datatype to convert data to}
		hlstrBookMark: HLStr;	  {used when getting multirow data}
		fs:				Word;	  {Bitfield structure}
		lData:			Longint;  {the data}
		ulChunkOffset: 	Longint;  {  the offset to start at for GetChunk}
		ulChunkNumBytes:Longint;  {  the number of bytes for GetChunk/SetChunk}
    END;


{ General routines}

CONST color_DefBitOn = $80000000;	{bit set -> Win SysColor, not RGB}
function rgbColor(Color: Longint):Longint;
function vbGetMode: Word;


{General control routines}

function vbDerefControl(Control: HCtl): Pointer;
function vbDefControlProc(Control: HCtl;Wnd: tHandle;Msg: Word; WParam: Word; LParam: Longint): Longint;
function vbRegisterModel(HMod: THandle ; var Model: TModel ): Bool;

function vbGetControlHwnd(Control: HCtl): tHandle;
function vbGetHInstance: THandle;
function vbGetControlModel(Control: HCtl): LPModel;

function vbGetControlName(Control: HCtl; lpszName: LPStr): LPStr;
function vbGetHwndControl(Wnd: tHandle): HCtl;
function vbSendControlMsg(Control: HCtl; Msg, WParam: Word; LParam: Longint): Longint;

function vbSuperControlProc(Control: HCtl; Msg, WParam: Word; LParam: Longint): Longint;
function vbRecreateControlHwnd(Control: HCtl):Word;
procedure vbDirtyForm(Control: HCtl);

function vbSetErrorMessage(error: Word; Str: LPStr): Word;
procedure vbGetAppTitle(Str: LPStr; cbMax: Word);
function vbDialogBoxParam(Instance: THandle; TemplateName: LPStr;DialogFunc: TFARPROC; lp: Longint):Integer;

{Management of dynamically allocated strings}

function vbCreateHsz(Control: HCtl; Str: LPStr): HSZ;				{Params changed}

procedure vbDestroyHsz(HSZStr: HSZ);
function vbDerefHsz(HSZStr: HSZ): LPStr;
function vbLockHsz(HSZStr: HSZ): LPStr;
procedure vbUnlockHsz(HSZStr: HSZ);

{Management of language strings}

function vbCreateHlstr(pb: Pointer; cbLen: Word): HLStr;
procedure vbDestroyHlstr(HStr: HLStr);
function vbDerefHlstr(HStr: HLStr): LPStr;
function vbGetHlstrLen(HStr: HLStr): Word;
function vbSetHlstr(PHStr: Pointer; pb: Pointer; cbLen: Word): Word;

{Firing Basic event procedures}

function vbFireEvent(Control: HCtl; IdEvent: Word; LPParams: Pointer): Word;

{Control property access}

function vbGetControlProperty(Control: HCtl; IdProp: Word; pdata:Pointer): Word;
function vbSetControlProperty(Control: HCtl; IdProp: Word; Data:Longint): Err;

{Picture management functions}

function vbAllocPic(PntPic: PPIC): HPic;
procedure vbFreePic(Pic: HPic);
function vbGetPic(Pic: HPic; PntPic: PPic): HPic;
function vbPicFromCF(PntHPic: Pointer; HData: THandle; WFormat: Word): Word;
function vbRefPic(Pic: HPic): HPic;

{File IO functions}

function vbReadFormFile(FormFile: HFormFile; pb: Pointer; cb: Word):Word;
function vbWriteFormFile(FormFile: HFormFile; pb: Pointer; cb: Word):Word;
function vbSeekFormFile(FormFile: HFormFile; OffSet: Longint): Longint;
function vbRelSeekFormFile(FormFile: HFormFile; OffSet: Longint):Longint;
function vbReadBasicFile(UsFileNo: Word; pb: Pointer; cb: Word):Word;
function vbWriteBasicFile(UsFileNo: Word; pb: Pointer; cb: Word):Word;

{Conversion functions}

function vbYPixelsToTwips(Pixels: Integer): Longint;
function vbXPixelsToTwips(Pixels: Integer): Longint;
function vbYTwipsToPixels(Twips: Longint):Integer;
function vbXTwipsToPixels(Twips: Longint):Integer;


{Ver 2.0 Functions}

function vbGetVersion: Word;

function vbSetControlFlags(Control: HCtl; mask: Longint; value: Longint ): Longint;
function vbGetCapture: HCtl;
procedure vbSetCapture(Control: HCtl );
procedure vbReleaseCapture;
procedure vbMoveControl(Control: HCtl; var Rect: TRect ; fRepaint: BOOL );
procedure vbGetControlRect(Control: HCtl ;var Rect: TRect );
procedure vbGetRectInContainer(Control: HCtl ;var Rect: TRect );
procedure vbGetClientRect(Control: HCtl ;var Rect: TRect );
procedure vbClientToScreen(Control: HCtl ;var Point: TPoint );
procedure vbScreenToClient(Control: HCtl;var Point: TPoint );
function vbIsControlVisible(Control: HCtl ): BOOL;
function vbIsControlEnabled(Control: HCtl ): BOOL;
procedure vbInvalidateRect(Control: HCtl ;var Rect: TRect ; fEraseBkGnd: BOOL );
procedure vbUpdateControl(Control: HCtl );

function vbGetControl(Control: HCtl ; gc: WORD ): HCtl;
CONST
	gc_FIRSTSIBLING       =$0000;
	gc_LASTSIBLING	      =$0001;
	gc_NEXTSIBLING	      =$0002;
	gc_PREVSIBLING	      =$0003;
	gc_CHILD	      =$0005;
	gc_CONTAINER	      =$1000;
	gc_FORM 	      =$1001;
	gc_FIRSTCONTROL       =$1002;
	gc_NEXTCONTROL	      =$1003;
	gc_FIRSTSELECTED      =$1004;
	gc_NEXTSELECTED       =$1005;

procedure vbZOrder(Control: HCtl ; zorder: WORD );
CONST
	zorder_Front	=0;
	zorder_Back 	=1;
function vbCreateTempHlstr(pb: Pointer ; cbLen: Word ): HLStr;
function vbDerefHlstrLen(HStr: HLStr ;var pCbLen: Word ): LPStr;
function vbDerefZeroTermHlstr(HStr: HLStr ): LPStr;
function vbGetHlstr(HStr: HLStr ; pb: Pointer ; cbLen: Word ): Word;
function vbResizeHlstr(HStr: HLStr ; newCbLen: Word ): Word;

{Management of language Variant data TYPE}

function vbCoerceVariant(Variant: PVariant ; vtype: Integer ; lpData: Pointer ): Word;
function vbGetVariantType(Variant: PVariant ): Integer;
function vbGetVariantValue(Variant: PVariant ; Value: PValue ): Integer;
function vbSetVariantValue(Variant: PVariant ; vtype: Integer ; lpData: Pointer ): Word;

{Management of language arrays}

  function loBound(x :Longint):Word;
  function hiBound(x :Longint):Word;

function vbArrayElement(VBArray: HAD ; cIndex: Integer ;var lpi: Integer ): Pointer;
CONST
	ab_INVALIDINDEX     =1;	  {hAD or index is bad}
function vbArrayBounds(VBArray: HAD ; index: Integer ): Longint;
function vbArrayElemSize(VBArray: HAD ): Word;
function vbArrayFirstElem(VBArray: HAD ): Pointer;
function vbArrayIndexCount(VBArray: HAD ): Integer;

{VB Error routines}

procedure vbRuntimeError(err: Word );

{Floating-point stack save/restore utilities}
function vbCbSaveFPState(pb: Pointer ; cb: Word ): Word;
procedure vbRestoreFPState(pb: Pointer );

{Picture functions}
function vbAllocPicEx(PntPic: PPIC ; usVersion: Word ): HPic;
function vbGetPicEx(Pic: HPic ; PntPic: PPIC ; usVersion: Word ): HPic;
procedure vbPaletteChanged(Control: HCtl );
function vbTranslateColor(Control: HCtl ; Color: Longint ): Longint;

{Link Interface functions}

function vbLinkPostAdvise(Control: HCtl ): Word;
function vbPasteLinkOk(var phTriplet: THANDLE ; Control: HCtl ): BOOL;

{Misc functions}
function vbFormat(vtype: Integer ; lpData: Pointer ; lpszFmt: LPStr ;
					pb: Pointer ; cb: Word ): Integer;

CONST
{Visual Basic messages}
	vbm__BASE	   =	(wm_User + $0C00);

{All properties have been loaded.  Must set model_fLoadMsg to receive.}
	vbm_CREATED	   =	(vbm__Base + $00);

{Form load is complete or dynamic control is fully loaded.  Must set}
{model_fLoadMsg to receive.}
	vbm_LOADED	   =	(vbm__Base + $01);

{Pre-hwnd properties are not yet loaded (no hwnd exists for control yet).}
{Must set model_fInitMsg to receive.}
	vbm_INITIALIZE	   =	(vbm__Base + $02);

{Get a property value.}
{[wp=iprop, lp=pdata], RetVal=ERR}
	vbm_GETPROPERTY    =	(vbm__Base + $03);

{Verify a property value.}
{[wp=iprop, lp=data], RetVal=ERR}
	vbm_CHECKPROPERTY  =	(vbm__Base + $04);

{Set a property value.}
{[wp=iprop, lp=data], RetVal=ERR}
	vbm_SETPROPERTY    =	(vbm__Base + $05);

{Write a property.}
{[wp=iprop, lp=pfileref], RetVal=ERR}
	vbm_SAVEPROPERTY   =	(vbm__Base + $06);

{Read a property.}
{[wp=iprop, lp=pfileref], RetVal=ERR}
	vbm_LOADPROPERTY   =	(vbm__Base + $07);

{Get the string representation of a property.}
{[wp=iprop, lp=HSZ FAR *], RetVal=ERR}
	vbm_GETPROPERTYHSZ =	(vbm__Base + $08);

{Create popup window used to change a property.}
{[wp=iprop, lp=listbox hwnd], RetVal=popup hwnd}
	vbm_INITPROPPOPUP  =	(vbm__Base + $09);

{Determine if Paste/PasteLink is allowed.}
{[wp=PASTETYPE], RetVal=BOOL}
	vbm_QPASTEOK	   =	(vbm__Base + $0A);

	PT_PASTE	=0;
	PT_PASTELINK	=1;

{Paste control-specific data from the clipboard.}
{[wp=PASTETYPE], RetVal=ERR}
	vbm_PASTE	   =	(vbm__Base + $0B);

{Copy control specific data to the clipboard.}
	vbm_COPY	   =	(vbm__Base + $0C);

{Control activated upon receipt of a unique mnemonic key.}
	vbm_MNEMONIC	   =	(vbm__Base + $0D);

{Posted to fire a deferred event.}
{[wp=event]}
	vbm_FIREEVENT	   =	(vbm__Base + $0E);

{Another control in drag mode drug over the control.}
{[lp=pdraginfo]}
	vbm_DRAGOVER	   =	(vbm__Base + $0F);

{This message is sent to a control that has just had another control}
{in drag mode dropped on it.}
{[lp=pdraginfo]}
	vbm_DRAGDROP	   =	(vbm__Base + $10);

{This message is sent when certain methods are invoked on controls}
{[wp=meth_, lp=far *alParams], RetVal=ERR}
	vbm_METHOD	   =	(vbm__Base + $11);

	meth_ADDITEM	=	$0001 ;{	 args are: cArgs, hszItem, [index]}
	meth_REMOVEITEM =	$0002 ;{	 args are: cArgs, index}
	meth_REFRESH	=	$0003 ;{	 no args (lp == NULL)}
	meth_MOVE	=	$0004 ;{	 args are: cArgs, left, [top, [width, [height]]]}
	meth_DRAG	=	$0005 ;{	 args are: cArgs, [cmd]}
	meth_LINKSEND   =	$0006;{  no args (lp == NULL)}
	meth_ZORDER	=	$0007 ;{	 args are: cArgs, pos}
	meth_CLEAR	=	$000A ;{	 no args (lp == NULL)}

{Clear capture and internal state.}
	vbm_CANCELMODE	   =	(vbm__Base + $12);

{Paint notification for graphical controls.}
{[wp=hdc, lp=lprect]}
	vbm_PAINT	   =	(vbm__Base + $14);

{Hit test for graphical controls.}
{[lp=lphittest], RetVal = ht_}
	vbm_HITTEST	   =	(vbm__Base + $15);

	ht_ON		  =7;
	ht_SOLID_NEAR	  =6;
	ht_PATTERN_NEAR   =5;
	ht_HOLLOW_NEAR	  =4;
	ht_SOLID	  =3;
	ht_PATTERN	  =2;
	ht_HOLLOW	  =1;
	ht_MISS 	  =0;


TYPE
    LPHitTest = ^THitTest;
	THitTest = RECORD
		pt:	TPoint;
		rect:	TRect;
    END;

CONST
{Paint the multi-select handles}
{[wp=hdc, lp=rect(in hdc coords)]}
	vbm_PAINTMULTISEL  =	(vbm__Base + $16);

{Paint the "gray rect" or ctl outline while moving/sizing ctl.}
{[wp=hdc, lp=rect(in hdc coords)]}
	vbm_PAINTOUTLINE   =	(vbm__Base + $17);

{Palette change notification.}
{[wp=fPalBack(for SelectPalette)], RetVal = return from RealizePalette}
	vbm_PALETTECHANGED =	(vbm__Base + $1B);

{Get control palette.}
{RetVal = HPALETTE.}
	vbm_GETPALETTE	   =	(vbm__Base + $1C);

{Enumerate available formats.}
{[wp=SUPPLIESDATAFORMAT or ACCEPTSDATAFORMAT]}
{[LOWORD(lp)=ennumeration(0-x)]}
	vbm_LINKENUMFORMATS=	(vbm__Base + $1E);

{Ask a control for it's LINK item name.  Return item name as lpsz in lp.}
{[wp=LINKSRCASK or LINKSRCTELL]}
{[lp=lpszItemName]}
	vbm_LINKGETITEMNAME=	(vbm__Base + $1F);

{For Server items and client pokes.}
{[wp=wFormat lp=LPLINKDATA]}
	vbm_LINKGETDATA    =	(vbm__Base + $20);

{Used in client requests, advises, and server pokes.}
{[wp=wFormat lp=LPLINKDATA]}
	vbm_LINKSETDATA    =	(vbm__Base + $21);

{Get help on property or event name.}
{[LOBYTE(wp)=vbhelp_, HIBYTE(wp)=iprop/ievent, lp=lpmodel]}
	vbm_HELP	    =	(vbm__Base + $22);

	vbhelp_PROP		=	$0001;
	vbhelp_EVT		=	$0002;
	vbhelp_CTL    	=	$0003;

{Get default size of control}
{LOWORD(RetVal)=cx, HIWORD(RetVal)=cy}
	vbm_GETDEFSIZE	   =	(vbm__Base + $23);

{Just like vbm_SAVE(LOAD)PROPERTY, but saves (loads) as text.}
	vbm_SAVETEXTPROPERTY   =	(vbm__Base + $24);
	vbm_LOADTEXTPROPERTY   =	(vbm__Base + $25);

{Is char a mnemonic for this control?}
{[wp=char] RetVal=TRUE/FALSE}
	vbm_ISMNEMONIC	   =	(vbm__Base + $26);

{Does control want to see wm_KEYUP/wm_KEYDOWN for vk?  Sent only}
{for keys which are normally trapped by VB.  E.g. Tab, Enter, etc.}
{[wp=vk] RetVal=TRUE/FALSE}
	vbm_WANTSPECIALKEY =	(vbm__Base + $27);

{Notifies a control that it has been selected in the property window.}
{[wp=multiselect ON (TRUE) or OFF (FALSE)]}
{[LOWORD(lp)=multiselect count (0 first, n last)]}
	vbm_SELECTED	   =	(vbm__Base + $28);

{Bound control interface}
	vbm_DATA_INITIATE =	(vbm__Base + $29);
	vbm_DATA_TERMINATE=	(vbm__Base + $2A);

	vbm_DATA_AVAILABLE=	(vbm__Base + $2B);
	vbm_DATA_GET	  =	(vbm__Base + $2C);
	vbm_DATA_REQUEST  =	(vbm__Base + $2D);
	vbm_DATA_SET	  =	(vbm__Base + $2E);
	vbm_DATA_METHOD   =	(vbm__Base + $2F);


{Notifications reflected back to control from parent.}
	vbn__BASE	        =	(vbm__Base + $1000);

	vbn_COMMAND		    =	(vbn__BASE + wm_COMMAND);
	vbn_CTLCOLOR		=	(vbn__BASE + wm_CTLCOLOR);
	vbn_DRAWITEM		=	(vbn__BASE + wm_DRAWITEM);
	vbn_MEASUREITEM 	=	(vbn__BASE + wm_MEASUREITEM);
	vbn_DELETEITEM		=	(vbn__BASE + wm_DELETEITEM);
	vbn_VKEYTOITEM		=	(vbn__BASE + wm_VKEYTOITEM);
	vbn_CHARTOITEM		=	(vbn__BASE + wm_CHARTOITEM);
	vbn_COMPAREITEM 	=	(vbn__BASE + wm_COMPAREITEM);
	vbn_HSCROLL		    =	(vbn__BASE + wm_HSCROLL);
	vbn_VSCROLL		    =	(vbn__BASE + wm_VSCROLL);
	vbn_PARENTNOTIFY	=	(vbn__BASE + wm_PARENTNOTIFY);

{Data xfer structure for vbm_LINKGETDATA or vbm_LINKSETDATA}
TYPE
    LPLinkData = ^TVBLinkData;
	tVBLinkData = RECORD
		wReserved  :Word;
		cb         :Longint;
		HData      :THandle;
		dwReserved :Longint;
	END;

{Link modes}
CONST
	LINKMODENONE			=0;
	LINKMODEAUTO			=1;
	LINKMODEMANUAL			=2;
	LINKMODENOTIFY                  =3;

	LINKMODESERVERPOKE		=1;
	LINKMODESERVERNOPOKE		=2;

TYPE
	VBDDEDATA 	=	TVBLINKDATA;
	LPDDEDATA 	=	LPLINKDATA;

{Misc DDE defines}
CONST
	MAX_EXEC                 = 256;
	MAXLINKITEMNAME          = 256;

	ACCEPTSDATAFORMAT        = 1;
	SUPPLIESDATAFORMAT       = 2;

	LINKSRCASK               = 0;
	LINKSRCTELL              = 1;

	link_DATA_OK			 = 0;
	link_DATA_OOM			 = 1;
	link_DATA_FORMATBAD		 = 2;
	link_DATA_SETFAILED		 = 3;

{	   Attempted to Initate on a channel that had linkmode set to None.}
	errInitOnNonServerDesk   = 6;

{The Server Channel array is filled.}
	errAllServerChUsed       = 7;

{The Set quality failed possible string too long.}
	errDataSettingFailed     = 8;

	errOutOfMemoryForLink	= 11;



{ Standard control properties}
CONST iprop_Std_NAME		    = $0000;
	  iprop_Std_CTLNAME	        = iprop_Std_NAME;
	  iprop_Std_INDEX 	        = $0001;
	  iprop_Std_HWND		    = $0002;
	  iprop_Std_BACKCOLOR	    = $0003;
	  iprop_Std_FORECOLOR	    = $0004;
	  iprop_Std_LEFT		    = $0005;
	  iprop_Std_TOP		        = $0006;
	  iprop_Std_WIDTH 	        = $0007;
	  iprop_Std_HEIGHT	        = $0008;
	  iprop_Std_ENABLED	        = $0009;
	  iprop_Std_VISIBLE	        = $000A;
	  iprop_Std_MOUSEPOINTER	= $000B;
	  iprop_Std_CAPTION	        = $000C;
	  iprop_Std_FONTNAME	    = $000D;
	  iprop_Std_FONTBOLD	    = $000E;
	  iprop_Std_FONTITALIC	    = $000F;
	  iprop_Std_FONTSTRIKE	    = $0010;
	  iprop_Std_FONTUNDER	    = $0011;
	  iprop_Std_FONTSIZE	    = $0012;
	  iprop_Std_TABINDEX	    = $0013;
	  iprop_Std_PARENT	        = $0014;
	  iprop_Std_DRAGMODE	    = $0015;
	  iprop_Std_DRAGICON	    = $0016;
	  iprop_Std_BORDERSTYLEOFF  = $0017;
	  iprop_Std_TABSTOP	        = $0018;
	  iprop_Std_TAG		        = $0019;
	  iprop_Std_TEXT		    = $001B;
	  iprop_Std_BORDERSTYLEON   = $001C;
	  iprop_Std_CLIPCONTROLS	= $001D;
	  iprop_Std_NONE		    = $001E;
	  iprop_Std_HELPCONTEXTID   = $001F;
	  iprop_Std_LINKMODE	    = $0020;
	  iprop_Std_LINKITEM	    = $0021;
	  iprop_Std_LINKTOPIC	    = $0022;
	  iprop_Std_LINKTIMEOUT	    = $0023;
	  iprop_Std_LEFTNORUN	    = $0024;
	  iprop_Std_TOPNORUN	    = $0025;
	  iprop_Std_ALIGN 	        = $0026;
	  iprop_Std_IMEMODE	        = $0027;
	  iprop_Std_DATASOURCE	    = $0028;
	  iprop_Std_DATAFIELD	    = $0029;
	  iprop_Std_DATACHANGED	    = $002A;
	  iprop_Std_LAST		    = $0FFF;

	  ppropinfo_Std_NAME	        = OfsPPROPINFO (not iprop_Std_NAME);
	  ppropinfo_Std_CTLNAME	        = OfsPPROPINFO (not iprop_Std_NAME);
	  ppropinfo_Std_INDEX	        = OfsPPROPINFO (not iprop_Std_INDEX);
	  ppropinfo_Std_HWND	        = OfsPPROPINFO (not iprop_Std_HWND);
	  ppropinfo_Std_BACKCOLOR       = OfsPPROPINFO (not iprop_Std_BACKCOLOR);
	  ppropinfo_Std_FORECOLOR       = OfsPPROPINFO (not iprop_Std_FORECOLOR);
	  ppropinfo_Std_LEFT	        = OfsPPROPINFO (not iprop_Std_LEFT);
	  ppropinfo_Std_TOP	            = OfsPPROPINFO (not iprop_Std_TOP);
	  ppropinfo_Std_WIDTH	        = OfsPPROPINFO (not iprop_Std_WIDTH);
	  ppropinfo_Std_HEIGHT	        = OfsPPROPINFO (not iprop_Std_HEIGHT);
	  ppropinfo_Std_ENABLED	        = OfsPPROPINFO (not iprop_Std_ENABLED);
	  ppropinfo_Std_VISIBLE	        = OfsPPROPINFO (not iprop_Std_VISIBLE);
	  ppropinfo_Std_MOUSEPOINTER    = OfsPPROPINFO (not iprop_Std_MOUSEPOINTER);
	  ppropinfo_Std_CAPTION	        = OfsPPROPINFO (not iprop_Std_CAPTION);
	  ppropinfo_Std_FONTNAME	    = OfsPPROPINFO (not iprop_Std_FONTNAME);
	  ppropinfo_Std_FONTBOLD	    = OfsPPROPINFO (not iprop_Std_FONTBOLD);
	  ppropinfo_Std_FONTITALIC      = OfsPPROPINFO (not iprop_Std_FONTITALIC);
	  ppropinfo_Std_FONTSTRIKE      = OfsPPROPINFO (not iprop_Std_FONTSTRIKE);
	  ppropinfo_Std_FONTUNDER       = OfsPPROPINFO (not iprop_Std_FONTUNDER);
	  ppropinfo_Std_FONTSIZE	    = OfsPPROPINFO (not iprop_Std_FONTSIZE);
	  ppropinfo_Std_TABINDEX	    = OfsPPROPINFO (not iprop_Std_TABINDEX);
	  ppropinfo_Std_PARENT	        = OfsPPROPINFO (not iprop_Std_PARENT);
	  ppropinfo_Std_DRAGMODE	    = OfsPPROPINFO (not iprop_Std_DRAGMODE);
	  ppropinfo_Std_DRAGICON	    = OfsPPROPINFO (not iprop_Std_DRAGICON);
	  ppropinfo_Std_BORDERSTYLEOFF  = OfsPPROPINFO (not iprop_Std_BORDERSTYLEOFF);
	  ppropinfo_Std_TABSTOP	        = OfsPPROPINFO (not iprop_Std_TABSTOP);
	  ppropinfo_Std_TAG	            = OfsPPROPINFO (not iprop_Std_TAG);
	  ppropinfo_Std_TEXT	        = OfsPPROPINFO (not iprop_Std_TEXT);
	  ppropinfo_Std_BORDERSTYLEON   = OfsPPROPINFO (not iprop_Std_BORDERSTYLEON);
	  ppropinfo_Std_CLIPCONTROLS    = OfsPPROPINFO (not iprop_Std_CLIPCONTROLS);
	  ppropinfo_Std_NONE	        = OfsPPROPINFO (not iprop_Std_NONE);
	  ppropinfo_Std_HELPCONTEXTID   = OfsPPROPINFO (not iprop_Std_HELPCONTEXTID);
	  ppropinfo_Std_LINKMODE	    = OfsPPROPINFO (not iprop_Std_LINKMODE);
	  ppropinfo_Std_LINKITEM	    = OfsPPROPINFO (not iprop_Std_LINKITEM);
	  ppropinfo_Std_LINKTOPIC       = OfsPPROPINFO (not iprop_Std_LINKTOPIC);
	  ppropinfo_Std_LINKTIMEOUT     = OfsPPROPINFO (not iprop_Std_LINKTIMEOUT);
	  ppropinfo_Std_LEFTNORUN       = OfsPPROPINFO (not iprop_Std_LEFTNORUN);
	  ppropinfo_Std_TOPNORUN	    = OfsPPROPINFO (not iprop_Std_TOPNORUN);
	  ppropinfo_Std_ALIGN	        = OfsPPROPINFO (not iprop_Std_ALIGN);
	  ppropinfo_Std_IMEMODE	        = OfsPPROPINFO (not iprop_Std_IMEMODE);
	  ppropinfo_Std_DATASOURCE		= OfsPPROPINFO (not iprop_Std_DATASOURCE);
	  ppropinfo_Std_DATAFIELD	    = OfsPPROPINFO (not iprop_Std_DATAFIELD);
	  ppropinfo_Std_DATACHANGED	    = OfsPPROPINFO (not iprop_Std_DATACHANGED);
	  ppropinfo_Std_LAST	        = OfsPPROPINFO (not iprop_Std_LAST);

{Standard control event list}
CONST ievent_Std_CLICK	    =  $0000;
	  ievent_Std_DBLCLICK	=  $0001;
	  ievent_Std_DRAGDROP	=  $0002;
	  ievent_Std_DRAGOVER	=  $0003;
	  ievent_Std_GOTFOCUS	=  $0004;
	  ievent_Std_KEYDOWN	=  $0005;
	  ievent_Std_KEYPRESS	=  $0006;
	  ievent_Std_KEYUP	    =  $0007;
	  ievent_Std_LOSTFOCUS	=  $0008;
	  ievent_Std_MOUSEDOWN	=  $0009;
	  ievent_Std_MOUSEMOVE	=  $000A;
	  ievent_Std_MOUSEUP	=  $000B;
	  ievent_Std_LINKERROR  =  $000C;
	  ievent_Std_LINKOPEN   =  $000D;
	  ievent_Std_LINKCLOSE  =  $000E;
	  ievent_Std_LINKNOTIFY =  $000F;
	  ievent_Std_LINKCHANGE =  $0010;
	  ievent_Std_NONE 	    =  $0FFF;
	  ievent_Std_LAST 	    =  $0FFF;


CONST
	peventinfo_Std_CLICK        =OfsPEVENTINFO (not ievent_Std_CLICK);
	peventinfo_Std_DBLCLICK     =OfsPEVENTINFO (not ievent_Std_DBLCLICK);
	peventinfo_Std_DRAGDROP     =OfsPEVENTINFO (not ievent_Std_DRAGDROP);
	peventinfo_Std_DRAGOVER     =OfsPEVENTINFO (not ievent_Std_DRAGOVER);
	peventinfo_Std_GOTFOCUS     =OfsPEVENTINFO (not ievent_Std_GOTFOCUS);
	peventinfo_Std_KEYDOWN	    =OfsPEVENTINFO (not ievent_Std_KEYDOWN);
	peventinfo_Std_KEYPRESS     =OfsPEVENTINFO (not ievent_Std_KEYPRESS);
	peventinfo_Std_KEYUP	    =OfsPEVENTINFO (not ievent_Std_KEYUP);
	peventinfo_Std_LOSTFOCUS    =OfsPEVENTINFO (not ievent_Std_LOSTFOCUS);
	peventinfo_Std_MOUSEDOWN    =OfsPEVENTINFO (not ievent_Std_MOUSEDOWN);
	peventinfo_Std_MOUSEMOVE    =OfsPEVENTINFO (not ievent_Std_MOUSEMOVE);
	peventinfo_Std_MOUSEUP	    =OfsPEVENTINFO (not ievent_Std_MOUSEUP);
	peventinfo_Std_LINKERROR    =OfsPEVENTINFO (not ievent_Std_LINKERROR);
	peventinfo_Std_LINKOPEN	    =OfsPEVENTINFO (not ievent_Std_LINKOPEN);
	peventinfo_Std_LINKCLOSE    =OfsPEVENTINFO (not ievent_Std_LINKCLOSE);
	peventinfo_Std_LINKNOTIFY   =OfsPEVENTINFO (not ievent_Std_LINKNOTIFY);
	peventinfo_Std_LINKCHANGE   =OfsPEVENTINFO (not ievent_Std_LINKCHANGE);
	peventinfo_Std_NONE		    =OfsPEVENTINFO (not ievent_Std_NONE);
	peventinfo_Std_LAST		    =OfsPEVENTINFO (not ievent_Std_LAST);


IMPLEMENTATION

function rgbColor(Color: Longint):Longint;
begin
   if (Color and color_DefBitOn) <> 0 then
	   rgbColor := GetSysColor(Color and $FFFF)
   else
      rgbColor := Color and $FFFFFF;
end;

function loBound(x :Longint):Word;
begin
  loBound := loWord(x)
end;
function hiBound(x :Longint):Word;
begin
  hiBound := hiWord(x)
end;

{$L VBAPI_.OBJ}

function vbGetMode;						external;
function vbDerefControl;				external;
function vbDefControlProc;				external;
function vbRegisterModel;				external;
function vbGetControlHwnd;				external;
function vbGetHInstance;				external;
function vbGetControlModel;				external;
function vbGetControlName;				external;
function vbGetHwndControl;				external;
function vbSendControlMsg;				external;
function vbSuperControlProc;			external;
function vbRecreateControlHwnd;			external;
procedure vbDirtyForm;					external;
function vbSetErrorMessage;				external;
procedure vbGetAppTitle;				external;
function vbDialogBoxParam;				external;
function vbCreateHsz;					external;
procedure vbDestroyHsz;					external;
function  VBDerefHsz;					external;
function  VBLockHsz;					external;
procedure vbUnlockHsz;					external;
function vbCreateHlstr;					external;
procedure vbDestroyHlstr;				external;
function vbDerefHlstr;					external;
function vbGetHlstrLen;					external;
function vbSetHlstr;					external;
function vbFireEvent;					external;
function vbGetControlProperty;			external;
function vbSetControlProperty;			external;
function vbAllocPic;					external;
procedure vbFreePic;					external;
function vbGetPic;						external;
function vbPicFromCF;					external;
function vbRefPic;						external;
function vbReadFormFile;				external;
function vbWriteFormFile;				external;
function vbSeekFormFile;				external;
function vbRelSeekFormFile;				external;
function vbReadBasicFile;				external;
function vbWriteBasicFile;				external;
function vbYPixelsToTwips;				external;
function vbXPixelsToTwips;				external;
function vbYTwipsToPixels;				external;
function vbXTwipsToPixels;				external;
function  vbGetVersion;			        external;
function  vbSetControlFlags;			external;
function  vbGetCapture;			        external;
procedure vbSetCapture;			        external;
procedure vbReleaseCapture;			    external;
procedure vbMoveControl;			    external;
procedure vbGetControlRect;			    external;
procedure vbGetRectInContainer;			external;
procedure vbGetClientRect;			    external;
procedure vbClientToScreen;			    external;
procedure vbScreenToClient;			    external;
function  vbIsControlVisible;			external;
function  vbIsControlEnabled;			external;
procedure vbInvalidateRect;			    external;
procedure vbUpdateControl;			    external;
function  vbGetControl;			        external;
procedure vbZOrder;			            external;
function  vbCreateTempHlstr;			external;
function  vbDerefHlstrLen;			    external;
function  vbDerefZeroTermHlstr;			external;
function  vbGetHlstr;			        external;
function  vbResizeHlstr;			    external;
function  vbCoerceVariant;			    external;
function  vbGetVariantType;			    external;
function  vbGetVariantValue;			external;
function  vbSetVariantValue;			external;
function  vbArrayElement;			    external;
function  vbArrayBounds;			    external;
function  vbArrayElemSize;			    external;
function  vbArrayFirstElem;			    external;
function  vbArrayIndexCount;			external;
procedure vbRuntimeError;			    external;
function  vbCbSaveFPState;			    external;
procedure vbRestoreFPState;			    external;
function  vbAllocPicEx;			        external;
function  vbGetPicEx;			        external;
procedure vbPaletteChanged;			    external;
function  vbTranslateColor;			    external;
function  vbLinkPostAdvise;			    external;
function  vbPasteLinkOk;			    external;
function  vbFormat;			            external;

END.
