(*  From:  Randy Forgaard, CIS Borland SIG  

These two short programs allow array sizes to be defined dynamically
as your program runs.  These are programs for demonstration purposes.
To incorporate either into your program, just convert it to a
procedure.

*) 

  program KnownSize;
  type
    Element = Integer;
    ElemArr = array [1..32767] of Element;
    ElemArrPtr = ^ElemArr;
  var
    a: ElemArrPtr;
    size, i: Integer;
  begin

    {Get array size}
    write('How many elements? ');
    readln(size);
    GetMem(a, size * SizeOf(Element));

    {Fill the array}
    writeln('Please input the elements --');
    for i := 1 to size do
      begin
        write('Value ', i, ': ');
        readln(a^[i])
      end;

    {Output the array}
    writeln;
    writeln('The elements are --');
    for i := 1 to size do
      writeln('Value ', i, ': ', a^[i])
  end.

Sometimes, you won't know the eventual size of the array before you
starting building the array.  Like, if you are reading a directory, you
don't know how many entries are in the directory until you get to the
last one.  For these applications, a linked list often works best.
Here's a simple example:

*)

  program VariableSize;

  type
    ElemType = Integer;
    List = ^Element;
    Element = record
                elem: ElemType;
                next: List
              end;
  var
    start, current: List;
    e: ElemType;

  begin

    {Build list}
    New(start);
    current := start;
    repeat
      write('Next integer (0 will be last element): ');
      readln(e);
      if e <> 0 then
        begin
          current^.elem := e;
          New(current^.next);
          current := current^.next
        end
    until e = 0;
    current^.next := nil;

    {Output list}
    writeln;
    writeln('The list:');
    current := start;
    while current <> nil do
      begin
        writeln(current^.elem);
        current := current^.next
      end
  end.


