{$S-,R-,V-,I-,B-,F+,X+}
{$M 8192,0,655360}

{*********************************************************}
{*                    VERSET.PAS 1.00                    *}
{*        Copyright (c) TurboPower Software 1992.        *}
{*                 All rights reserved.                  *}
{*********************************************************}

program VerSet;
  {-Change dwFileVersionMS in specified files}

uses
  Dos;

const
  Digits : array[0..$F] of Char = '0123456789ABCDEF';
type
  Long = record
    LowWord, HighWord : Word;
  end;
var
  FName : PathStr;
  NewVer : LongInt;
  Code : Word;
  Ok : Boolean;

  function HexW(W : Word) : string;
    {-Return hex string for word}
  begin
    HexW[0] := #4;
    HexW[1] := Digits[hi(W) shr 4];
    HexW[2] := Digits[hi(W) and $F];
    HexW[3] := Digits[lo(W) shr 4];
    HexW[4] := Digits[lo(W) and $F];
  end;

  function HexL(L : LongInt) : string;
    {-Return hex string for LongInt}
  begin
    with Long(L) do
      HexL := HexW(HighWord)+HexW(LowWord);
  end;

  function StUpcase(S : String) : String;
  var
    I : Word;
  begin
    for I := 1 to Length(S) do
      S[I] := Upcase(S[I]);
    StUpcase := S;
  end;

  procedure WriteHelp;
    {-Write help and halt}
  begin
    WriteLn;
    WriteLn('Usage: VERSET WinFile VersionNumber');
    WriteLn('  WinFile            name of the DLL or EXE to update (not a mask)');
    WriteLn('  VersionNumber      Major,minor and incremental version number');
    WriteLn('                     as $MMmmiiii where:');
    WriteLn('                       MM is the major version');
    WriteLn('                       mm is the minor version');
    WriteLn('                       iiii is the increment version');
    WriteLn('                       e.g., version 1.03, increment 0 would be $01030000');
    Halt(1);
  end;

  procedure UpdateFileVersionMS(FName : PathStr; NewVer : LongInt);
   {-Search for versioninfo resource in FName and return FileVersionMS}
  type
    {Old header snippet}
    OldHeader = record
      Junk1         : array[1..$18] of Char;
      NewHeaderFlag : Byte;
      Junk2         : array[1..$23] of Char;
      NewHeaderOfs  : Word;
    end;

    {New header snippet}
    NewHeader = record
      Junk : array[1..36] of Byte;
      ResTableOfs   : Word;
    end;

    {Resource table entry - used for skipping entries}
    ResourceNameInfo = record
      rnOffset : Word;
      rnLength : Byte;
      rnFlags  : Word;
      rnJunk1  : Byte;
      rnID     : Word;
      rnJunk2  : array[1..4] of Byte;
    end;

    {Fixed file info format of VERINFO resource}
    Tvs_FixedFileInfo = record
      dwStrucVersion     : Longint;
      dwFileVersionMS    : Longint;
      dwFileVersionLS    : Longint;
      dwProductVersionMS : Longint;
      dwProductVersionLS : Longint;
      dwFileFlagsMask    : Longint;
      dwFileFlags        : Longint;
      dwFileOS           : Longint;
      dwFileType         : Longint;
      dwFileSubtype      : Longint;
      dwFileDateMS       : Longint;
      dwFileDateLS       : Longint;
    end;

  const
    VerInfoRes = $8010;

  var
    F : File;
    OH : OldHeader;
    NH : NewHeader;
    RN : ResourceNameInfo;
    ResType : Word;
    Count : Word;
    Root : Tvs_FixedFileInfo;
    VerOfs : Word;
    Finished : Boolean;
    Align : Word;
    FP : LongInt;
    Result : Integer;

    function ReadNextType : Boolean;
      {-Read the next resource type record}
    begin
      {Read resource type and count}
      BlockRead(F, ResType, 2);
      BlockRead(F, Count, SizeOf(Count));
      ReadNextType := Lo(ResType) <> 0;
    end;

    procedure SkipNextType;
      {-Skip all nameinfo entries for this resource type}
    var
      I : Word;
      Junk : array[1..5] of Word;
    begin
      BlockRead(F, Junk, 4);
      for I := 1 to Count do
        BlockRead(F, RN, SizeOf(RN));
    end;

    function Power(Exp : Byte) : LongInt;
    var
      L : LongInt;
      I : Word;
    begin
      L := 2;
      for I := 1 to Exp-1 do
        L := L * 2;
      Power := L;
    end;

    procedure UpdateVerResource;
      {-Read the VERINFO resourse and return FileVersionMS}
    var
      Junk : array[1..10] of Byte;
      Name : String[15];
      B : Byte;
      Adjust : Longint;
    begin
      BlockRead(F, Junk, 4);
      BlockRead(F, VerOfs, SizeOf(VerOfs));
      Adjust := Power(Align);
      Seek(F, LongInt(VerOfs)*Adjust);

      {Read cbBlock, cbValue}
      BlockRead(F, Junk, 4);

      {Read in the name, must be VS_VERSION_INFO}
      BlockRead(F, Name[1], 15);
      Name[0] := #15;
      if Name = 'VS_VERSION_INFO' then begin
        repeat
          BlockRead(F, B, 1);
        until B <> 0;
        BlockRead(F, Junk, 3);

        {Note file position}
        FP := FilePos(F);
        BlockRead(F, Root, SizeOf(Root));
        Root.dwFileVersionMS := NewVer;
        Seek(F, FP);
        BlockWrite(F, Root, SizeOf(Root));
        if IoResult = 0 then begin
          WriteLn(FName, ' version updated to ', HexL(NewVer));
          Ok := True;
          Exit;
        end;
      end;
    end;

  begin
    {Assume failure}
    Ok := False;

    {Open file}
    Assign(F, FName);
    Reset(F, 1);
    if IoResult <> 0 then
      Exit;

    {Read in old-style header, done if no new style header}
    BlockRead(F, OH, SizeOf(OH));
    if OH.NewHeaderFlag < $40 then
      Exit;

    {Read in new header, seek to start of Resource Table}
    Seek(F, OH.NewHeaderOfs);
    BlockRead(F, NH, SizeOf(NH));
    Seek(F, OH.NewHeaderOfs+NH.ResTableOfs);

    {Read align shift word}
    BlockRead(F, Align, 2);

    {Scan for VERINFO resource}
    while ReadNextType do begin

      {Exit on errors}
      if IoResult <> 0 then begin
        Close(F);
        if IoResult <> 0 then ;
        Exit;
      end;

      {Handle this resource type}
      if ResType <> VerInfoRes then
        SkipNextType
      else
        UpdateVerResource;
    end;

    {Close up and exit}
    Close(F);
    if IoResult <> 0 then ;
  end;

begin
  {Must be two parameters}
  if ParamCount <> 2 then
    WriteHelp;

  {First parameter is filename}
  FName := StUpcase(ParamStr(1));

  {Second parameter is new version}
  Val(ParamStr(2), NewVer, Code);
  if Code <> 0 then
    WriteHelp;

  UpdateFileVersionMS(FName, NewVer);
  if not Ok then
    WriteLn(FName, ' not updated due to I/O error or no VERINFO block');
end.
