{$S+,R+,V-,I-,B-,F-,W-,A-,G+,X+,N-}

{*********************************************************}
{*                   INSTALL.PAS 1.00                    *}
{*        Copyright (c) TurboPower Software 1992.        *}
{*                 All rights reserved.                  *}
{*********************************************************}

program Install;
  {-Install loader stub}

uses
  Strings,
  WinDos,
  WinTypes,
  WinProcs,
  WArchiv,
  WLzh;

const
  {Possible customizations}
  InstallTitle       = 'DEW Install';
  InstallFileName    = 'INSTALL.DAT';
  InstallProgramName = 'DEWINST.EXE';
  InstallDLLName     = 'DEWSC.DLL';
  InstallBWCCName    = 'BWCC.DLL';
  RequiredSpace      = 420000;
  TempDir : String   = 'X:\TPSINST';

var
  Drive : Byte;
  Free : LongInt;
  LzhName : String;
  InstallName : array[0..255] of Char;
  InstallResult : Word;
  OrigPath : array[0..80] of Char;                                     {!!.01}
  Media : array[0..2] of Char;
  {BMedia : Byte;}                                                     {!!.01}
  Code : Word;

function WinExecAndWait(Path : Pchar) : word;
var
  InstanceID : THandle;
  Msg : TMSg;
begin
  InstanceID := WinExec(Path, sw_Normal);
  if InstanceID < 32 then
     WinExecAndWait := InstanceID
  else
    repeat
      while PeekMessage(Msg,0,0,0,pm_Remove) do begin
        if Msg.Message = wm_Quit then
          Halt(Msg.wParam);
        TranslateMessage(Msg);
        DispatchMessage(Msg);
      end;
    until GetModuleUsage(InstanceID) = 0;
end;

procedure DoInstall(Drive : Byte);
  {-Make a temp directory, extract files, exec install}
var
  FML : FileMaskList;
  S : String;
  I : Byte;
  Last : Word;
  Window : HWnd;
  DC: HDC;
  Font: HFont;
  P: PChar;
  APos: Integer;
  F : File;

const
  AppName = 'LOADER';
  WindowClass: TWndClass = (
    style: 0;
    lpfnWndProc: @DefWindowProc;
    cbClsExtra: 0;
    cbWndExtra: 0;
    hInstance: 0;
    hIcon: 0;
    hCursor: 0;
    hbrBackground: 0;
    lpszMenuName: AppName;
    lpszClassName: AppName);

begin
  {Note the original drive}
  S := ParamStr(0);
  StrPCopy(OrigPath, S);                                              {!!.01}
  (*                                                                  {!!.01}
  OrigDrive[0] := S[1];
  OrigDrive[1] := #0;
  *)                                                                  {!!.01}

  (*                                                                  {!!.01}
  {Get the media type, if specified}
  if ParamCount > 0 then begin
    S := ParamStr(1);
    Val(S, BMedia, Code);
    if Code <> 0 then
      BMedia := 0;
  end else
    BMedia := 0;
  *)

  {Create a temporary directory}
  TempDir[1] := Char(Drive+Ord('A')-1);
  MkDir(TempDir);
  InstallResult := IoResult;
  if (InstallResult <> 0) and (InstallResult <> 5) then
    Exit;
  ChDir(TempDir);
  InstallResult := IoResult;
  if InstallResult <> 0 then
    Exit;

  {Create an FML of our standard files}
  InitFileMaskList(FML);

  {Add the standard files}
  if not (AppendFileMask(InstallDLLName, FML) and
          AppendFileMask(InstallProgramName, FML) and
          AppendFileMask(InstallBWCCName, FML) and
          AppendFileMask(InstallFileName, FML)) then begin
    InstallResult := 8;
    Exit;
  end;

  {Make a fully qualified LZH name}
  LzhName := ParamStr(0);
  I := Length(LzhName);
  Last := 0;
  while (I > 0) and (Last = 0) do begin
    if LzhName[I] = '\' then
      Last := I;
    Dec(I);
  end;
  LzhName[0] := Char(Last);
  LzhName := LzhName + 'INSTALL.LZH';

  {Register our status window class}
  if HPrevInst = 0 then begin
    WindowClass.hInstance := HInstance;
    WindowClass.hIcon := LoadIcon(0, idi_Application);
    WindowClass.hCursor := LoadCursor(0, idc_Arrow);
    WindowClass.hbrBackground := GetStockObject(white_Brush);
    RegisterClass(WindowClass);
  end;

  {Make a simple status window}
  Window := CreateWindow('LOADER',               {application name}
                         InstallTitle,           {caption}
                         ws_Overlapped,          {window style}
                         100,                    {X}
                         100,                    {Y}
                         250,                    {width}
                         75,                     {height}
                         0,                      {parent}
                         0,                      {menu}
                         HInstance,              {instance}
                         nil);                   {parameter}

  {Display the window and a brief message}
  ShowWindow(Window, sw_Normal);
  DC := GetDC(Window);
  P := 'Copying setup files ...';
  TextOut(DC, 55, 17, P, StrLen(P));
  ReleaseDC(Window, DC);

  {Extract the files}
  InitLzhFile(LzhName);
  ExtractFileMaskList(FML);
  DoneLzhFile;

  {Get rid of the status window}
  ShowWindow(Window, sw_Hide);
  DestroyWindow(Window);

  {Make a fully qualified INST.EXE name}
  StrPCopy(InstallName, TempDir);
  StrCat(InstallName, '\' + InstallProgramName);

  {Add parameters to command line}
  StrCat(InstallName, ' ');
  StrCat(InstallName, OrigPath);                                       {!!.01}
  (*                                                                   {!!.01}
  if BMedia <> 0 then begin
    Str(BMedia, S);
    StrPCopy(Media, S);
  end;
  *)                                                                   {!!.01}

  {Exec and wait here}
  WinExecAndWait(InstallName);

  {Delete install stuff and remove tempdir}
  if IoResult <> 0 then ;
  Assign(F, InstallFileName);
  Erase(F);
  if IoResult <> 0 then ;
  Assign(F, InstallProgramName);
  Erase(F);
  if IoResult <> 0 then ;
  Assign(F, InstallDLLName);
  Erase(F);
  if IoResult <> 0 then ;
  Assign(F, InstallBWCCName);
  Erase(F);
  if IoResult <> 0 then ;
  ChDir('\');
  RmDir(TempDir);
end;

begin
  {Search drives for enough space}
  for Drive := 3 to 26 do begin
    Free := DiskFree(Drive);
    if Free > RequiredSpace then begin
      DoInstall(Drive);
      Exit;
    end;
  end;
end.

