program GetDate;
uses PXEngine, WinCrt;

const TableName = 'Table';

var   PxErr: Integer;
      TblHandle: TableHandle;
      RecHandle: RecordHandle;
      FldHandle: FieldHandle;
      Month, Day, Year: Integer;
      Date: Longint;

procedure PX(Code : integer);
begin
  writeln(PXErrMsg(Code));
end;

begin
  PX(PXWinInit('MyApp', pxShared));
  PX(PXTblOpen(TableName, TblHandle, 0, False));
  PX(PXRecBufOpen(TblHandle, RecHandle));
  PX(PXFldHandle(TblHandle, 'Date Field', FldHandle));
  PX(PXRecGet(TblHandle, RecHandle));

  (* Get a date field out of a record buffer *)
  PxErr := PXGetDate(RecHandle, FldHandle, Date);
  if PxErr <> PxSuccess then
    Writeln(PxErrMsg(PxErr))
  else begin
       PX(PXDateDecode(Date, Month, Day, Year));
       Writeln('Date: ', Month, '/', Day, '/', Year);
       end;

  PX(PXRecBufClose(RecHandle));
  PX(PXTblClose(TblHandle));
  PX(PXExit);
end.
