unit TPW2VB;

{$D Opaque Software  - Tpw2VB  ver 3.0a }

interface

uses winprocs, wintypes;

{//---------------------------------------------------------------------------
//
//  VBAPI.H -
//
//	Include file for the Visual Basic Custom Control and DLL
//	application programming interface.
//
//---------------------------------------------------------------------------}

const
	VB100_VERSION	=	$0100;
	VB200_VERSION	=	$0200;
	VB300_VERSION	=	$0300;
	VB_VERSION		=	VB300_VERSION;


{//---------------------------------------------------------------------------
// General types and modifiers
//---------------------------------------------------------------------------}


type
	BOOL=		WordBool;
	Enum=		Byte;
	NPnt=		Word;		{TPW doesn't support a near(16 bit) pointer.
							 You must TypeCast any pointers VB expects as
							 near pointers to NPnt().
                             example:  NPnt(LongPointer);			}
    LPnt=		Pointer;
	LPStr =		PChar;
	Hsz= 		LPHandle;
	PHSZ =		^HSZ;
	HLStr= 		LPHandle;
	HCtl= 		LPHandle;
    HAD=		LPHandle;
	HFormFile= 	PHandle;
	ERR		=	Word;
	HPic=		Word;
	Float=		Single;

{//---------------------------------------------------------------------------}
{// language Variant structures}
{//---------------------------------------------------------------------------}

{// variant type constants. these are the return value of GetVariantType.}
{// these are also defined in Constant.Txt for return value of VarType()}
const
	VT_EMPTY    =0 ;  {	// Empty}
	VT_NULL     =1 ;  {	// Null}
	VT_I2	    =2 ;  {	// Integer}
	VT_I4	    =3 ;  {	// Long}
	VT_R4	    =4 ;  {	// Single}
	VT_R8	    =5 ;  {	// Double}
	VT_CURRENCY =6 ;  {	// Currency}
	VT_DATE     =7 ;  {	// Date}
	VT_STRING   =8 ;  {	// String}


type
	TCurrency = record
		lo, hi: LongInt;
	end;

type
	PValue 	= ^TValue;
	TValue	= record
		case Byte of
			VT_I2: 	(i2: Integer);
			VT_I4:	(i4: LongInt);
			VT_R4:	(r4: Single);
			VT_R8:	(r8: Double);
			VT_CURRENCY:	(cy: TCurrency);
			VT_STRING:		(HStr: HLStr);
	end;


{// The size of Variant is needed when a Variant is passed by value}
{// or in a structure (user-defined type).}

type
	PVariant   = ^TVariant;
	TVariant = record
		v: array[0..15] of char;
    end;

{//---------------------------------------------------------------------------
// COLOR - a Windows RGB DWORD value.
//---------------------------------------------------------------------------}
type
	Color=	TCOLORREF;
	PColor = ^Color;

const
	Color_DefBitOn	=$80000000;	{ bit set -> Win SysColor, not RGB}

function RGBColor(Color: LongInt):Longint;

{//---------------------------------------------------------------------------
// Property data structure
//---------------------------------------------------------------------------}
type
   TIndex = record
	   datatype: Word;    { Type of nth index (Currently always DT_Integer)}
	   data: LongInt	   { Value of nth index}
   end;

type
	TDataStruct = record
		data: LongInt;	    { Data for Get/Set }
    	cindex: Word;	    	{Number of indecies  }
    	index : array[0..0]of TIndex
	end;

	PDataStruct = ^TDataStruct;	


{//---------------------------------------------------------------------------
// VISUAL BASIC variable types
//---------------------------------------------------------------------------}
const
	ET_I2		=1 ;	{16 bit signed integer scalar or array variable }
	ET_I4		=2 ;	{32 bit signed integer scalar or array variable }
	ET_R4		=3 ;
	ET_R8		=4 ;	{64 bit real scalar or array variable }
	ET_CY		=5 ;	{64 bit currency scalar or array variable }
	ET_HLSTR	=6 ;  	{// string scalar or array variable}
	ET_SD		=6 ;	{older string scalar or array variable }
	ET_FS		=7 ;	{fixed-length string variable }


{//---------------------------------------------------------------------------
// Control Property definitions and structures.
//---------------------------------------------------------------------------}
const
	PF_datatype	    =	$000000FF;
	PF_fPropArray	    =	$00000100;
	PF_fSetData	    =	$00000200;
	PF_fSetMsg	    =	$00000400;
	PF_fNoShow	    =	$00000800;
	PF_fNoRuntimeW	    =	$00001000;
	PF_fGetData	    =	$00002000;
	PF_fGetMsg	    =	$00004000;
	PF_fSetCheck	    =	$00008000;
	PF_fSaveData	    =	$00010000;
	PF_fSaveMsg	    =	$00020000;
	PF_fLoadDataOnly    = $20010000;
	PF_fLoadMsgOnly     = $20020000;
	PF_fGetHszMsg	    =	$00040000;
	PF_fUpdateOnEdit    =	$00080000;
	PF_fEditable	    =	$00100000;
	PF_fPreHwnd	    =	$00200000;
	PF_fDefVal	    =	$00400000;
	PF_fNoInitDef	    =	$00800000;
	PF_fNoRuntimeR	    = $02000000;
	PF_fNoMultiSelect   = $04000000;

type
	PPROPINFO = NPnt;
	TPROPINFO = record
		npszName: NPnt;
		fl:			LongInt;			{PF_ flags}
		offsetData: Byte;		{ Offset into static structure}
		infoData:	Byte;		{ 0 or _INFO value for bitfield        }
		dataDefault: 	LongInt;		{ 0 or _INFO value for bitfield}
		npszEnumList: 	NPnt;		{ For type == DT_ENUM, this is
						// a near ptr to a string containing
						// all the values to be displayed
						// in the popup enumeration listbox.
						// Each value is an sz, with an
						// empty sz indicated the end of list. }
		enumMax:	Byte;		{Maximum legal value for enum.}
	end;

	PPROPLIST = ^NPnt;
	NPPROPLIST = NPnt;
{// Values for PROPINFO PF_datatype}
const
	DT_HSZ	      =$01;
	DT_SHORT		=$02;
	DT_Integer      =DT_SHORT;
	DT_LONG       =$03;
	DT_BOOL       =$04;
	DT_COLOR      =$05;
	DT_ENUM       =$06;
	DT_REAL       =$07;
	DT_XPOS       =$08	;
	DT_XSIZE      =$09	;
	DT_YPOS       =$0A	;
	DT_YSIZE      =$0B	;
	DT_PICTURE    =$0C;
	DT_HLSTR      = $0D;
	DT_OBJECT     =	$20;
{//---------------------------------------------------------------------------
// Control event definitions and structures.
//---------------------------------------------------------------------------}

	EF_fNoUnload	=$00000001;

type
	TEVENTINFO=record
		npszName: NPnt;
    	cParms:	Word;
    	cwParms: Word;	{ # words of parameters  }
		npParmTypes:	NPnt;	{ list of parameter types}
		npszParmProf:	NPnt;	{ event parameter profile string}
		fl:				LongInt;		{ EF_ flags}
    end;

	PEVENTINFO = NPnt;
	PPEVENTINFO = ^NPnt;
	NPEVENTINFO = NPnt;
	LPEVENTINFO = ^TEVENTINFO;            {far}
	LPEVENTLIST = ^NPEVENTINFO;           {far}
	NPEVENTLIST = NPnt;

{//---------------------------------------------------------------------------
// Standard control event list
//---------------------------------------------------------------------------}
const
	IEVENT_STD_CLICK	=$0000;
	IEVENT_STD_DBLCLICK	=$0001;
	IEVENT_STD_DRAGDROP	=$0002;
	IEVENT_STD_DRAGOVER	=$0003;
	IEVENT_STD_GOTFOCUS	=$0004;
	IEVENT_STD_KEYDOWN	=$0005;
	IEVENT_STD_KEYPRESS	=$0006;
	IEVENT_STD_KEYUP	=$0007;
	IEVENT_STD_LOSTFOCUS	=$0008;
	IEVENT_STD_MOUSEDOWN	=$0009;
	IEVENT_STD_MOUSEMOVE	=$000A;
	IEVENT_STD_MOUSEUP	=$000B;
	IEVENT_STD_LINKERROR    =$000C;
	IEVENT_STD_LINKOPEN     =$000D;
	IEVENT_STD_LINKCLOSE    =$000E;
	IEVENT_STD_LINKNOTIFY   =$000F;
	IEVENT_STD_LINKCHANGE   	=	$0010;
	IEVENT_STD_NONE 	=$0FFF;
	IEVENT_STD_LAST 	=$0FFF;
const
	PEVENTINFO_STD_CLICK =	   PEVENTINFO (not IEVENT_STD_CLICK);
	PEVENTINFO_STD_DBLCLICK     =PEVENTINFO (not IEVENT_STD_DBLCLICK);
	PEVENTINFO_STD_DRAGDROP     =PEVENTINFO (not IEVENT_STD_DRAGDROP);
	PEVENTINFO_STD_DRAGOVER     =PEVENTINFO (not IEVENT_STD_DRAGOVER);
	PEVENTINFO_STD_GOTFOCUS     =PEVENTINFO (not IEVENT_STD_GOTFOCUS);
	PEVENTINFO_STD_KEYDOWN	    =PEVENTINFO (not IEVENT_STD_KEYDOWN);
	PEVENTINFO_STD_KEYPRESS     =PEVENTINFO (not IEVENT_STD_KEYPRESS);
	PEVENTINFO_STD_KEYUP	    =PEVENTINFO (not IEVENT_STD_KEYUP);
	PEVENTINFO_STD_LOSTFOCUS    =PEVENTINFO (not IEVENT_STD_LOSTFOCUS);
	PEVENTINFO_STD_MOUSEDOWN    =PEVENTINFO (not IEVENT_STD_MOUSEDOWN);
	PEVENTINFO_STD_MOUSEMOVE    =PEVENTINFO (not IEVENT_STD_MOUSEMOVE);
	PEVENTINFO_STD_MOUSEUP	    =PEVENTINFO (not IEVENT_STD_MOUSEUP);
	PEVENTINFO_STD_LINKERROR    =PEVENTINFO (not IEVENT_STD_LINKERROR);
	PEVENTINFO_STD_LINKOPEN	    =PEVENTINFO (not IEVENT_STD_LINKOPEN);
	PEVENTINFO_STD_LINKCLOSE    =PEVENTINFO (not IEVENT_STD_LINKCLOSE);
	PEVENTINFO_STD_LINKNOTIFY   =PEVENTINFO (not IEVENT_STD_LINKNOTIFY);
	PEVENTINFO_STD_LINKCHANGE   =PEVENTINFO (not IEVENT_STD_LINKCHANGE);
	PEVENTINFO_STD_NONE		    =PEVENTINFO (not IEVENT_STD_NONE);
	PEVENTINFO_STD_LAST		    =PEVENTINFO (not IEVENT_STD_LAST);

{//---------------------------------------------------------------------------
// Standard control properties
//---------------------------------------------------------------------------}
const
	IPROP_STD_NAME		    =$0000;
	IPROP_STD_CTLNAME	    =IPROP_STD_NAME;
	IPROP_STD_INDEX 	    = $0001;
	IPROP_STD_HWND		    =$0002;
	IPROP_STD_BACKCOLOR	    = $0003;
	IPROP_STD_FORECOLOR	    = $0004;
	IPROP_STD_LEFT		    = $0005;
	IPROP_STD_TOP		    = $0006;
	IPROP_STD_WIDTH 	    = $0007;
	IPROP_STD_HEIGHT	    = $0008;
	IPROP_STD_ENABLED	    = $0009;
	IPROP_STD_VISIBLE	    = $000A;
	IPROP_STD_MOUSEPOINTER	    = $000B;
	IPROP_STD_CAPTION	    = $000C; 
	IPROP_STD_FONTNAME	    = $000D;
	IPROP_STD_FONTBOLD	    = $000E;
	IPROP_STD_FONTITALIC	    = $000F;
	IPROP_STD_FONTSTRIKE	    = $0010;
	IPROP_STD_FONTUNDER	    = $0011;
	IPROP_STD_FONTSIZE	    = $0012;
	IPROP_STD_TABINDEX	    = $0013;
	IPROP_STD_PARENT	    = $0014;
	IPROP_STD_DRAGMODE	    = $0015;
	IPROP_STD_DRAGICON	    = $0016;
	IPROP_STD_BORDERSTYLEOFF    = $0017;
	IPROP_STD_TABSTOP	    = $0018;
	IPROP_STD_TAG		    = $0019;
	IPROP_STD_TEXT		    = $001B;
	IPROP_STD_BORDERSTYLEON     = $001C;
	IPROP_STD_CLIPCONTROLS	    =$001D;
	IPROP_STD_NONE		    =$001E;
	IPROP_STD_HELPCONTEXTID     =$001F;
	IPROP_STD_LINKMODE	    =$0020;
	IPROP_STD_LINKITEM	    =$0021;
	IPROP_STD_LINKTOPIC	    =$0022;
	IPROP_STD_LINKTIMEOUT	    =$0023;
	IPROP_STD_LEFTNORUN	    =$0024;
	IPROP_STD_TOPNORUN	    =$0025;
	IPROP_STD_ALIGN 	    =$0026;
	IPROP_STD_IMEMODE	    =$0027;	
	IPROP_STD_DATASOURCE	    	=	$0028;
	IPROP_STD_DATAFIELD	    	=	$0029;
	IPROP_STD_DATACHANGED	    	=	$002A;
	IPROP_STD_LAST		    =$0FFF;

	PPROPINFO_STD_NAME	    =PPROPINFO (not IPROP_STD_NAME);
	PPROPINFO_STD_CTLNAME	    =PPROPINFO (not IPROP_STD_NAME);
	PPROPINFO_STD_INDEX	    =PPROPINFO (not IPROP_STD_INDEX);
	PPROPINFO_STD_HWND	    =PPROPINFO (not IPROP_STD_HWND);
	PPROPINFO_STD_BACKCOLOR     =PPROPINFO (not IPROP_STD_BACKCOLOR);
	PPROPINFO_STD_FORECOLOR     =PPROPINFO (not IPROP_STD_FORECOLOR);
	PPROPINFO_STD_LEFT	    =PPROPINFO (not IPROP_STD_LEFT);
	PPROPINFO_STD_TOP	    =PPROPINFO (not IPROP_STD_TOP);
	PPROPINFO_STD_WIDTH	    =PPROPINFO (not IPROP_STD_WIDTH);
	PPROPINFO_STD_HEIGHT	    =PPROPINFO (not IPROP_STD_HEIGHT);
	PPROPINFO_STD_ENABLED	    =PPROPINFO (not IPROP_STD_ENABLED);
	PPROPINFO_STD_VISIBLE	    =PPROPINFO (not IPROP_STD_VISIBLE);
	PPROPINFO_STD_MOUSEPOINTER  =PPROPINFO (not IPROP_STD_MOUSEPOINTER);
	PPROPINFO_STD_CAPTION	    =PPROPINFO (not IPROP_STD_CAPTION);
	PPROPINFO_STD_FONTNAME	    =PPROPINFO (not IPROP_STD_FONTNAME);
	PPROPINFO_STD_FONTBOLD	    =PPROPINFO (not IPROP_STD_FONTBOLD);
	PPROPINFO_STD_FONTITALIC    =PPROPINFO (not IPROP_STD_FONTITALIC);
	PPROPINFO_STD_FONTSTRIKE    =PPROPINFO (not IPROP_STD_FONTSTRIKE);
	PPROPINFO_STD_FONTUNDER     =PPROPINFO (not IPROP_STD_FONTUNDER);
	PPROPINFO_STD_FONTSIZE	    =PPROPINFO (not IPROP_STD_FONTSIZE);
	PPROPINFO_STD_TABINDEX	    =PPROPINFO (not IPROP_STD_TABINDEX);
	PPROPINFO_STD_PARENT	    =PPROPINFO (not IPROP_STD_PARENT);
	PPROPINFO_STD_DRAGMODE	    =PPROPINFO (not IPROP_STD_DRAGMODE);
	PPROPINFO_STD_DRAGICON	    =PPROPINFO (not IPROP_STD_DRAGICON);
	PPROPINFO_STD_BORDERSTYLEOFF =PPROPINFO (not IPROP_STD_BORDERSTYLEOFF);
	PPROPINFO_STD_TABSTOP	    =PPROPINFO (not IPROP_STD_TABSTOP);
	PPROPINFO_STD_TAG	    =PPROPINFO (not IPROP_STD_TAG);
	PPROPINFO_STD_TEXT	    =PPROPINFO (not IPROP_STD_TEXT);
	PPROPINFO_STD_BORDERSTYLEON =PPROPINFO (not IPROP_STD_BORDERSTYLEON);
	PPROPINFO_STD_CLIPCONTROLS  =PPROPINFO (not IPROP_STD_CLIPCONTROLS);
	PPROPINFO_STD_NONE	    =PPROPINFO (not IPROP_STD_NONE);
	PPROPINFO_STD_HELPCONTEXTID =PPROPINFO (not IPROP_STD_HELPCONTEXTID);
	PPROPINFO_STD_LINKMODE	    =PPROPINFO (not IPROP_STD_LINKMODE);
	PPROPINFO_STD_LINKITEM	    =PPROPINFO (not IPROP_STD_LINKITEM);
	PPROPINFO_STD_LINKTOPIC     =PPROPINFO (not IPROP_STD_LINKTOPIC);
	PPROPINFO_STD_LINKTIMEOUT   =PPROPINFO (not IPROP_STD_LINKTIMEOUT);
	PPROPINFO_STD_LEFTNORUN     =PPROPINFO (not IPROP_STD_LEFTNORUN);
	PPROPINFO_STD_TOPNORUN	    =PPROPINFO (not IPROP_STD_TOPNORUN);
	PPROPINFO_STD_ALIGN	    =PPROPINFO (not IPROP_STD_ALIGN);
	PPROPINFO_STD_IMEMODE	    =PPROPINFO (not IPROP_STD_IMEMODE);
	PPROPINFO_STD_DATASOURCE		=PPROPINFO (not IPROP_STD_DATASOURCE);
	PPROPINFO_STD_DATAFIELD	    =PPROPINFO (not IPROP_STD_DATAFIELD);
	PPROPINFO_STD_DATACHANGED	    =PPROPINFO (not IPROP_STD_DATACHANGED);
	PPROPINFO_STD_LAST	    =PPROPINFO (not IPROP_STD_LAST);

{//---------------------------------------------------------------------------
// Structure for VBM_DRAGOVER and VBM_DRAGDROP events
//---------------------------------------------------------------------------}

type
	TDRAGINFO=record
		Control: 	HCtl;
		pt:			TPOINT;
		state: 		Word;	{ Enter, Over, Exit; only used for VBM_DRAGOVER}
    end;

	PDRAGINFO = ^TDRAGINFO;
	NPDRAGINFO = NPnt;
	LPDRAGINFO = ^TDRAGINFO;

const
	DRAG_STATE_ENTER       =$00;
	DRAG_STATE_EXIT        =$01;
	DRAG_STATE_OVER        =$02;


{//---------------------------------------------------------------------------
// Control MODEL structure
//---------------------------------------------------------------------------}

type
 	LPMODEL = ^TMODEL;
	TModel=Record
		usVersion:		Word;		{VB version used by control}
		fl:				LongInt;    { Bitfield structure}
		ctlproc:		TFARPROC;	{the control proc.}
		fsClassStyle:	Word;	 	{ window class style}
		flWndStyle:		LongInt;	{default window style}
		cbCtlExtra:		Word;		{ # bytes alloc'd for HCtl structure}
		idBmpPalette:	Word;		{ BITMAP id for tool palette}
		DefCtlName: 	NPnt;		{PSTR; 	{ default control name prefix}
		ClassName:		NPnt;		{PSTR;		{ Visual Basic class name}
		ParentClassName:	NPnt;	{PSTR;	{ Parent window class if subclassed}
		proplist:		NPPROPLIST	;		{ Property list}
		eventlist:		NPEVENTLIST ;		{ Event list}
		nDefProp: 		Byte;		{ index of default property}
		nDefEvent:		Byte;		{ index of default event}
		nValueProp:		Byte;		{// Index of control value property}
        usCtlVersion:	Word;       {   // Identifies the current version of
                                        // the custom control. The values
                                        // 1 and 2 are reserved for custom
                                        // controls created with VB 1.0 and
                                        // VB 2.0.}
	end;



const
	MODEL_fArrows	    =$00000001;
	MODEL_fFocusOk	    =$00000002;
	MODEL_fMnemonic     =$00000004;
	MODEL_fChildrenOk   =$00000008;
	MODEL_fInitMsg	    =$00000010;
	MODEL_fLoadMsg	    =$00000020;
	MODEL_fDesInteract  =$00000040;
	MODEL_fInvisAtRun   =$00000080;
	MODEL_fGraphical    =$00000100;

{//---------------------------------------------------------------------------}
{// MODELINFO structure}
{//---------------------------------------------------------------------------}
type
    LPModelInfo = ^TModelInfo;
	TModelInfo	= record
		usVersion:	Word;
		lplpmodel:	^LPMODEL;
    end;


{//---------------------------------------------------------------------------
// Picture structure
//---------------------------------------------------------------------------}
const
	PICTYPE_NONE =		0;
	PICTYPE_BITMAP		=1;
	PICTYPE_METAFILE	=2;
	PICTYPE_ICON		=3;

	HPic_INVALID	   =	$FFFF;
	HPic_NULL		=0;

type
	TPicData = record
		case  Byte of
			PICType_BitMap: (BitMap: HBitMap; hpal: HPalette);
			PICType_MetaFile: 	(Meta: THandle;
								xExt, yExt: Integer);
			PICType_Icon	:	(Icon: HIcon);
    end;


	PPIC = ^TPIC;
	TPIC = record
		picType: 	Byte;
        picData:	TPicData;
		picReserved: array[0..3]of Byte;
	end;

{//---------------------------------------------------------------------------
// Mode constants
//---------------------------------------------------------------------------}
const
	CDLL = 'TPW2VB';
	MODE_DESIGN	=1;
	MODE_RUN	=2;
	MODE_BREAK	=3;


{//---------------------------------------------------------------------------}
{// Control flags for use with VBSetControlFlags}
{//---------------------------------------------------------------------------}
const
	CTLFLG_HASPALETTE	    =$00000001;
	CTLFLG_USESPALETTE	    =$00000002;
	CTLFLG_GRAPHICALOPAQUE	    =$00000004;
	CTLFLG_GRAPHICALTRANSLUCENT =$00000008;
	CTLFLG_DATACHANGED	      =$00000010;
	CTLFLG_BOUNDDATASET	      =$00000020;

{// Data xfer structure for VBM_LINKGETDATA or VBM_LINKSETDATA}
type
    LPLinkData = ^TVBLinkData;
	TVBLinkData = record
		wReserved:	Word;
		cb:			LongInt;
		HData:		THandle;
		dwReserved:	LongInt;
	end;

{//---------------------------------------------------------------------------
// Link modes
//---------------------------------------------------------------------------}
const
{// link modes}

	LINKMODENONE			=0;
	LINKMODEAUTO			=1;
	LINKMODEMANUAL			=2;
	LINKMODENOTIFY                  =3;

	LINKMODESERVERPOKE		=1;
	LINKMODESERVERNOPOKE		=2;

var
	VBDDEDATA 	:	TVBLINKDATA;
	LPDDEDATA 	:	LPLINKDATA;

{//---------------------------------------------------------------------------
// Misc DDE defines
//---------------------------------------------------------------------------}
const
	MAX_EXEC                        =256;
	MAXLINKITEMNAME                 =256;

	ACCEPTSDATAFORMAT                =1;
	SUPPLIESDATAFORMAT               =2;

	LINKSRCASK                       =0;
	LINKSRCTELL                      =1;

	LINK_DATA_OK			 =0;
	LINK_DATA_OOM			 =1;
	LINK_DATA_FORMATBAD		 =2;
	LINK_DATA_SETFAILED		 =3;

{	  // Attempted to Initate on a channel that had linkmode set to None.}
	errInitOnNonServerDesk   =6;

{// The Server Channel array is filled.}
	errAllServerChUsed       =7;

{// The Set quality failed possible string too long.}
	errDataSettingFailed     =8;  

	errOutOfMemoryForLink	=11;


{//---------------------------------------------------------------------------
// Bound control interface
//---------------------------------------------------------------------------}

{// values for the sAction parameter on VBM_DATA_GET messages.}
const
	DATA_FIELDVALUE      =0;
	DATA_FIELDNAME	     =1;
	DATA_FIELDTYPE	     =2;
	DATA_FIELDSIZE	     =3;
	DATA_FIELDSCOUNT     =4;
	DATA_FIELDCHUNK      =5;
	DATA_FIELDPOSITION   =6;
	DATA_FIELDATTRIBUTES =7;

	DATA_BOF	     =16;
	DATA_EOF	     =17;
	DATA_BOOKMARK	     =18;
	DATA_BOOKMARKABLE    =19;
	DATA_UPDATABLE	     =20;
	DATA_RECORDCOUNT     =21;
	DATA_LASTMODIFIED    =22;

{// sAction values during VBM_DATA_AVAILABLE messages}

	DATA_MOVEFIRST	      =64;
	DATA_MOVENEXT	      =65;
	DATA_MOVEPREV	      =66;
	DATA_MOVELAST	      =67;
	DATA_FINDFIRST	      =68;
	DATA_FINDNEXT	      =69;
	DATA_FINDPREV	      =70;
	DATA_FINDLAST	      =71;
	DATA_DELETE	      =72;
	DATA_ADDNEW	      =73;
	DATA_REFRESH	      =74;
	DATA_ROLLBACK	      =76;
	DATA_CLOSE	      =77;
	DATA_DATAFIELDCHANGED =78;
	DATA_SAVEDATA	      =79;
	DATA_READDATA	      =80;
	DATA_UPDATE	      =81;
	DATA_UNLOAD	      =82;


{// return types for VBM_DATA_GET with sAction = DATA_FIELDTYPE}

	DATA_VT_BOOL	   =1;
	DATA_VT_VAR_BYTE   =2;
	DATA_VT_INTEGER    =3;
	DATA_VT_LONG	   =4;
	DATA_VT_CURRENCY   =5;
	DATA_VT_SINGLE	   =6;
	DATA_VT_DOUBLE	   =7;
	DATA_VT_DATETIME   =8;
	DATA_VT_TEXT	   =10;
	DATA_VT_BINARY	   =11;
	DATA_VT_MEMO	   =12;

{// VBM_DATA_GET with sAction = DATA_BOOKMARK fill in ldata with one of these}

	DATA_BOOKMARKFIRST	  :LongInt	= $80000000;
	DATA_BOOKMARKPREV	  :longint	=	-1;
	DATA_BOOKMARKCURRENT  :Longint	=	0;
	DATA_BOOKMARKNEXT	  :LongINt	=	1;
	DATA_BOOKMARKLAST	  :LongInt	=$7FFFFFFF;

{//}
	DA_fNull    =	$0001;
	DA_fBOF     =	$0002;
	DA_fEOF     =	$0004;


{//---------------------------------------------------------------------------}
{// DA structure used for conversations with the data control}
{//---------------------------------------------------------------------------}
type
	LPDataAccess = ^TDataAccess;
	TDataAccess = record
		usVersion:	Word;  	{// VB version of structure filled in when
							// structure is created}
		sAction:	Integer;{ // on VBM_DATA_GET/SET specifies what to get/set
							// on VBM_DATA_AVAILABLE/REQUEST tells why }
		hctlData:	HCtl;	{// the data control providing data        }
		hctlBound:	HCtl;		  {// the bound control receiving data}
		hszDataField:	HSZ; 	  {// the name of the field to get value of }
		sDataFieldIndex: Integer; {// the field index used when FieldName is null}
		usDataType:	Word;		  {// the property datatype to convert data to  }
		hlstrBookMark: HLStr;	  {// used when getting multirow data }
		fs:				Word;	  {// Bitfield structure}
		lData:			LongInt;  {// the data           }
		ulChunkOffset: 	LongInt;  {  // the offset to start at for GetChunk}
		ulChunkNumBytes:LongInt;  {  // the number of bytes for GetChunk/SetChunk }
    end;


const
	GC_FIRSTSIBLING       =$0000;
	GC_LASTSIBLING	      =$0001;
	GC_NEXTSIBLING	      =$0002;
	GC_PREVSIBLING	      =$0003;
	GC_CHILD	      =$0005;
	GC_CONTAINER	      =$1000;
	GC_FORM 	      =$1001;
	GC_FIRSTCONTROL       =$1002;
	GC_NEXTCONTROL	      =$1003;
	GC_FIRSTSELECTED      =$1004;
	GC_NEXTSELECTED       =$1005;

	ZORDER_FRONT	=0;
	ZORDER_BACK	=1;

	AB_INVALIDINDEX     =1;	  {// hAD or index is bad}
{#define LOBOUND(x)	  ((SHORT)((x) & 0xFFFF))
#define HIBOUND(x)	  ((SHORT)((x) >> 16))}

	EVENTNOTFIRED	=	$7FFF;

{//---------------------------------------------------------------------------}
{//---------------------------------------------------------------------------}
{// Visual Basic messages}
{//---------------------------------------------------------------------------}
{//---------------------------------------------------------------------------}
	VBM__BASE	   =	WM_USER + $0C00; 

{// All properties have been loaded.  Must set MODEL_fLoadMsg to receive.}
	VBM_CREATED	   =	VBM__BASE + $00; 

{// Form load is complete or dynamic control is fully loaded.  Must set}
{// MODEL_fLoadMsg to receive.}
	VBM_LOADED	   =	VBM__BASE + $01; 

{// Pre-hwnd properties are not yet loaded (no hwnd exists for control yet).}
{// Must set MODEL_fInitMsg to receive.}
	VBM_INITIALIZE	   =	VBM__BASE + $02; 

{// Get a property value.}
{// [wp=iprop, lp=pdata], RetVal=ERR}
	VBM_GETPROPERTY    =	VBM__BASE + $03; 

{// Verify a property value.}
{// [wp=iprop, lp=data], RetVal=ERR}
	VBM_CHECKPROPERTY  =	VBM__BASE + $04; 

{// Set a property value.}
{// [wp=iprop, lp=data], RetVal=ERR}
	VBM_SETPROPERTY    =	VBM__BASE + $05; 

{// Write a property.}
{// [wp=iprop, lp=pfileref], RetVal=ERR}
	VBM_SAVEPROPERTY   =	VBM__BASE + $06; 

{// Read a property.}
{// [wp=iprop, lp=pfileref], RetVal=ERR}
	VBM_LOADPROPERTY   =	VBM__BASE + $07; 

{// Get the string representation of a property.}
{// [wp=iprop, lp=HSZ FAR *], RetVal=ERR}
	VBM_GETPROPERTYHSZ =	VBM__BASE + $08; 

{// Create popup window used to change a property.}
{// [wp=iprop, lp=listbox hwnd], RetVal=popup hwnd}
	VBM_INITPROPPOPUP  =	VBM__BASE + $09; 

{// Determine if Paste/PasteLink is allowed.}
{// [wp=PASTETYPE], RetVal=BOOL}
	VBM_QPASTEOK	   =	VBM__BASE + $0A; 

	PT_PASTE	=0;
	PT_PASTELINK	=1;

{// Paste control-specific data from the clipboard.}
{// [wp=PASTETYPE], RetVal=ERR}
	VBM_PASTE	   =	VBM__BASE + $0B; 

{// Copy control specific data to the clipboard.}
	VBM_COPY	   =	VBM__BASE + $0C; 

{// Control activated upon receipt of a unique mnemonic key.}
	VBM_MNEMONIC	   =	VBM__BASE + $0D; 

{// Posted to fire a deferred event.}
{// [wp=event]}
	VBM_FIREEVENT	   =	VBM__BASE + $0E; 

{// Another control in drag mode drug over the control.}
{// [lp=pdraginfo]}
	VBM_DRAGOVER	   =	VBM__BASE + $0F; 

{// This message is sent to a control that has just had another control}
{// in drag mode dropped on it.}
{// [lp=pdraginfo]}
	VBM_DRAGDROP	   =	VBM__BASE + $10; 

{// This message is sent when certain methods are invoked on controls}
{// [wp=METH_, lp=far *alParams], RetVal=ERR}
	VBM_METHOD	   =	VBM__BASE + $11; 

	METH_ADDITEM	=	$0001 ;{	// args are: cArgs, hszItem, [index]}
	METH_REMOVEITEM =	$0002 ;{	// args are: cArgs, index}
	METH_REFRESH	=	$0003 ;{	// no args (lp == NULL)}
	METH_MOVE	=	$0004 ;{	// args are: cArgs, left, [top, [width, [height]]]}
	METH_DRAG	=	$0005 ;{	// args are: cArgs, [cmd]}
	METH_LINKSEND   =	$0006;{  // no args (lp == NULL)}
	METH_ZORDER	=	$0007 ;{	// args are: cArgs, pos}
	METH_CLEAR	=	$000A ;{	// no args (lp == NULL)}

{// Clear capture and internal state.}
	VBM_CANCELMODE	   =	VBM__BASE + $12; 

{// Paint notification for graphical controls.}
{// [wp=hdc, lp=lprect]}
	VBM_PAINT	   =	VBM__BASE + $14; 

{// Hit test for graphical controls.}
{// [lp=lphittest], RetVal = HT_}
	VBM_HITTEST	   =	VBM__BASE + $15; 

	HT_ON		  =7;
	HT_SOLID_NEAR	  =6;
	HT_PATTERN_NEAR   =5;
	HT_HOLLOW_NEAR	  =4;
	HT_SOLID	  =3;
	HT_PATTERN	  =2;
	HT_HOLLOW	  =1;
	HT_MISS 	  =0;

type
    LPHitTest = ^THitTest;
	THitTest = record
		pt:	TPoint;
		rect:	TRect;
    end;

const
{// Paint the multi-select handles}
{// [wp=hdc, lp=rect(in hdc coords)]}
	VBM_PAINTMULTISEL  =	VBM__BASE + $16; 

{// Paint the "gray rect" or ctl outline while moving/sizing ctl.}
{// [wp=hdc, lp=rect(in hdc coords)]}
	VBM_PAINTOUTLINE   =	VBM__BASE + $17; 

{// Palette change notification.}
{// [wp=fPalBack(for SelectPalette)], RetVal = return from RealizePalette}
	VBM_PALETTECHANGED =	VBM__BASE + $1B; 

{// Get control palette.}
{// RetVal = HPALETTE.}
	VBM_GETPALETTE	   =	VBM__BASE + $1C; 

{// Enumerate available formats.}
{// [wp=SUPPLIESDATAFORMAT | ACCEPTSDATAFORMAT]}
{// [LOWORD(lp)=ennumeration(0-x)]}
	VBM_LINKENUMFORMATS=	VBM__BASE + $1E; 

{// Ask a control for it's LINK item name.  Return item name as lpsz in lp.}
{// [wp=LINKSRCASK | LINKSRCTELL]}
{// [lp=lpszItemName]}
	VBM_LINKGETITEMNAME=	VBM__BASE + $1F; 

{// For Server items and client pokes.}
{// [wp=wFormat lp=LPLINKDATA]}
	VBM_LINKGETDATA    =	VBM__BASE + $20; 

{// Used in client requests, advises, and server pokes.}
{// [wp=wFormat lp=LPLINKDATA]}
	VBM_LINKSETDATA    =	VBM__BASE + $21; 

{// Get help on property or event name.}
{// [LOBYTE(wp)=VBHELP_, HIBYTE(wp)=iprop/ievent, lp=lpmodel]}
	VBM_HELP	   =	VBM__BASE + $22; 

	VBHELP_PROP		=	$0001;
	VBHELP_EVT		=	$0002;
	VBHELP_CTL    		=	$0003;

{// Get default size of control}
{// LOWORD(RetVal)=cx, HIWORD(RetVal)=cy}
	VBM_GETDEFSIZE	   =	VBM__BASE + $23; 

{// Just like VBM_SAVE(LOAD)PROPERTY, but saves (loads) as text.}
	VBM_SAVETEXTPROPERTY   =	VBM__BASE + $24; 
	VBM_LOADTEXTPROPERTY   =	VBM__BASE + $25; 

{// Is char a mnemonic for this control?}
{// [wp=char] RetVal=TRUE/FALSE}
	VBM_ISMNEMONIC	   =	VBM__BASE + $26; 

{// Does control want to see WM_KEYUP/WM_KEYDOWN for vk?  Sent only}
{// for keys which are normally trapped by VB.  E.g. Tab, Enter, etc.}
{// [wp=vk] RetVal=TRUE/FALSE}
	VBM_WANTSPECIALKEY =	VBM__BASE + $27; 

{//Notifies a control that it has been selected in the property window.}
{//[wp=multiselect ON (TRUE) or OFF (FALSE)]}
{//[LOWORD(lp)=multiselect count (0 first, n last)]}
	VBM_SELECTED	   =	VBM__BASE + $28; 

{// Bound control interface}
	VBM_DATA_INITIATE =	VBM__BASE + $29;
	VBM_DATA_TERMINATE=	VBM__BASE + $2A;

	VBM_DATA_AVAILABLE=	VBM__BASE + $2B;
	VBM_DATA_GET	  =	VBM__BASE + $2C;
	VBM_DATA_REQUEST  =	VBM__BASE + $2D;
	VBM_DATA_SET	  =	VBM__BASE + $2E;
	VBM_DATA_METHOD   =	VBM__BASE + $2F;


{// Notifications reflected back to control from parent.}
	VBN__BASE	  =	VBM__BASE + $1000;

	VBN_COMMAND		=	VBN__BASE + WM_COMMAND;
	VBN_CTLCOLOR		=	VBN__BASE + WM_CTLCOLOR;
	VBN_DRAWITEM		=	VBN__BASE + WM_DRAWITEM;
	VBN_MEASUREITEM 	=	VBN__BASE + WM_MEASUREITEM;
	VBN_DELETEITEM		=	VBN__BASE + WM_DELETEITEM;
	VBN_VKEYTOITEM		=	VBN__BASE + WM_VKEYTOITEM;
	VBN_CHARTOITEM		=	VBN__BASE + WM_CHARTOITEM;
	VBN_COMPAREITEM 	=	VBN__BASE + WM_COMPAREITEM;
	VBN_HSCROLL		=	VBN__BASE + WM_HSCROLL;
	VBN_VSCROLL		=	VBN__BASE + WM_VSCROLL;
	VBN_PARENTNOTIFY	=	VBN__BASE + WM_PARENTNOTIFY;


{---------------------FUNCTIONS----------------------------------------}
{//  General routines}

function VBGetMode: Word;


{// General control routines}

function VBDerefControl(Control: HCtl): LongInt;
function VBDefControlProc(Control: HCtl;Wnd: HWnd;
		Msg: Word; WParam: Word; LParam: LongInt): LongInt;
function VBRegisterModel(HMod: THandle ; var Model: TModel ): Boolean;

function VBGetControlHwnd(Control: HCtl): HWnd;
function VBGetHInstance: THandle;
function VBGetControlModel(Control: HCtl): LPModel;

function VBGetControlName(Control: HCtl; lpszName: LPStr): LPStr;
function VBGetHwndControl(Wnd: HWnd): HCtl;
function VBSendControlMsg(Control: HCtl; Msg, WParam: Word; LParam: LongInt): LongInt;

function VBSuperControlProc(Control: HCtl; Msg, WParam: Word; LParam: LongInt): LongInt;
function VBRecreateControlHwnd(Control: HCtl):Word;
procedure VBDirtyForm(Control: HCtl);

function VBSetErrorMessage(error: Word; Str: LPStr): Word;
procedure VBGetAppTitle(Str: LPStr; cbMax: Word);
function VBDialogBoxParam(Instance: THandle; TemplateName: LPStr;
									DialogFunc: TFARPROC; lp: LongInt):Integer;

{// Management of dynamically allocated strings}

{HSZ	FAR PASCAL VBCreateHsz(HANDLE seg, PChar lpszString);}
function VBCreateHsz(Control: HCtl; Str: LPStr): HSZ;				{Params changed}

function VBDestroyHsz(HSZStr: HSZ): HSZ;
function VBDerefHsz(HSZStr: HSZ): LPStr;
function VBLockHsz(HSZStr: HSZ): LPStr;
function VBUnlockHsz(HSZStr: HSZ): LPStr;

{// Management of language strings}

function VBCreateHlstr(pb: Pointer; cbLen: Word): HLStr;
procedure VBDestroyHlstr(HStr: HLStr);
function VBDerefHlstr(HStr: HLStr): LPStr;
function VBGetHlstrLen(HStr: HLStr): Word;
function VBSetHlstr(PHStr: Pointer; pb: Pointer; cbLen: Word): Word;

{// Firing Basic event procedures}

function VBFireEvent(Control: HCtl; IdEvent: Word; LPParams: Pointer): Word;

{// Control property access}

function VBGetControlProperty(Control: HCtl; IdProp: Word; PData: Pointer): Word;
function VBSetControlProperty(Control: HCtl; IdProp: Word; Data: LOngInt): Err;

{// Picture management functions}

function VBAllocPic(PntPic: PPIC): HPic;
procedure VBFreePic(Pic: HPic);
function VBGetPic(Pic: HPic; PntPic: PPic): HPic;
function VBPicFromCF(PntHPic: Pointer; HData: THandle; WFormat: Word): Word;
function VBRefPic(Pic: HPic): HPic;

{// File IO functions}

function VBReadFormFile(FormFile: HFormFile; pb: Pointer; cb: Word):Word;
function VBWriteFormFile(FormFile: HFormFile; pb: Pointer; cb: Word):Word;
function VBSeekFormFile(FormFile: HFormFile; OffSet: LongInt): LongInt;
function VBRelSeekFormFile(FormFile: HFormFile; OffSet: LongInt):LongInt;
function VBReadBasicFile(UsFileNo: Word; pb: Pointer; cb: Word):Word;
function VBWriteBasicFile(UsFileNo: Word; pb: Pointer; cb: Word):Word;

{// Conversion functions}

function VBYPixelsToTwips(Pixels: Integer): LongInt;
function VBXPixelsToTwips(Pixels: Integer): LongInt;
function VBYTwipsToPixels(Twips: LongInt):Integer;
function VBXTwipsToPixels(Twips: LongInt):Integer;


{// Ver 2.0 Functions}

function VBGetVersion: Word;

function VBSetControlFlags(Control: HCtl; mask: LongInt; value: LongInt ): LongInt;
function VBGetCapture: HCtl;
procedure VBSetCapture(Control: HCtl );
procedure VBReleaseCapture;
procedure VBMoveControl(Control: HCtl; var Rect: TRect ; fRepaint: BOOL );
procedure VBGetControlRect(Control: HCtl ;var Rect: TRect );
procedure VBGetRectInContainer(Control: HCtl ;var Rect: TRect );
procedure VBGetClientRect(Control: HCtl ;var Rect: TRect );
procedure VBClientToScreen(Control: HCtl ;var Point: TPoint );
procedure VBScreenToClient(Control: HCtl;var Point: TPoint );
function VBIsControlVisible(Control: HCtl ): BOOL;
function VBIsControlEnabled(Control: HCtl ): BOOL;
procedure VBInvalidateRect(Control: HCtl ;var Rect: TRect ; fEraseBkGnd: BOOL );
procedure VBUpdateControl(Control: HCtl );

function VBGetControl(Control: HCtl ; gc: WORD ): HCtl;
procedure VBZOrder(Control: HCtl ; zorder: WORD );
function VBCreateTempHlstr(pb: Pointer ; cbLen: Word ): HLStr;
function VBDerefHlstrLen(HStr: HLStr ;var pCbLen: Word ): PChar;
function VBDerefZeroTermHlstr(HStr: HLStr ): PChar;
function VBGetHlstr(HStr: HLStr ; pb: Pointer ; cbLen: Word ): Word;
function VBResizeHlstr(HStr: HLStr ; newCbLen: Word ): Word;

{// Management of language Variant data type}

function VBCoerceVariant(Variant: PVariant ; vtype: Integer ; lpData: Pointer ): Word;
function VBGetVariantType(Variant: PVariant ): Integer;
function VBGetVariantValue(Variant: PVariant ; Value: PValue ): Integer;
function VBSetVariantValue(Variant: PVariant ; vtype: Integer ; lpData: Pointer ): Word;

{// Management of language arrays}

function VBArrayElement(VBArray: HAD ; cIndex: Integer ;var lpi: Integer ): Pointer;
function VBArrayBounds(VBArray: HAD ; index: Integer ): LongInt;
function VBArrayElemSize(VBArray: HAD ): Word;
function VBArrayFirstElem(VBArray: HAD ): Pointer;
function VBArrayIndexCount(VBArray: HAD ): Integer;

{// VB Error routines}

procedure VBRuntimeError(err: Word );

{// Floating-point stack save/restore utilities}
function VBCbSaveFPState(pb: Pointer ; cb: Word ): Word;
procedure VBRestoreFPState(pb: Pointer );

{// Picture functions}
function VBAllocPicEx(PntPic: PPIC ; usVersion: Word ): HPic;
function VBGetPicEx(Pic: HPic ; PntPic: PPIC ; usVersion: Word ): HPic;
procedure VBPaletteChanged(Control: HCtl );
function VBTranslateColor(Control: HCtl ; Color: LongInt ): LongInt;

{// Link Interface functions}

function VBLinkPostAdvise(Control: HCtl ): Word;
function VBPasteLinkOk(var phTriplet: THANDLE ; Control: HCtl ): BOOL;

{// Misc functions}
function VBFormat(vtype: Integer ; lpData: Pointer ; lpszFmt: PChar ;
					pb: Pointer ; cb: Word ): Integer;

{ VB 3.0 }
procedure VBLinkMakeItemName(Control:HCTL; lpszBuf: PChar);

function VBGetDataSourceControl(Control: HCTL; blsRegistered: Bool):HCtl;

function VBSeekBasicFile(usFileNo: Word; offset: LongInt): LongInt;
function VBRelSeekBasicFile(usFileNo: Word; offset: LongInt): LongInt;


{misc}
{//---------------------------------------------------------------------------
// VB Messege Record
//---------------------------------------------------------------------------}
type
	TVBMsg = record
		Control :HCtl;
		Wnd		:HWnd;
		Msg		:Word;
		WParam	:Word;
		LParam	:LongInt;
        Result	:LongInt;
	end;
function Tpw2VBRegInfo(RegUser: PChar; RegNum: LongInt):LongInt;

procedure TpwVBMessage(var VBMsg: TVBMsg; Control: HCtl; Wnd: HWnd;
					Msg: Word; WParam: Word; LParam: LongInt);

procedure TpwVBDefControlProc(var VBMsg: TVBMsg);


implementation

function RGBColor(Color: LongInt):Longint;
begin
	if Boolean(Color and $80000000) then
		RGBColor := GetSysColor(Color and $00FFFFFF)
    else RGBColor := Color;
end;

procedure TpwVBMessage(var VBMsg: TVBMsg; Control: HCtl; Wnd: HWnd;
					Msg: Word; WParam: Word; LParam: LongInt);
begin
	VBMsg.Control 	:= Control;
	VBMsg.Wnd		:= Wnd;
	VBMsg.Msg		:= Msg;
	VBMsg.WParam	:= WParam;
	VBMsg.LParam	:= LParam;
end;

procedure TpwVBDefControlProc(var VBMsg: TVBMsg);
begin
	VBMsg.Result :=
		VBDefControlProc(VBMsg.Control, VBMsg.Wnd, VBMsg.Msg,
							VBMsg.WParam, VBMsg.LParam);
end;

function VBGetMode;				external CDLL	index	 11;

{// General control routines}

function VBDerefControl;			external CDLL	index	 12;
function VBDefControlProc;		external CDLL	index	 13;
function VBRegisterModel;		external CDLL	index	 14;

function VBGetControlHwnd;		external CDLL	index	 15;
function VBGetHInstance;			external CDLL	index	 16;
function VBGetControlModel;		external CDLL	index	 17;

function VBGetControlName;		external CDLL	index	 18;
function VBGetHwndControl;		external CDLL	index	 19;
function VBSendControlMsg;		external CDLL	index	 20;

function VBSuperControlProc;		external CDLL	index	 21;
function VBRecreateControlHwnd;	external CDLL	index	 22;
procedure VBDirtyForm;			external CDLL	index	 23;

function VBSetErrorMessage;		external CDLL	index	 24;
procedure VBGetAppTitle;			external CDLL	index	 25;
function VBDialogBoxParam;		external CDLL	index	 26;

{// Management of dynamically allocated strings}

function VBCreateHsz;			external CDLL	index	 27;

function VBDestroyHsz;			external CDLL	index	 28;
function VBDerefHsz;				external CDLL	index	 29;
function VBLockHsz;				external CDLL	index	 30;
function VBUnlockHsz;			external CDLL	index	 31;

{// Management of language strings}

function VBCreateHlstr;			external CDLL	index	 32;
procedure VBDestroyHlstr;		external CDLL	index	 33;
function VBDerefHlstr;			external CDLL	index	 34;
function VBGetHlstrLen;			external CDLL	index	 35;
function VBSetHlstr;				external CDLL	index	 36;

{// Firing Basic event procedures}

function VBFireEvent;			external CDLL	index	 37;

{// Control property access}

function VBGetControlProperty;	external CDLL	index	 38;
function VBSetControlProperty;	external CDLL	index	 39;

{// Picture management functions}

function VBAllocPic;				external CDLL	index	 40;
procedure VBFreePic;				external CDLL	index	 41;
function VBGetPic;				external CDLL	index	 42;
function VBPicFromCF;			external CDLL	index	 43;
function VBRefPic;				external CDLL	index	 44;

{// File IO functions}

function VBReadFormFile;			external CDLL	index	 45;
function VBWriteFormFile;		external CDLL	index	 46;
function VBSeekFormFile;			external CDLL	index	 47;
function VBRelSeekFormFile;		external CDLL	index	 48;
function VBReadBasicFile;		external CDLL	index	 49;
function VBWriteBasicFile;		external CDLL	index	 50;

{// Conversion functions}

function VBYPixelsToTwips;		external CDLL	index	 51;
function VBXPixelsToTwips;		external CDLL	index	 52;
function VBYTwipsToPixels;		external CDLL	index	 53;
function VBXTwipsToPixels;		external CDLL	index	 54;

function Tpw2VBRegInfo;			external CDLL	index	 99;

{//New 2.0 functions}
function VBGetVersion			;	external CDLL index		100;
function VBSetControlFlags	   	;	external CDLL index  	101;
function VBGetCapture		   	;	external CDLL index  	102;
procedure VBSetCapture		   	;	external CDLL index  	103;
procedure VBReleaseCapture	   	;	external CDLL index  	104;
procedure VBMoveControl		   	;	external CDLL index  	105;
procedure VBGetControlRect	  	;	external CDLL index  	106;
procedure VBGetRectInContainer 	;	external CDLL index  	107;
procedure VBGetClientRect	   	;	external CDLL index  	108;
procedure VBClientToScreen	   	;	external CDLL index  	109;
procedure VBScreenToClient	   	;	external CDLL index  	110;
function VBIsControlVisible	   	;	external CDLL index  	111;
function VBIsControlEnabled	   	;	external CDLL index  	112;
procedure VBInvalidateRect	   	;	external CDLL index  	113;
procedure VBUpdateControl	   	;	external CDLL index  	114;
function VBGetControl		   	;	external CDLL index  	115;
procedure VBZOrder		   		;	external CDLL index  	116;
function VBCreateTempHlstr		;	external CDLL index  	117;
function VBDerefHlstrLen		;	external CDLL index  	118;
function VBDerefZeroTermHlstr	;	external CDLL index  	119;
function VBGetHlstr		   		;	external CDLL index  	120;
function VBResizeHlstr		   	;	external CDLL index  	121;
function VBCoerceVariant	   	;	external CDLL index  	122;
function VBGetVariantType		;	external CDLL index  	123;
function VBGetVariantValue		;	external CDLL index  	124;
function VBSetVariantValue		;	external CDLL index  	125;
function VBArrayElement		   	;	external CDLL index  	126;
function VBArrayBounds		   	;	external CDLL index  	127;
function VBArrayElemSize		;	external CDLL index  	128;
function VBArrayFirstElem		;	external CDLL index  	129;
function VBArrayIndexCount		;	external CDLL index  	130;
procedure VBRuntimeError		;	external CDLL index  	131;
function VBCbSaveFPState		;	external CDLL index  	132;
procedure VBRestoreFPState		;	external CDLL index  	133;
function VBAllocPicEx		   	;	external CDLL index  	134;
function VBGetPicEx		   		;	external CDLL index  	135;
procedure VBPaletteChanged		;	external CDLL index  	136;
function VBTranslateColor		;	external CDLL index  	137;
function VBLinkPostAdvise		;	external CDLL index  	138;
function VBPasteLinkOk		   	;	external CDLL index  	139;

function VBFormat		   		;	external CDLL index  	143;

{	[3.0]  }
procedure VBLinkMakeItemName	;	external CDLL index		201;
    
function VBGetDataSourceControl	;	external CDLL index		301;
    
function VBSeekBasicFile		;	external CDLL index		302;
function VBRelSeekBasicFile		;	external CDLL index		303;

end.
