library push;

{$R push.RES}
{$D Opaque Software  - Push Demo}


uses wintypes, winprocs, tpw2vb, strings;


{//---------------------------------------------------------------------------
// Resource ID's
//---------------------------------------------------------------------------
// Toolbox bitmap resource IDs.
//---------------------------------------------------------------------------}
const
	IDBMP_Push		=	8000;
	IDBMP_PushDOWN	=	8001;
	IDBMP_PushMONO	=	8003;
	IDBMP_PushEGA	  	=	8006;

{//---------------------------------------------------------------------------
// Standard Error Values
//---------------------------------------------------------------------------}
	ERR_None	      =	0;
	ERR_InvPropVal	    =	380; 	{/ Error$(380) = "Invalid property value"}


{//---------------------------------------------------------------------------
// Procedure Declarations
//---------------------------------------------------------------------------}

{//---------------------------------------------------------------------------
// Global Variables and Constants
//---------------------------------------------------------------------------}

{//---------------------------------------------------------------------------
// Push control data and structs
//---------------------------------------------------------------------------}
type
	PPush = ^TPush;
	TPush = record
		PicUp,
        PicDown:	HPic;
	end;

{//---------------------------------------------------------------------------
// Property list
//---------------------------------------------------------------------------
// Define the consecutive indicies for the properties
//---------------------------------------------------------------------------}
const
	IPROP_Push_NAME 	  =	$0000;
	IPROP_Push_INDEX	  = $0001;
	IPROP_Push_PARENT	  = $0002;
	IPROP_Push_BACKCOLOR  = $0003;
	IPROP_Push_LEFT 	  = $0004;
	IPROP_Push_TOP		  = $0005;
	IPROP_Push_WIDTH	  = $0006;
	IPROP_Push_HEIGHT	  = $0007;
	IPROP_Push_ENABLED	  = $0008;
	IPROP_Push_VISIBLE	  = $0009;
	IPROP_Push_MOUSEPOINTER   = $000A;
	IPROP_Push_CAPTION	  = $000B;
	IPROP_Push_FONTNAME	  = $000C;
	IPROP_Push_FONTSIZE	  = $000D;
	IPROP_Push_FONTBOLD	  = $000E;
	IPROP_Push_FONTITALIC	  = $000F;
	IPROP_Push_FONTSTRIKE	  = $0010;
	IPROP_Push_FONTUNDER	  = $0011;
	IPROP_Push_DRAG 	  = $0012;
	IPROP_Push_DRAGICON	  = $0013;
	IPROP_Push_TABINDEX	  = $0014;
	IPROP_Push_TABSTOP	  = $0015;
	IPROP_Push_TAG		  = $0016;
	IPROP_Push_PictureUp	  = $0017;
	IPROP_Push_PictureDown	  = $0018;

Property_PictureUp: TPROPINFO  =
(
	npszName: 	NPnt(PChar('PictureUp'));
	fl:		  	DT_Picture or PF_fGetData or PF_fSetData or
				PF_fSetCheck or	PF_fSaveData;
	offsetData: 0;
	infoData:	0;		
	dataDefault: 	0;
	npszEnumList: 	0;
	enumMax:	0		
);

Property_PictureDown: TPROPINFO  =
(
	npszName: 	NPnt(PChar('PictureDown'));
	fl:		  	DT_Picture or PF_fGetData or PF_fSetData or
				PF_fSetCheck or	PF_fSaveData;
	offsetData: 2;
	infoData:	0;		
	dataDefault: 	0;
	npszEnumList: 	0;
	enumMax:	0		
);


const
	PropListPush : array[0..25]of PPROPINFO =
(
	PPROPINFO_STD_CTLNAME,
    PPROPINFO_STD_INDEX,
    PPROPINFO_STD_PARENT,
    PPROPINFO_STD_BACKCOLOR,
    PPROPINFO_STD_LEFT,
    PPROPINFO_STD_TOP,
    PPROPINFO_STD_WIDTH,
    PPROPINFO_STD_HEIGHT,
    PPROPINFO_STD_ENABLED,
    PPROPINFO_STD_VISIBLE,
    PPROPINFO_STD_MOUSEPOINTER,
    PPROPINFO_STD_CAPTION,
    PPROPINFO_STD_FONTNAME,
    PPROPINFO_STD_FONTSIZE,
    PPROPINFO_STD_FONTBOLD,
    PPROPINFO_STD_FONTITALIC,
    PPROPINFO_STD_FONTSTRIKE,
    PPROPINFO_STD_FONTUNDER,
    PPROPINFO_STD_DRAGMODE,
    PPROPINFO_STD_DRAGICON,
    PPROPINFO_STD_TABINDEX,
    PPROPINFO_STD_TABSTOP,
    PPROPINFO_STD_TAG,
	PPropInfo(@Property_PictureUp),
	PPropInfo(@Property_PictureDown),
	0
);

{//---------------------------------------------------------------------------
// Event Procedure Parameter Profiles
//---------------------------------------------------------------------------}
type
	TParams = record
    	ClickString: 	HLStr;
    	Index:			Pointer;    {// Reserve space for index parameter to array ctl}
	end;

{//---------------------------------------------------------------------------
// Event list
//---------------------------------------------------------------------------
// Define the consecutive indicies for the events
//---------------------------------------------------------------------------}
const
	EVENT_PUSH_CLICK	=	0;
	EVENT_PUSH_DRAGDROP	=	1;
	EVENT_PUSH_DRAGOVER	=	2;
	EVENT_PUSH_GOTFOCUS	=	3;
	EVENT_PUSH_KEYDOWN	=	4;
	EVENT_PUSH_KEYPRESS	=	5;
	EVENT_PUSH_KEYUP	=	6;
	EVENT_PUSH_LOSTFOCUS	=	7;

{//---------------------------------------------------------------------------
// Event procedure parameter prototypes
//---------------------------------------------------------------------------}
	Parms_SD:	array[0..0]of word = (ET_SD);			{// 1 x SD parm}

Event_Click: TEVENTINFO  = (
	npszName: 		NPnt(PChar('Click'));
	cParms:			1;
	cwParms: 		2;	
	npParmTypes:	NPnt(@Parms_SD);
	npszParmProf:	NPnt(PChar('ButtonCaption as String'));
	fl:				0
);

EventListPush: array[0..8]of PEVENTINFO = (
	PEventInfo(@Event_Click),
	PEVENTINFO_STD_DRAGDROP,
    PEVENTINFO_STD_DRAGOVER,
    PEVENTINFO_STD_GOTFOCUS,
    PEVENTINFO_STD_KEYDOWN,
    PEVENTINFO_STD_KEYPRESS,
    PEVENTINFO_STD_KEYUP,
    PEVENTINFO_STD_LOSTFOCUS,
	0
);


{//---------------------------------------------------------------------------
// Procedures 
//---------------------------------------------------------------------------}
function min(a, b: LongInt):LongInt;
begin
	if a < b then
		min := a
	else min := b;
end;

{//---------------------------------------------------------------------------
// Paint the push button.
//---------------------------------------------------------------------------}
procedure DrawBtn(Control: HCtl; DrawItem: PDrawItemStruct);
var
    PicHand:	HPic;
    Pic:     	TPic;
	Push:		PPush;
	bmp:		TBitMap;
    MemDC:		HDC;
    rect:		TRect;
	inflate:	Integer;
    Brush:		HBrush;
begin
	Push := PPush(VBDerefControl(Control));
	case DrawItem^.itemAction of
		ODA_Select,
		ODA_DrawEntire: begin
			if Boolean(DrawItem^.itemState and ODS_SELECTED) then
				PicHand := Push^.PicDown
			else PicHand := Push^.PicUp;
			VBGetPic(PicHand, @Pic);
			case Pic.picType of
				PICTYPE_BITMAP: begin
					GetObject(Pic.picData.bitmap, sizeof(TBitMap), PChar(@Bmp));
					MemDC := CreateCompatibleDC(DrawItem^.hDC);
					SelectObject(MemDC, Pic.picData.bitmap);
					StretchBlt(DrawItem^.hDC, 0, 0,
						   DrawItem^.rcItem.right - DrawItem^.rcItem.left + 1,
						   DrawItem^.rcItem.bottom - DrawItem^.rcItem.top + 1,
						   MemDC,	  0, 0, Bmp.bmWidth, Bmp.bmHeight,
						   SRCCOPY);
					DeleteDC(MemDC);
					end;

				PICTYPE_ICON,
				PICTYPE_NONE: begin
					Brush := HBrush(SendMessage(GetParent(DrawItem^.hwndItem),
							WM_CtlColor, DrawItem^.hDC, MAKELONG(DrawItem^.hwndItem, 0)));
					GetClipBox(DrawItem^.hDC, rect);
					FillRect(DrawItem^.hDC, rect, Brush);
					if Pic.picType = PICTYPE_ICON then
						DrawIcon(DrawItem^.hDC, 0, 0, Pic.picData.meta)
					else if Boolean(DrawItem^.itemState and ODS_SELECTED) then
						InvertRect(DrawItem^.hDC, rect);
					end;
            end;
			if Boolean(DrawItem^.itemState and ODS_FOCUS) then
            begin
				CopyRect(rect, DrawItem^.rcItem);
				inflate := min(3,min(rect.right	- rect.left + 1,
							rect.bottom - rect.top  + 1) div 5);
				InflateRect(rect, -inflate, -inflate);
				DrawFocusRect(DrawItem^.hDC, rect);
			end;
			end;
		{// **** FALL THROUGH ****}

		ODA_Focus:
			if Boolean(DrawItem^.itemState and ODS_FOCUS) then
            begin
				CopyRect(rect, DrawItem^.rcItem);
				inflate := min(3,min(rect.right	- rect.left + 1,
							rect.bottom - rect.top  + 1) div 5);
				InflateRect(rect, -inflate, -inflate);
				DrawFocusRect(DrawItem^.hDC, rect);
			end;
	end;
end;


{//---------------------------------------------------------------------------
// 	Control Procedure
//	This routine is called for all VB and Windows Msgs.
//---------------------------------------------------------------------------}
function PushCtlProc(Control: HCtl; Wnd: HWnd;
			Msg, WParam: Word; LParam: LongInt):LongInt; export;
var
	Params:		TParams;
	StrBuf:		array[0..19]of char;
	Caption:	Integer;
	error:		Err;
	tmpStr:		PChar;
    Pic:		TPic;
begin
	case Msg of
		WM_ERASEBKGND:
	    	{// Don't bother with erasing the background}
			PushCtlProc := 1;

		VBM_MNEMONIC,
		VBN_COMMAND: begin
        	if Msg = VBM_MNEMONIC then
				{// Act like a click}
				LParam := MAKELONG(0,BN_CLICKED);
			case HIWORD(LParam) of
				BN_CLICKED: begin
					Caption := GetWindowText(Wnd, StrBuf, 20);
					Params.ClickString := VBCreateHlstr(@StrBuf, Caption);
					error := VBFireEvent(Control, EVENT_Push_Click, @Params);
					if not Boolean(error) then
					begin
						tmpStr := VBDerefHlstr(Params.ClickString);
						if tmpStr = nil then
						begin
							StrBuf[0] := #0;
							SetWindowText(Wnd, StrBuf);
						end
						else
						begin
							tmpStr[VBGetHlstrLen(Params.ClickString) - 1] := #0;
							SetWindowText(Wnd, tmpStr);
						end;
					end;
					VBDestroyHlstr(Params.ClickString);
                    end;
			end;
			PushCtlProc := 0;
            exit;
            end;

		VBM_SETPROPERTY:
	    	case WParam of
				IPROP_PUSH_CAPTION: 
					{// To avoid a Windows problem, make sure text is
					// under 255 bytes:}
					if (lstrlen(PChar(LParam)) > 255) then
						PChar(LParam)[255] := #0;
            end;
			
		VBM_CHECKPROPERTY:
	    	case WParam of
				IPROP_PUSH_PICTUREUP,
				IPROP_PUSH_PICTUREDOWN: begin
				   	VBGetPic(HPic(LParam), @Pic);
				   	case Pic.picType of
				   		PICTYPE_NONE,
				   		PICTYPE_BITMAP,
				   		PICTYPE_ICON: begin
					   		InvalidateRect(Wnd, nil, TRUE);
							PushCtlProc := ERR_None;
							exit;
							end;
                    end;
					PushCtlProc := ERR_InvPropVal;
					exit;
                    end;
            end;

		VBN_DRAWITEM: begin
	    	DrawBtn(Control, PDrawItemStruct(LParam));
			PushCtlProc := 0;
            exit;
			end;
	end;
    {// Default processing:}
	PushCtlProc := VBDefControlProc(Control, Wnd, Msg, WParam, LParam);

    {// Message post-processing:}
	case Msg of
		WM_DESTROY: begin
			VBFreePic(PPush(VBDerefControl(Control))^.picDown);
			VBFreePic(PPush(VBDerefControl(Control))^.picUp);
			end;
	end;

end;

{//---------------------------------------------------------------------------
// Model struct
//---------------------------------------------------------------------------
// Define the control model (using the event and property structures).
//---------------------------------------------------------------------------}
const
modelPush: TMODEL = (
	usVersion:		VB_VERSION;							{ VB version used by control}
	fl:				MODEL_fFocusOk or MODEL_fMnemonic; 	{ Bitfield structure}
	ctlproc:		TFarProc(@PushCtlProc);				{ The control proc.}
	fsClassStyle:	cs_VRedraw or cs_HRedraw;			{ window class style}
	flWndStyle:		ws_Border or BS_PUSHBUTTON or
					BS_OWNERDRAW;	 	   				{ default window style}
	cbCtlExtra:		sizeof(TPush);						{ # bytes alloc'd for HCTL structure}
	idBmpPalette:	IDBMP_Push;							{ BITMAP id for tool palette}
	DefCtlName: 	NPnt(PChar('Push')); 				{ default control name prefix}
	ClassName:		NPnt(PChar('PushButton'));			{ Visual Basic class name}
	ParentClassName:	NPnt(PChar('Button'));			{ Parent window class if subclassed}
	proplist:		ofs(PropListPush)	;				{ Property list}
	eventlist:		ofs(EventListPush); 				{ Event list}
	nDefProp: 		0;									{ index of default property}
	nDefEvent:		0									{ index of default event}
);

{//---------------------------------------------------------------------------
// Register custom control.
//	This routine is called by VB when the custom control DLL is
//	loaded for use.
//---------------------------------------------------------------------------}
function VBINITCC(usVersion: Word; fRunTime: Boolean): Boolean; export;
begin
	VBINITCC := VBRegisterModel(HInstance, modelPush);
end;

exports
	VBINITCC index 2,
	PushCtlProc index 3;

begin

end.
