
const sysdate_tag: string[90]
   = #0'@(#)CURRENT_FILE LAST_UPDATE Date/time string library 1.0'#0;

(*
 * sysdate - library to return system date and time
 *
 * s.h.smith, 10-sep-86
 *
 *)

function system_date: anystring;
const
   month : array [1..12] of string[3]
           = ('Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun',
              'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec');
type
   string2 = string[2];
var
   reg:           regpack;

   function strval (i: integer): string2;
   begin
      strval := chr(((i div 10) mod 10) + ord('0')) +
                chr((i mod 10) + ord('0'));
   end;

begin
   reg.ax := $2a00;
   msdos(reg);
   system_date := strval(lo(reg.dx)) + '-' +
                  month[hi(reg.dx)] + '-' +
                  strval(reg.cx-1900);
end;


function system_time: anystring;
var
   reg:       regpack;
   hh,mm,ss:  string[2];

begin
   reg.ax := $2c00;
   msdos(reg);
   str(hi(reg.cx),hh);  if length(hh) = 1 then hh := '0' + hh;
   str(lo(reg.cx),mm);  if length(mm) = 1 then mm := '0' + mm;
   str(hi(reg.dx),ss);  if length(ss) = 1 then ss := '0' + ss;
   system_time := hh + ':' + mm + ':' + ss;
end;
