
(*
 * these macros define general utility functions that can be used on
 * all kinds of variables
 *
 *)

#define EOS #0
   {-- end of string character}

#define LEN ord(%1[0])
   {-- length of a string:  ...(str)}

#define TRUNC %1[0] := EOS
   {-- truncate a string (make 0 length):  ...(str)}

#define CONCAT_CHAR     \
   begin                \
      INC(%1[0]);       \
      %1[LEN(%1)] := %2 \
   end
   {-- concatenate a char to a buffer:  ...(buffer,char)}

#define CONCAT_STR                         \
   begin                                   \
      move(%2[1], %1[LEN(%1)+1], LEN(%2)); \
      %1[0] := chr(LEN(%1)+LEN(%2))        \
   end
   {-- concatenate a string to a buffer:  ...(buffer,str)}

#define COPY_STR move(%2[0],%1[0],LEN(%2)+1)
   {-- copy strings:  ...(to,from)}

