

(*
 * maildirs - library to get list of GT-HOST mail directories
 *
 *)

var
   maillevel:    array[1..100] of char;
   maildir:      array[1..100] of string[64];
   maildirs:     integer;


procedure get_maildir_list;
   {build list of available mail directories}
var
   fd:       text;
   gtmdir:   anystring;
   line:     anystring;
   i:        integer;

begin
   maildirs := 0;

   gtmdir := locate_file_env('gtmdir.bbs','GTPATH=');
   if exists(gtmdir) = false then
   begin
      writeln;
      writeln(whoami,':  Can''t locate mail directory, ',gtmdir);
      writeln('Check setting of GTPATH environment variable.');
      halt;
   end;

   assign(fd,gtmdir);
   reset(fd);

   while not eof(fd) do
   begin
      readln(fd,line);
      line := line + ' ';

      if line[1] <> ' ' then
      begin
         INCR(maildirs);
         if line[1] in ['0','A'..'Z'] then
            i := 1
         else
            i := 2;

         maillevel[maildirs] := line[i];

         i := pos(' ',line);
         while (i < LEN(line)) and (line[i] = ' ') do
            INCR(i);

         delete(line,1,i-1);
         i := pos(' ',line);

         line := copy(line,1,i-1);
         if line[LEN(line)] <> '\' then
            line := line + '\';
         maildir[maildirs] := line;
      end;
   end;

   close(fd);
end;

