
const filedate_tag: string[90]
   = #0'@(#)CURRENT_FILE LAST_UPDATE Get file date as a real 1.0'#0;
#log Get file date as a real 1.0

(*
 * Return the modification date of a file as a real.
 * This real will always be larger for later file dates.
 *
 * The returned date, if printed with writeln(date:11:4) will give
 * the following format:
 *        yymmdd.hhmm
 *
 *)

function filedate (filename:      anystring): real;
var
   b1, b2,
   hr, mn, se,
   m, d, y:       integer;
   dta:           array [1..512] of byte;
   reg:           regpack;

begin                       {set up disk transfer area}

   reg.ax := $1a00;
   reg.ds := seg (dta [1]);
   reg.dx := ofs (dta [1]);
   msdos(reg);              {fill up dta}

   filename := filename + #0;
   reg.ax := $4e00;
   reg.cx := 39;
   reg.ds := seg (filename [1]);
   reg.dx := ofs (filename [1]);
   msdos(reg);

   if (reg.flags and 1) = 1 then
      filedate := 0            {no such file; lowest date}
   else

   begin
      b1 := ord (dta [25]);
      b2 := ord (dta [26]);
      d := b1 and 31;
      m :=(b1 shr 5)+ 8 *(b2 and 1);
      y :=(b2 shr 1){+ 80};

      b1 := ord (dta [23]);
      b2 := ord (dta [24]);
      mn :=(b1 shr 5)+ ((b2 and 7) shl 3);
      hr := b2 shr 3;
      se := (b1 and 31) shl 1;

      filedate := int(y)*10000.0 +
                  int(m)*100.0 +
                  int(d) +
                  int(hr) / 100.0 +
                  int(mn) / 10000.0 +
                  int(se) / 1000000.0;
   end;

end;

