{**************************************************************************}
{                                                                          }
{ TPASCIIZ.PAS                                                             }
{ Turbo Pascal Version 1.00                                                }
{                                                                          }
{ (c) 1993, RAVIART Philippe, All rights reserved.                         }
{ CIS: 100135,503                                                          }
{**************************************************************************}
{$A+,S-}
{$DEFINE DEBUG}

{$IFDEF DEBUG}
   {$D+,L+}
{$ELSE
   {$D-,L-}
{$ENDIF}

unit
  TpAsciiZ;interface

{**************************************************************************}
{                                                                          }
{ This Unit contains 97 procs for treating characters or strings.          }
{ Please Refer to "TPSTR.DOC" for details.                                 }
{                                                                          }
{**************************************************************************}

{$IFNDEF VER70}
Type
   pChar  = ^Char;
{$ENDIF}

{
function    StrL  (L: Longint)                          :pChar;
function    StrLF (L: Longint;Field: Integer)           :pChar;
function    StrR  (R: Real)                             :pChar;
function    StrRF (R: Real;Field: Integer)              :pChar;
function    StrRFD(R: Real;Field,Decimals: Integer)     :pChar;
{$IFOPT N+}{
function    StrC  (C: Comp)                             :pChar;
function    StrCF (C: Comp;Field: Integer)              :pChar;
function    StrCFD(C: Comp;Field,Decimals: Integer)     :pChar;
function    StrD  (D: Double)                           :pChar;
function    StrDF (D: Double;Field: Integer)            :pChar;
function    StrDFD(D: Double;Field,Decimals: Integer)   :pChar;
function    StrE  (E: Extended)                         :pChar;
function    StrEF (E: Extended;Field: Integer)          :pChar;
function    StrEFD(E: Extended;Field,Decimals: Integer) :pChar;
function    StrS  (S: Single)                           :pChar;
function    StrSF (S: Single;Field: Integer)            :pChar;
function    StrSFD(E: Single;Field,Decimals: Integer)   :pChar;
{$ENDIF}

Procedure   _ChrDel(Str: pChar;Match: Char);
Procedure   _ChrnDel(Str: pChar;Match: Char;Count: Integer);
Procedure   _ChrDelI(Str: pChar;Match: Char;Index: Integer);
Procedure   _ChrDelL(Str: pChar;Match: Char);
Procedure   _ChrnDelL (Str: pChar;Match: Char;Count: Integer);
Procedure   _ChrnDelLI (Str: pChar;Match: Char;Count,Index: Integer);
Procedure   _ChrDelR(Str: pChar;Match: Char);
Procedure   _ChrnDelR (Str: pChar;Match: Char;Count: Integer);
Function    _StrLen(Source: pChar): Integer;
Function    _StrEnd(Source: pChar): pChar;
Function    _StrnCat(Var Dest: pChar;Str1: pChar;Maxlen: Integer):pChar;
Function    _StrCat(Var Dest: pChar;Str1: pChar):pChar;
Function    _StrChr(Str1: pChar;Find: Char): pChar;
function    _StrCmp(s1,s2 : pChar): Integer;
function    _StrCopy(Str1,Str2: pChar): pChar;
Function    _StrcSpan(Str1: pChar;Cset: pChar): Integer;
Procedure   _StrCut(Str1: pChar;MaxLen: Integer);
Procedure   _StrENum(Str1: pChar;First,Last: Char);
Function    _StrnFill(Str1: pChar;Fill: pChar;Count,MaxLen: Integer):pChar;
Procedure   _StrRev(Str1: pChar);

implementation

Const
   UpCaseMap : Array[0..37] of Char =
               'AAEEEIIIOOUUYAIOUAO';
   LoCaseMap : Array[0..37] of Char =
               '';

   Digits    : array[0..$F] of Char = '0123456789ABCDEF';

   ChrClass  : Array[0..127] of byte =
               ($00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
                $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
                $00,$48,$08,$48,$48,$48,$48,$48,$48,$48,$88,$28,$08,$68,$68,$08,
                $44,$44,$44,$44,$44,$44,$44,$44,$44,$44,$88,$08,$08,$08,$08,$88,
                $48,$52,$52,$52,$52,$72,$52,$42,$42,$42,$42,$42,$42,$42,$42,$42,
                $42,$42,$42,$42,$42,$42,$42,$42,$42,$42,$42,$08,$88,$08,$48,$48,
                $48,$51,$51,$51,$51,$71,$51,$41,$41,$41,$41,$41,$41,$41,$41,$41,
                $41,$41,$41,$41,$41,$41,$41,$41,$41,$41,$41,$48,$08,$48,$48,$00);

   SoudexTbl : Array[0..255] of Char =
                (#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,
                 #0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,
                 #0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,
                 #0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,
                 #0,#0,'1','2','3',#0,'1','2',#0,#0,'2','2','4',
                 '5','5',#0,'1','2','6','2','3',#0,'1',#0,'2',#0,
                 '2',#0,#0,#0,#0,#0,#0,#0,'1','2','3',#0,'1','2',
                 #0,#0,'2','2','4','5','5',#0,'1','2','6','2','3',
                 #0,'1',#0,'2',#0,'2',#0,#0,#0,#0,#0,#0,#0,#0,#0,
                 #0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,
                 #0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,
                 #0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,
                 #0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,
                 #0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,
                 #0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,
                 #0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,
                 #0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0);

{$F+}
procedure   FastMove;Assembler;
Asm
   cmp   si,di
   jb    @@01
   cld
   shr   cx,1
   jnb   @@03
   movsb
   jmp   @@03
@@01:
   std
   add   si,cx
   dec   si
   add   di,cx
   dec   di
   shr   cx,1
   jnb   @@02
   movsb
@@02:
   dec   si
   dec   di
@@03:
   repne movsw
end;
{$F-}

Function    _StrLen(Source: pChar): Integer;Assembler;
Asm
   cld
   mov   cx,-1
   mov   al,0
   les   di,Source
   repnz scasb
   mov   ax,cx
   not   ax
   dec   ax
end;

Function    _StrEnd(Source: pChar): pChar;Assembler;
Asm
   cld
   mov   cx,-1
   mov   al,0
   les   di,Source
   repnz scasb
   dec   di
   mov   ax,di
   mov   dx,es
end;

Function    _StrnCat(Var Dest: pChar;Str1: pChar;Maxlen: Integer):pChar;Assembler;
Asm
   push  ds
   les   di,Dest
   push  di
   lds   si,Str1
   cld
   mov   al,0
   mov   cx,-1
   repne scasb
   dec   di
   not   cx
   dec   cx
   mov   ax,Maxlen
   sub   ax,cx
   cmp   ax,0
   jle   @@03
   mov   cx,ax
@@01:
   lodsb
   stosb
   or    al,al
   jz    @@03
   loop  @@01
   xor   al,al
   stosb
@@03:
   pop   ax
   mov   dx,es
   pop   ds
End;

function    _StrCat(Var Dest: pChar;Str1: pChar): pChar;Assembler;
Asm
   push  ds
   les   di,Dest
   xor   ax,ax
   mov   cx,-1
   repne scasb
   lea   si,[di-1]
   les   di,Str1
   mov   cx,-1
   repne scasb
   not   cx
   je    @@01
   sub   di,cx
   inc   cx
@@01:
   sub   di,cx
   mov   ax,es
   mov   ds,ax
   mov   es,word ptr (Dest+2)
   xchg  di,si
   mov   ax,word ptr (Dest)
   or    cx,cx
   jnz   @@02
   movsw
   dec   cx
   dec   cx
   jmp   @@03
@@02:
   test  si,1
   jz    @@03
   movsb
   dec   cx
@@03:
   shr   cx,1
   rep   movsw
   adc   cx,cx
   rep   movsb
   pop   ds
   mov   dx,es
end;

function    _StrChr(Str1: pChar;Find: Char): pChar;Assembler;
Asm
   push  di
   les   di,Str1
   mov   bx,di
   xor   ax,ax
   mov   cx,-1
   repne scasb
   not   cx
   mov   al,Find
   mov   di,bx
   repne scasb
   je    @@02
   or    al,al
   jnz   @@01
   inc   di
   jmp   @@02
@@01:
   xor   ax,ax
   xor   dx,dx
   jmp   @@03
@@02:
   lea   ax,[di-1]
   mov   dx,es
@@03:
   pop   di
End;

function    _StrCmp(s1,s2: pChar): Integer;Assembler;
Asm
   push  ds
   lds   si,S1
   cld
   les   di,S2
   xor   ax,ax
   mov   cx,-1
   repne scasb
   not   cx
   sub   di,cx
   repe  cmpsb
   je    @@01
   sbb   ax,ax
   sbb   ax,-1
@@01:
   pop   ds
end;

function    _StrCopy(Str1,Str2: pChar): pChar;Assembler;
Asm
  push  ds
  lds   si,Str2
  mov   di,si
  mov   ax,ds
  mov   es,ax
  xor   ax,ax
  mov   cx,-1
  repne scasb
  not   cx
  les   di,Str1
  mov   ax,di
  je    @@01
  movsw
  dec   cx
  jmp   @@02
@@01:
  test  al,1
  jz    @@02
  movsb
  dec   cx
@@02:
  shr   cx,1
  rep   movsw
  adc   cx,cx
  rep   movsb
  pop  ds
  mov  dx,es
end;

Function    _StrcSpan(Str1: pChar;Cset: pChar): Integer;Assembler;
Asm
   push  ds
   les   di,Str1
   lds   si,CSet
   mov   dx,ds
   cld
   mov   ax,es
   mov   es,dx
   mov   ds,ax
   push  di
   xchg  si,di
   mov   bx,di
   mov   cx,-1
   xor   al,al
   repne scasb
   neg   cx
   dec   cx
   dec   cx
   mov   dx,cx
@@01:
   lodsb
   mov   cx,dx
   mov   di,bx
   repne scasb
   jne   @@01
   pop   di
   mov   ax,di
   sub   ax,si
   neg   ax
   dec   ax
   pop   ds
end;

Procedure   _StrCut(Str1: pChar;MaxLen: Integer);Assembler;
Asm
   cld
   mov   cx,-1
   mov   al,0
   les   di,Str1
   push  di
   repnz scasb
   pop   di
   not   cx
   dec   cx
   cmp   cx,Maxlen
   jl    @@01
   mov   cx,Maxlen
   add   di,cx
   mov   Byte(es:[di]),0
@@01:
end;

Procedure   _StrRev(Str1: pChar);Assembler;
Asm
   push  ds
   cld
   mov   cx,-1
   mov   al,0
   les   di,Str1
   push  di
   repnz scasb
   pop   di
   not   cx
   dec   cx
   cmp   cx,1
   jle   @@02
   mov   ax,es
   mov   ds,ax
   mov   si,di
   add   di,cx
   dec   di
   shr   cx,1
@@01:
   lodsb
   xchg  al,[di]
   mov   [si-1],al
   dec   di
   loop  @@01
@@02:
   pop   ds
end;

Procedure   _StrENum(Str1: pChar;First,Last: Char);Assembler;
Asm
  mov   cx,0
  mov   bx,1
  mov   cl,Last
  sub   cl,First
  cmp   cl,0
  jnl   @@01
  dec   cl
  not   cl
  mov   bx,-1
@@01:
  inc   cl
  les   di,Str1
  cld
  mov   al,First
@@02:
  stosb
  add   al,bl
  loop  @@02
  xor   al,al
  stosb
End;

Function    _StrnFill(Str1: pChar;Fill: pChar;Count,MaxLen: Integer):pChar;Assembler;
Asm
   push  ds
   cld
   les   di,Fill
   mov   al,0
   mov   cx,-1
   repne scasb
   not   cx
   dec   cx
   mov   dl,cl
   mov   dh,cl
   les   di,Str1
   push  di
   lds   si,Fill
   dec   di
   mov   cx,MaxLen
   jcxz  @@04
   or    dl,dl
   jz    @@04
   push  dx
   xor   ah,ah
   mov   al,dl
   mov   bx,Count
   mul   bx
@@01:
   pop   dx
@@02:
   mov   bx,si
   mov   ax,Count
@@03:
   inc   di
   push  ax
   mov   al,[si]
   inc   si
   mov   es:[di],al
   pop   ax
   dec   cx
   jz    @@04
   dec   dl
   jnz   @@03
   dec   ax
   je    @@04
   mov   dl,dh
   mov   si,bx
   jmp   @@02
@@04:
   inc   di
   xor   al,al
   stosb
   pop   ax
   mov   dx,es
   pop   ds
end;

Procedure   _ChrDel(Str: pChar;Match: Char);Assembler;
Asm
   mov    dx,ds
   lds    si,Str
   cld
   mov    di,ds
   mov    es,di
   mov    di,si
   mov    ah,Match
   or     ah,ah
   je     @@04
@@01:
   lodsb
   or     al,al
   je     @@03
   cmp    ah,al
   jne    @@02
   jmp    @@01
@@02:
   stosb
   jmp    @@01
@@03:
   stosb
@@04:
   mov    ds,dx
end;

Procedure   _ChrnDel(Str: pChar;Match: Char;Count: Integer);Assembler;
Asm
   push   ds
   cld
   les    di,Str
   lds    si,Str
   mov    ah,Match
   mov    dx,Count
   or     dx,dx
   je     @@05
@@01:
   lodsb
   or     al,al
   je     @@04
   cmp    al,ah
   je     @@02
   stosb
   jmp    @@01
@@02:
   dec    dx
   jz     @@03
   jmp    @@01
@@03:
   lodsb
   or     al,al
   je     @@04
   stosb
   jmp    @@03
@@04:
   stosb
@@05:
   pop    ds
End;

Procedure   _ChrDelI(Str: pChar;Match: Char;Index: Integer);Assembler;
Asm
   push   ds
   lds    si,Str
   cld
   push   si
   push   ds
   push   si
   push   cs
   call   near ptr _StrLen
   pop    si
   mov    cx,ax
   jcxz   @@04
   mov    bx,Index
   mov    ax,ds
   mov    es,ax
   mov    di,si
   mov    ah,Match
   cmp    bx,cx
   ja     @@04
   or     bx,bx
   je     @@01
   add    di,bx
   add    si,bx
   sub    cx,bx
   inc    cx
@@01:
   lodsb
   or     al,al
   je     @@03
   cmp    al,ah
   je     @@02
   stosb
@@02:
   loop   @@01
   xor    al,al
@@03:
   stosb
@@04:
   pop   ds
end;

Procedure   _ChrDelL(Str: pChar;Match: Char);Assembler;
Asm
   push   ds
   les    di,Str
   lds    si,Str
   push   es
   push   di
   push   cs
   call   near ptr _StrLen
   mov    cx,ax
   jcxz   @@02
   mov    di,si
   mov    al,Match
   mov    bx,cx
   inc    di
   cld
   repe   scasb
   jz     @@02
   mov    dx,di
   dec    dx
   sub    dx,si
   dec    dx
   or     dx,dx
   je     @@02
   mov    cx,bx
   sub    cx,dx
   xchg   di,si
   shr    cx,1
   jnb    @@01
   movsb
@@01:
   rep   movsw
@@02:
   pop  ds
End;

Procedure   _ChrnDelL (Str: pChar;Match: Char;Count: Integer);Assembler;
Asm
   push   ds
   les    di,Str
   lds    si,Str
   push   es
   push   di
   push   cs
   call   near ptr _StrLen
   mov    cx,ax
   jcxz   @@02
   mov    di,si
   mov    bx,cx
   mov    cx,Count
   jcxz   @@02
   mov    al,Match
   cld
   repe   scasb
   mov    dx,di
   sub    dx,si
   dec    dx
   or     dx,dx
   je     @@02
   dec    di
   mov    cx,bx
   sub    cx,dx
   xchg   di,si
   shr    cx,1
   jnb    @@01
   movsb
@@01:
   rep   movsw
   xor   al,al
   stosb
@@02:
   pop  ds
End;

Procedure   _ChrnDelLI (Str: pChar;Match: Char;Count,Index: Integer);Assembler;
Asm
   push   ds
   les    di,Str
   lds    si,Str
   push   es
   push   di
   push   cs
   call   near ptr _StrLen
   mov    cx,ax
   jcxz   @@05
   add    si,Index
   mov    di,si
   mov    bx,cx
   mov    dx,Count
   or     dx,dx
   jz     @@05
   mov    ah,Match
   cld
@@01:
   lodsb
   cmp    al,ah
   jne    @@02
   or     dx,dx
   je     @@02
   dec    dx
   loop   @@01
   jmp    @@03
@@02:
   stosb
   cmp    dx,Count
   jne    @@04
   loop   @@01
@@03:
   xor    al,al
   stosb
   jmp    @@05
@@04:
   push   cs
   call   near ptr fastmove
   jmp    @@03
@@05:
   pop  ds
End;

Procedure   _ChrDelR(Str: pChar;Match: Char);Assembler;
Asm
   les    di,Str
   mov    si,di
   mov    al,Match
   xor    cx,cx
   mov    cl,es:[di]
   jcxz   @@03
   add    di,cx
@@01:
   cmp    es:[di],al
   jne    @@02
   dec    di
   loop   @@01
   jmp    @@03
@@02:
   mov    es:[si],cl
@@03:
end;

Procedure   _ChrnDelR (Str: pChar;Match: Char;Count: Integer);Assembler;
Asm
   les    di,Str
   mov    si,di
   mov    al,Match
   mov    dx,Count
   xor    cx,cx
   mov    cl,es:[di]
   jcxz   @@03
   cmp    dx,0
   jle    @@03
   add    di,cx
@@01:
   cmp    es:[di],al
   jne    @@02
   dec    di
   dec    dx
   js     @@02
   loop   @@01
   jmp    @@03
@@02:
   mov    es:[si],cl
@@03:
End;

end.

