Program Exam37;

{**************************************************************************}
{                                                                          }
{ Ce programme dmontre les possibilits des fonctions de conversion.      }
{                                                                          }
{ Note : La premire lettre du nom de procdure correspond au type         }
{        d'origine de la variable: A -> Ascii                              }
{                                  H -> Idem en reprsentation hxadcimale}
{                                  L -> LongInt                            }
{                                  W -> Word                               }
{        etc ...                                                           }
{        Les deux lettres suivantes sont toujours "To"                     }
{        La dernire indique le type de destination, selon les mmes       }
{        caractristiques que la premire lettre.                          }
{**************************************************************************}

Uses
  TpStr;

Var
  S1 : String;
  L  : LongInt;
  R  : Real;
  Ok : Boolean;

{  ---------------------------------------------------------------         }
{  Function    HToL(Str: String): LongInt;                                 }
{  ---------------------------------------------------------------         }
{                                                                          }
{  Effet     : Transforme la chane <Str> en entier long.                  }
{                                                                          }
{  Vitesse   : 7800/s                                                      }
{                                                                          }
{ -------------------------------------------------------------------------}

Procedure Test1;
Begin
  L := HtoL('0');
  L := HToL('$12345678');
  L := HtoL('-1');
end;

{  ---------------------------------------------------------------         }
{  Function   LtoA(L: LongInt): String;                                    }
{  ---------------------------------------------------------------         }
{                                                                          }
{  Effet     : Transforme l'entier long <L> en chane de caractre.        }
{                                                                          }
{  Vitesse   : 7800/s                                                      }
{                                                                          }
{ -------------------------------------------------------------------------}

Procedure Test2;
Begin
  S1 := LtoA(123456789);
  S1 := LtoA($fe00fe00);
  S1 := LtoA(0);
  S1 := LtoA(-10);
end;

{  ---------------------------------------------------------------         }
{  Function   LtoB(L: LongInt): String;                                    }
{  ---------------------------------------------------------------         }
{                                                                          }
{  Effet     : Retourne l'entier long <L> en chane de caractre, dans sa  }
{              reprsentation binaire.                                     }
{                                                                          }
{  Vitesse   : 7800/s                                                      }
{                                                                          }
{ -------------------------------------------------------------------------}

Procedure Test3;
Begin
  S1 := LtoB(123456789);
  S1 := LtoB($fe00fe00);
  S1 := LtoB(0);
  S1 := LtoB(-10);
end;

{  ---------------------------------------------------------------         }
{  Function   LtoO(L: LongInt): String;                                    }
{  ---------------------------------------------------------------         }
{                                                                          }
{  Effet     : Retourne l'entier long <L> en chane de caractre, dans sa  }
{              reprsentation octale.                                      }
{                                                                          }
{  Vitesse   : 7800/s                                                      }
{                                                                          }
{ -------------------------------------------------------------------------}

Procedure Test4;
Begin
  S1 := LtoO(123456789);
  S1 := LtoO($fe00fe00);
  S1 := LtoO(0);
  S1 := LtoO(-10);
end;

{  ---------------------------------------------------------------         }
{  Function   WtoH(W: Word): String;                                       }
{  ---------------------------------------------------------------         }
{                                                                          }
{  Effet     : Retourne le mot <W> en chane de caractre, dans sa         }
{              reprsentation hxadcimale.                                }
{                                                                          }
{  Vitesse   : 7800/s                                                      }
{                                                                          }
{ -------------------------------------------------------------------------}

Procedure Test5;
Begin
  S1 := WtoH(1234);
  S1 := WtoH($fe00);
  S1 := WtoH(0);
  S1 := WtoH($10);
end;

{  ---------------------------------------------------------------         }
{  Function   WtoB(W: Word): String;                                       }
{  ---------------------------------------------------------------         }
{                                                                          }
{  Effet     : Retourne le mot <W> en chane de caractre, dans sa         }
{              reprsentation binaire.                                     }
{                                                                          }
{  Vitesse   : 7800/s                                                      }
{                                                                          }
{ -------------------------------------------------------------------------}

Procedure Test6;
Begin
  S1 := WtoB(1234);
  S1 := WtoB($fe00);
  S1 := WtoB(0);
  S1 := WtoB($10);
end;

{  ---------------------------------------------------------------         }
{  Function   WtoO(W: Word): String;                                       }
{  ---------------------------------------------------------------         }
{                                                                          }
{  Effet     : Retourne le mot <W> en chane de caractre, dans sa         }
{              reprsentation octale.                                      }
{                                                                          }
{  Vitesse   : 7800/s                                                      }
{                                                                          }
{ -------------------------------------------------------------------------}

Procedure Test7;
Begin
  S1 := WtoO(1234);
  S1 := WtoO($fe00);
  S1 := WtoO(0);
  S1 := WtoO($10);
end;

{  ---------------------------------------------------------------         }
{  Function   BtoH(B: Byte): String;                                       }
{  ---------------------------------------------------------------         }
{                                                                          }
{  Effet     : Retourne l'octet <B> en chane de caractre, dans sa        }
{              reprsentation hxadcimale.                                }
{                                                                          }
{  Vitesse   : 7800/s                                                      }
{                                                                          }
{ -------------------------------------------------------------------------}

Procedure Test8;
Begin
  S1 := BtoH(34);
  S1 := BtoH($fe);
  S1 := BtoH(0);
  S1 := BtoH($10);
end;

{  ---------------------------------------------------------------         }
{  Function   BtoB(B: Byte): String;                                       }
{  ---------------------------------------------------------------         }
{                                                                          }
{  Effet     : Retourne l'octet <B> en chane de caractre, dans sa        }
{              reprsentation binaire.                                     }
{                                                                          }
{  Vitesse   : 7800/s                                                      }
{                                                                          }
{ -------------------------------------------------------------------------}

Procedure Test9;
Begin
  S1 := BtoB(34);
  S1 := BtoB($fe);
  S1 := BtoB(0);
  S1 := BtoB($10);
end;

{  ---------------------------------------------------------------         }
{  Function   BtoO(B: Byte): String;                                       }
{  ---------------------------------------------------------------         }
{                                                                          }
{  Effet     : Retourne l'octet <B> en chane de caractre, dans sa        }
{              reprsentation octale.                                      }
{                                                                          }
{  Vitesse   : 7800/s                                                      }
{                                                                          }
{ -------------------------------------------------------------------------}

Procedure Test10;
Begin
  S1 := BtoO(34);
  S1 := BtoO($fe);
  S1 := BtoO(0);
  S1 := BtoO($10);
end;

{  ---------------------------------------------------------------         }
{  Function   PtoH(P: Pointer): String;                                    }
{  ---------------------------------------------------------------         }
{                                                                          }
{  Effet     : Retourne le pointeur <P> en chane de caractre, dans sa    }
{              reprsentation hxadcimale.                                }
{                                                                          }
{  Vitesse   : 7800/s                                                      }
{                                                                          }
{ -------------------------------------------------------------------------}

Procedure Test11;
Begin
  S1 := PtoH(nil);
  S1 := PtoH(Ptr($40,$40));
end;

{  ---------------------------------------------------------------         }
{  Function   AtoR(Str: String): Real;                                     }
{  ---------------------------------------------------------------         }
{                                                                          }
{  Effet     : Retourne la chane <Str> en rl.                           }
{                                                                          }
{  Vitesse   : 7800/s                                                      }
{                                                                          }
{ -------------------------------------------------------------------------}

Procedure Test12;
Begin
  R := AtoR('3.14115');
  R := AtoR('0.00012345');
end;

{  ---------------------------------------------------------------         }
{  Function   AtoL(Str: String): LongInt;                                  }
{  ---------------------------------------------------------------         }
{                                                                          }
{  Effet     : Retourne la chane <Str> en entier long.                    }
{                                                                          }
{  Vitesse   : 7800/s                                                      }
{                                                                          }
{ -------------------------------------------------------------------------}

Procedure Test13;
Begin
  L := AtoL('3.14115');
  L := AtoL('12345');
end;

{  ---------------------------------------------------------------         }
{  Function   AtoH(Str: String): Integer;                                  }
{  ---------------------------------------------------------------         }
{                                                                          }
{  Effet     : Retourne la chane <Str> reprsentant un entier sous sa     }
{              forme hxadcimale, en entier.                              }
{                                                                          }
{  Vitesse   : 7800/s                                                      }
{                                                                          }
{ -------------------------------------------------------------------------}

Procedure Test14;
Begin
  L := AtoH('$3115');
  L := AtoH('$0');
end;

{  ---------------------------------------------------------------         }
{  Function   AtolH(Str: String): LongInt;                                 }
{  ---------------------------------------------------------------         }
{                                                                          }
{  Effet     : Retourne la chane <Str> reprsentant un entier long sous sa}
{              forme hxadcimale, en entier long.                         }
{                                                                          }
{  Vitesse   : 7800/s                                                      }
{                                                                          }
{ -------------------------------------------------------------------------}

Procedure Test15;
Begin
  L := AtolH('$31154987');
  L := AtolH('$0');
end;

{  ---------------------------------------------------------------         }
{  Function   ValidInt(Str: String): Boolean;                              }
{  ---------------------------------------------------------------         }
{                                                                          }
{  Effet     : Retourne Vrai si la chane <Str> reprsente un entier en    }
{              base dcimale.                                              }
{                                                                          }
{  Vitesse   : 7800/s                                                      }
{                                                                          }
{ -------------------------------------------------------------------------}

Procedure Test16;
Begin
  Ok := ValidInt('$31154987');
  Ok := ValidInt('abcdef');
  Ok := ValidInt('3.14');
  Ok := ValidInt('3,14');
end;

{  ---------------------------------------------------------------         }
{  Function   ValidHInt(Str: String): Boolean;                             }
{  ---------------------------------------------------------------         }
{                                                                          }
{  Effet     : Retourne Vrai si la chane <Str> reprsente un entier sous  }
{              sa forme hxadcimale.                                      }
{                                                                          }
{  Vitesse   : 7800/s                                                      }
{                                                                          }
{ -------------------------------------------------------------------------}

Procedure Test17;
Begin
  Ok := ValidhInt('$31154987');
  Ok := ValidhInt('abcdef');
  Ok := ValidhInt('3.14');
  Ok := ValidInt('3,14');
end;

{  ---------------------------------------------------------------         }
{  Function   ValidReal(Str: String): Boolean;                             }
{  ---------------------------------------------------------------         }
{                                                                          }
{  Effet     : Retourne Vrai si la chane <Str> reprsente un rel.        }
{                                                                          }
{  Vitesse   : 7800/s                                                      }
{                                                                          }
{ -------------------------------------------------------------------------}

Procedure Test18;
Begin
  Ok := ValidReal('$31154987');
  Ok := ValidReal('abcdef');
  Ok := ValidReal('3.14');
  Ok := ValidInt('3,14');
end;

Begin
  Test1;
  Test2;
  Test3;
  Test4;
  Test5;
  Test6;
  Test7;
  Test8;
  Test9;
  Test10;
  Test11;
  Test12;
  Test13;
  Test14;
  Test15;
  Test16;
  Test17;
  Test18;
End.

{ -------------------------------------------------------------------------}
